/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.feature;

import java.util.HashMap;
import java.util.Map;
import journeymap.client.feature.Feature;
import journeymap.client.feature.Policy;
import journeymap.common.Journeymap;
import journeymap.server.properties.PermissionProperties;

public enum FeatureManager {
    INSTANCE;

    private final HashMap<Feature, Policy> policyMap = new HashMap();

    private FeatureManager() {
        this.reset();
    }

    public static String getPolicyDetails() {
        StringBuilder sb = new StringBuilder("Features: ");
        for (Feature feature : Feature.values()) {
            boolean single = false;
            boolean multi = false;
            if (FeatureManager.INSTANCE.policyMap.containsKey((Object)feature)) {
                single = FeatureManager.INSTANCE.policyMap.get((Object)((Object)feature)).allowInSingleplayer;
                multi = FeatureManager.INSTANCE.policyMap.get((Object)((Object)feature)).allowInMultiplayer;
            }
            sb.append(String.format("\n\t%s : singleplayer = %s , multiplayer = %s", feature.name(), single, multi));
        }
        return sb.toString();
    }

    public static boolean isAllowed(Feature feature) {
        Policy policy = FeatureManager.INSTANCE.policyMap.get((Object)feature);
        return policy != null && policy.isCurrentlyAllowed();
    }

    public static Map<Feature, Boolean> getAllowedFeatures() {
        HashMap<Feature, Boolean> map = new HashMap<Feature, Boolean>(Feature.values().length * 2);
        for (Feature feature : Feature.values()) {
            map.put(feature, FeatureManager.isAllowed(feature));
        }
        return map;
    }

    public void updateDimensionFeatures(PermissionProperties properties) {
        this.reset();
        if (!properties.caveMappingEnabled.get().booleanValue()) {
            Journeymap.getLogger().info("Feature disabled in multiplayer: " + (Object)((Object)Feature.MapCaves));
            this.policyMap.put(Feature.MapCaves, new Policy(Feature.MapCaves, true, false));
        }
        if (properties.radarEnabled.get().booleanValue()) {
            this.setMultiplayerFeature(Feature.RadarAnimals, properties.animalRadarEnabled.get());
            this.setMultiplayerFeature(Feature.RadarMobs, properties.mobRadarEnabled.get());
            this.setMultiplayerFeature(Feature.RadarPlayers, properties.playerRadarEnabled.get());
            this.setMultiplayerFeature(Feature.RadarVillagers, properties.villagerRadarEnabled.get());
        } else {
            this.setMultiplayerFeature(Feature.RadarAnimals, false);
            this.setMultiplayerFeature(Feature.RadarMobs, false);
            this.setMultiplayerFeature(Feature.RadarPlayers, false);
            this.setMultiplayerFeature(Feature.RadarVillagers, false);
        }
    }

    private void setMultiplayerFeature(Feature feature, boolean enable) {
        if (!enable) {
            Journeymap.getLogger().info("Feature disabled in multiplayer: " + (Object)((Object)feature));
        }
        this.policyMap.put(feature, new Policy(feature, true, enable));
    }

    public void reset() {
        for (Policy policy : Policy.bulkCreate(true, true)) {
            this.policyMap.put(policy.feature, policy);
        }
    }
}

