/*
 * Decompiled with CFR 0.152.
 */
package nex.world.gen;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import lex.world.biome.BiomeWrapper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.ChunkGeneratorHell;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCavesHell;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.MapGenNetherBridge;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.ChunkGeneratorEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.InitNoiseGensEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;
import nex.handler.ConfigHandler;
import nex.world.biome.NetherExBiomeManager;

public class ChunkGeneratorNetherEx
extends ChunkGeneratorHell {
    private final World world;
    private final Random rand;
    private NoiseGeneratorOctaves noiseGen1;
    private NoiseGeneratorOctaves noiseGen2;
    private NoiseGeneratorOctaves noiseGen3;
    private NoiseGeneratorOctaves soulSandGravelNoiseGen;
    private NoiseGeneratorOctaves netherrackNoiseGen;
    private NoiseGeneratorPerlin terrainNoiseGen;
    private NoiseGeneratorOctaves scaleNoiseGen;
    private NoiseGeneratorOctaves depthNoiseGen;
    private Biome[] biomesForGen;
    private double[] buffer;
    private double[] netherrackNoise = new double[256];
    private double[] soulSandNoise = new double[256];
    private double[] gravelNoise = new double[256];
    private double[] noiseData1;
    private double[] noiseData2;
    private double[] noiseData3;
    private double[] terrainNoise = new double[256];
    private double[] scaleNoise;
    private double[] depthNoise;
    private MapGenCavesHell netherCaves = new MapGenCavesHell();
    private MapGenNetherBridge netherBridge = new MapGenNetherBridge();

    public ChunkGeneratorNetherEx(World world) {
        super(world, true, world.func_72905_C());
        this.world = world;
        this.rand = new Random(this.world.func_72905_C());
        this.noiseGen1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen3 = new NoiseGeneratorOctaves(this.rand, 8);
        this.soulSandGravelNoiseGen = new NoiseGeneratorOctaves(this.rand, 4);
        this.netherrackNoiseGen = new NoiseGeneratorOctaves(this.rand, 4);
        this.scaleNoiseGen = new NoiseGeneratorOctaves(this.rand, 10);
        this.depthNoiseGen = new NoiseGeneratorOctaves(this.rand, 16);
        this.terrainNoiseGen = new NoiseGeneratorPerlin(this.rand, 4);
        InitNoiseGensEvent.ContextHell ctx = new InitNoiseGensEvent.ContextHell(this.noiseGen1, this.noiseGen2, this.noiseGen3, this.soulSandGravelNoiseGen, this.netherrackNoiseGen, this.scaleNoiseGen, this.depthNoiseGen);
        ctx = (InitNoiseGensEvent.ContextHell)TerrainGen.getModdedNoiseGenerators((World)this.world, (Random)this.rand, (InitNoiseGensEvent.Context)ctx);
        this.noiseGen1 = ctx.getLPerlin1();
        this.noiseGen2 = ctx.getLPerlin2();
        this.noiseGen3 = ctx.getPerlin();
        this.soulSandGravelNoiseGen = ctx.getPerlin2();
        this.netherrackNoiseGen = ctx.getPerlin3();
        this.scaleNoiseGen = ctx.getScale();
        this.depthNoiseGen = ctx.getDepth();
        this.netherCaves = (MapGenCavesHell)TerrainGen.getModdedMapGen((MapGenBase)this.netherCaves, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.NETHER_CAVE);
        this.netherBridge = (MapGenNetherBridge)TerrainGen.getModdedMapGen((MapGenBase)this.netherBridge, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.NETHER_BRIDGE);
        world.func_181544_b(31);
    }

    public void func_185936_a(int chunkX, int chunkZ, ChunkPrimer primer) {
        this.buffer = this.generateHeightMap(this.buffer, chunkX * 4, 0, chunkZ * 4, 5, 17, 5);
        for (int x = 0; x < 4; ++x) {
            for (int z = 0; z < 4; ++z) {
                for (int y = 0; y < 16; ++y) {
                    double d1 = this.buffer[(x * 5 + z) * 17 + y];
                    double d2 = this.buffer[(x * 5 + z + 1) * 17 + y];
                    double d3 = this.buffer[((x + 1) * 5 + z) * 17 + y];
                    double d4 = this.buffer[((x + 1) * 5 + z + 1) * 17 + y];
                    double d5 = (this.buffer[(x * 5 + z) * 17 + y + 1] - d1) * 0.125;
                    double d6 = (this.buffer[(x * 5 + z + 1) * 17 + y + 1] - d2) * 0.125;
                    double d7 = (this.buffer[((x + 1) * 5 + z) * 17 + y + 1] - d3) * 0.125;
                    double d8 = (this.buffer[((x + 1) * 5 + z + 1) * 17 + y + 1] - d4) * 0.125;
                    for (int y2 = 0; y2 < 8; ++y2) {
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * 0.25;
                        double d13 = (d4 - d2) * 0.25;
                        for (int x2 = 0; x2 < 4; ++x2) {
                            double d15 = d10;
                            double d16 = (d11 - d10) * 0.25;
                            for (int z2 = 0; z2 < 4; ++z2) {
                                int posX = x2 + x * 4;
                                int posY = y2 + y * 8;
                                int posZ = z2 + z * 4;
                                IBlockState state = null;
                                if (posY < 32) {
                                    state = Blocks.field_150353_l.func_176223_P();
                                }
                                if (d15 > 0.0) {
                                    state = Blocks.field_150424_aL.func_176223_P();
                                }
                                primer.func_177855_a(posX, posY, posZ, state);
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void func_185937_b(int chunkX, int chunkZ, ChunkPrimer primer) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)chunkX, (int)chunkZ, (ChunkPrimer)primer, (World)this.world)) {
            return;
        }
        this.soulSandNoise = this.soulSandGravelNoiseGen.func_76304_a(this.soulSandNoise, chunkX * 16, chunkZ * 16, 0, 16, 16, 1, 0.03125, 0.03125, 1.0);
        this.gravelNoise = this.soulSandGravelNoiseGen.func_76304_a(this.gravelNoise, chunkX * 16, 109, chunkZ * 16, 16, 1, 16, 0.03125, 1.0, 0.03125);
        this.netherrackNoise = this.netherrackNoiseGen.func_76304_a(this.netherrackNoise, chunkX * 16, chunkZ * 16, 0, 16, 16, 1, 0.0625, 0.0625, 0.0625);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int l = (int)(this.netherrackNoise[x + z * 16] / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
                int i1 = -1;
                boolean genSoulSand = this.soulSandNoise[x + z * 16] + this.rand.nextDouble() * 0.2 > 0.0;
                boolean genGravel = this.gravelNoise[x + z * 16] + this.rand.nextDouble() * 0.2 > 0.0;
                IBlockState floorTopBlock = Blocks.field_150424_aL.func_176223_P();
                IBlockState floorFillerBlock = Blocks.field_150424_aL.func_176223_P();
                for (int y = 127; y >= 0; --y) {
                    if (y < 127 && y > 0) {
                        IBlockState checkBlock = primer.func_177856_a(x, y, z);
                        if (checkBlock.func_185904_a() != Material.field_151579_a) {
                            if (checkBlock != Blocks.field_150424_aL.func_176223_P()) continue;
                            if (i1 == -1) {
                                if (l <= 0) {
                                    floorTopBlock = Blocks.field_150350_a.func_176223_P();
                                    floorFillerBlock = Blocks.field_150424_aL.func_176223_P();
                                } else if (y >= 62 && y <= 66) {
                                    floorTopBlock = Blocks.field_150424_aL.func_176223_P();
                                    floorFillerBlock = Blocks.field_150424_aL.func_176223_P();
                                    if (ConfigHandler.dimensionConfig.nether.generateGravel && genGravel) {
                                        floorTopBlock = Blocks.field_150351_n.func_176223_P();
                                    }
                                    if (ConfigHandler.dimensionConfig.nether.generateSoulSand && genSoulSand) {
                                        floorTopBlock = Blocks.field_150425_aM.func_176223_P();
                                        floorFillerBlock = Blocks.field_150425_aM.func_176223_P();
                                    }
                                }
                                if (y <= 32 && (floorTopBlock == null || floorTopBlock.func_185904_a() == Material.field_151579_a)) {
                                    floorTopBlock = Blocks.field_150353_l.func_176223_P();
                                }
                                i1 = l;
                                if (y >= 64) {
                                    primer.func_177855_a(x, y, z, floorTopBlock);
                                    continue;
                                }
                                primer.func_177855_a(x, y, z, floorFillerBlock);
                                continue;
                            }
                            if (i1 <= 0) continue;
                            --i1;
                            primer.func_177855_a(x, y, z, floorFillerBlock);
                            continue;
                        }
                        i1 = -1;
                        continue;
                    }
                    primer.func_177855_a(x, y, z, Blocks.field_150357_h.func_176223_P());
                }
            }
        }
    }

    private double[] generateHeightMap(double[] heightMap, int posX, int posY, int posZ, int xSize, int ySize, int zSize) {
        if (heightMap == null) {
            heightMap = new double[xSize * ySize * zSize];
        }
        ChunkGeneratorEvent.InitNoiseField event = new ChunkGeneratorEvent.InitNoiseField((IChunkGenerator)this, heightMap, posX, posY, posZ, xSize, ySize, zSize);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return event.getNoisefield();
        }
        this.scaleNoise = this.scaleNoiseGen.func_76304_a(this.scaleNoise, posX, posY, posZ, xSize, 1, zSize, 1.0, 0.0, 1.0);
        this.depthNoise = this.depthNoiseGen.func_76304_a(this.depthNoise, posX, posY, posZ, xSize, 1, zSize, 100.0, 0.0, 100.0);
        this.noiseData1 = this.noiseGen3.func_76304_a(this.noiseData1, posX, posY, posZ, xSize, ySize, zSize, 8.555150000000001, 34.2206, 8.555150000000001);
        this.noiseData2 = this.noiseGen1.func_76304_a(this.noiseData2, posX, posY, posZ, xSize, ySize, zSize, 684.412, 2053.236, 684.412);
        this.noiseData3 = this.noiseGen2.func_76304_a(this.noiseData3, posX, posY, posZ, xSize, ySize, zSize, 684.412, 2053.236, 684.412);
        double[] newYSize = new double[ySize];
        for (int j = 0; j < ySize; ++j) {
            newYSize[j] = Math.cos((double)j * Math.PI * 6.0 / (double)ySize) * 2.0;
            double d2 = j;
            if (j > ySize / 2) {
                d2 = ySize - 1 - j;
            }
            if (!(d2 < 4.0)) continue;
            d2 = 4.0 - d2;
            int n = j;
            newYSize[n] = newYSize[n] - d2 * d2 * d2 * 10.0;
        }
        int index = 0;
        for (int l = 0; l < xSize; ++l) {
            for (int i1 = 0; i1 < zSize; ++i1) {
                for (int k = 0; k < ySize; ++k) {
                    double d4 = newYSize[k];
                    double d5 = this.noiseData2[index] / 512.0;
                    double d6 = this.noiseData3[index] / 512.0;
                    double d7 = (this.noiseData1[index] / 10.0 + 1.0) / 2.0;
                    double d8 = d7 < 0.0 ? d5 : (d7 > 1.0 ? d6 : d5 + (d6 - d5) * d7);
                    d8 -= d4;
                    if (k > ySize - 4) {
                        double d9 = (float)(k - (ySize - 4)) / 3.0f;
                        d8 = d8 * (1.0 - d9) + -10.0 * d9;
                    }
                    if ((double)k < 0.0) {
                        double d10 = (0.0 - (double)k) / 4.0;
                        d10 = MathHelper.func_151237_a((double)d10, (double)0.0, (double)1.0);
                        d8 = d8 * (1.0 - d10) + -10.0 * d10;
                    }
                    heightMap[index] = d8;
                    ++index;
                }
            }
        }
        return heightMap;
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        ChunkPrimer primer = new ChunkPrimer();
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        this.biomesForGen = this.world.func_72959_q().func_76933_b(null, chunkX * 16, chunkZ * 16, 16, 16);
        this.func_185936_a(chunkX, chunkZ, primer);
        this.func_185937_b(chunkX, chunkZ, primer);
        this.replaceBiomeBlocks(chunkX, chunkZ, primer, this.biomesForGen);
        this.netherCaves.func_186125_a(this.world, chunkX, chunkZ, primer);
        this.netherBridge.func_186125_a(this.world, chunkX, chunkZ, primer);
        Chunk chunk = new Chunk(this.world, primer, chunkX, chunkZ);
        byte[] biomeArray = chunk.func_76605_m();
        for (int i = 0; i < biomeArray.length; ++i) {
            biomeArray[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGen[i]);
        }
        chunk.func_76613_n();
        return chunk;
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
        BlockPos blockPos = new BlockPos(chunkX * 16, 0, chunkZ * 16);
        BiomeWrapper wrapper = NetherExBiomeManager.getBiomeWrapper(this.world.func_180494_b(blockPos.func_177982_a(16, 0, 16)));
        BlockFalling.field_149832_M = true;
        boolean hasVillageGenerated = false;
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre((IChunkGenerator)this, this.world, this.rand, chunkX, chunkZ, hasVillageGenerated));
        this.netherBridge.func_175794_a(this.world, this.rand, chunkPos);
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Populate((IChunkGenerator)this, this.world, this.rand, chunkX, chunkZ, hasVillageGenerated, PopulateChunkEvent.Populate.EventType.CUSTOM));
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post((IChunkGenerator)this, this.world, this.rand, chunkX, chunkZ, hasVillageGenerated));
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(this.world, this.rand, chunkPos));
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Decorate(this.world, this.rand, chunkPos, blockPos, DecorateBiomeEvent.Decorate.EventType.CUSTOM));
        if (wrapper != null && wrapper.shouldGenDefaultFeatures()) {
            wrapper.getBiome().func_180624_a(this.world, this.rand, blockPos);
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(this.world, this.rand, chunkPos));
        MinecraftForge.EVENT_BUS.post((Event)new OreGenEvent.Pre(this.world, this.rand, blockPos));
        MinecraftForge.EVENT_BUS.post((Event)new OreGenEvent.GenerateMinable(this.world, this.rand, (WorldGenerator)new WorldGenMinable(Blocks.field_150350_a.func_176223_P(), 0, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150350_a)), blockPos, OreGenEvent.GenerateMinable.EventType.CUSTOM));
        MinecraftForge.EVENT_BUS.post((Event)new OreGenEvent.Post(this.world, this.rand, blockPos));
        BlockFalling.field_149832_M = false;
    }

    public boolean func_185933_a(Chunk chunk, int chunkX, int chunkZ) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        if (creatureType == EnumCreatureType.MONSTER) {
            if (this.netherBridge.func_175795_b(pos)) {
                return this.netherBridge.func_75059_a();
            }
            if (this.netherBridge.func_175796_a(this.world, pos) && this.world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150385_bj) {
                return this.netherBridge.func_75059_a();
            }
        }
        BiomeWrapper wrapper = NetherExBiomeManager.getBiomeWrapper(this.world.func_180494_b(pos));
        return creatureType == null || wrapper == null ? new ArrayList() : wrapper.getSpawnableMobs(creatureType);
    }

    public BlockPos func_180513_a(World world, String structureName, BlockPos pos, boolean force) {
        if ("Fortress".equalsIgnoreCase(structureName)) {
            return this.netherBridge != null ? this.netherBridge.func_180706_b(world, pos, force) : null;
        }
        return null;
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        if ("Fortress".equalsIgnoreCase(structureName)) {
            return this.netherBridge != null && this.netherBridge.func_175795_b(pos);
        }
        return false;
    }

    public void func_180514_a(Chunk chunk, int chunkX, int chunkZ) {
        this.netherBridge.func_186125_a(this.world, chunkX, chunkZ, null);
    }

    private void replaceBiomeBlocks(int chunkX, int chunkZ, ChunkPrimer primer, Biome[] biomes) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)chunkX, (int)chunkZ, (ChunkPrimer)primer, (World)this.world)) {
            return;
        }
        this.terrainNoise = this.terrainNoiseGen.func_151599_a(this.terrainNoise, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, 0.0625, 0.0625, 1.0);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                BiomeWrapper wrapper = NetherExBiomeManager.getBiomeWrapper(biomes[x + z * 16]);
                if (wrapper == null) continue;
                Biome biome = wrapper.getBiome();
                ResourceLocation biomeName = biome.getRegistryName();
                if (!biomeName.func_110624_b().equalsIgnoreCase("biomesoplenty")) {
                    IBlockState surfaceBlock = wrapper.getBlock("topBlock", biome.field_76752_A);
                    IBlockState fillerBlock = wrapper.getBlock("fillerBlock", biome.field_76753_B);
                    IBlockState wallBlock = wrapper.getBlock("wallBlock", biome.field_76753_B);
                    IBlockState ceilingBottomBlock = wrapper.getBlock("ceilingBottomBlock", biome.field_76753_B);
                    IBlockState ceilingFillerBlock = wrapper.getBlock("ceilingFillerBlock", biome.field_76753_B);
                    IBlockState oceanBlock = wrapper.getBlock("oceanBlock", Blocks.field_150353_l.func_176223_P());
                    int localX = chunkX * 16 + x & 0xF;
                    int localZ = chunkZ * 16 + z & 0xF;
                    boolean wasLastBlockSolid = true;
                    for (int localY = 127; localY >= 0; --localY) {
                        IBlockState state;
                        int blocksToSkip = 0;
                        IBlockState checkState = primer.func_177856_a(localX, localY, localZ);
                        if (checkState.func_177230_c() == Blocks.field_150424_aL) {
                            primer.func_177855_a(localX, localY, localZ, wallBlock);
                            if (!wasLastBlockSolid) {
                                primer.func_177855_a(localX, localY, localZ, surfaceBlock);
                                for (int floorOffset = 1; floorOffset <= 3 && localY - floorOffset >= 0; ++floorOffset) {
                                    state = primer.func_177856_a(localX, localY - floorOffset, localZ);
                                    blocksToSkip = floorOffset;
                                    if (state.func_177230_c() != Blocks.field_150424_aL) break;
                                    primer.func_177855_a(localX, localY - floorOffset, localZ, fillerBlock);
                                }
                            }
                            wasLastBlockSolid = true;
                        } else if (checkState.func_177230_c() == Blocks.field_150350_a) {
                            if (wasLastBlockSolid) {
                                if (localY + 1 < 128) {
                                    primer.func_177855_a(localX, localY + 1, localZ, ceilingBottomBlock);
                                }
                                for (int roofOffset = 2; roofOffset <= 4 && localY + roofOffset <= 127 && ((state = primer.func_177856_a(localX, localY + roofOffset, localZ)).func_177230_c() == Blocks.field_150424_aL || state == wallBlock); ++roofOffset) {
                                    primer.func_177855_a(localX, localY + roofOffset, localZ, ceilingFillerBlock);
                                }
                            }
                            wasLastBlockSolid = false;
                        } else if (checkState == Blocks.field_150353_l.func_176223_P()) {
                            primer.func_177855_a(localX, localY, localZ, oceanBlock);
                            wasLastBlockSolid = false;
                        }
                        localY -= blocksToSkip;
                    }
                    continue;
                }
                biome.func_180622_a(this.world, this.rand, primer, chunkX * 16 + x, chunkZ * 16 + z, this.terrainNoise[x + z * 16]);
            }
        }
    }
}

