/*
 * Decompiled with CFR 0.152.
 */
package nex.village;

import com.mojang.authlib.GameProfile;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import nex.entity.neutral.EntityGoldGolem;
import nex.entity.passive.EntityPigtificate;
import nex.village.PigtificateVillageFenceGateInfo;

public class PigtificateVillage {
    private WeakReference<World> world;
    private final List<PigtificateVillageFenceGateInfo> fenceGates = new ArrayList<PigtificateVillageFenceGateInfo>();
    private BlockPos adjustedCenter = BlockPos.field_177992_a;
    private BlockPos center = BlockPos.field_177992_a;
    private int radius;
    private int lastAddedFenceGateTime;
    private int tickCounter;
    private int pigtificateAmount;
    private int matingCounter;
    private final Map<UUID, Integer> playerReputations = new HashMap<UUID, Integer>();
    private final List<VillageAggressor> aggressors = new ArrayList<VillageAggressor>();
    private int golemAmount;

    public PigtificateVillage() {
    }

    public PigtificateVillage(World world) {
        this.world = new WeakReference<World>(world);
    }

    public World getWorld() {
        return (World)this.world.get();
    }

    public void setWorld(World world) {
        this.world = new WeakReference<World>(world);
    }

    public void tick(int tickCounter) {
        World world = (World)this.world.get();
        if (world != null) {
            Vec3d randomPos;
            int i;
            this.tickCounter = tickCounter;
            this.updateFenceGates();
            this.updateAggressors();
            if (tickCounter % 20 == 0) {
                this.updatePigtificates();
            }
            if (tickCounter % 30 == 0) {
                this.updateGolems();
            }
            if (this.golemAmount < (i = this.pigtificateAmount / 10) && this.fenceGates.size() > 20 && world.field_73012_v.nextInt(7000) == 0 && (randomPos = this.findRandomSpawnPos(this.center, 2, 4, 2)) != null) {
                EntityGoldGolem golem = new EntityGoldGolem(world);
                golem.func_70107_b(randomPos.field_72450_a, randomPos.field_72448_b, randomPos.field_72449_c);
                world.func_72838_d((Entity)golem);
                ++this.golemAmount;
            }
        }
    }

    private Vec3d findRandomSpawnPos(BlockPos pos, int x, int y, int z) {
        World world = (World)this.world.get();
        if (world != null) {
            for (int i = 0; i < 10; ++i) {
                BlockPos blockPos = pos.func_177982_a(world.field_73012_v.nextInt(16) - 8, world.field_73012_v.nextInt(6) - 3, world.field_73012_v.nextInt(16) - 8);
                if (!this.isBlockPosWithinSqVillageRadius(blockPos) || !this.isAreaClearAround(new BlockPos(x, y, z), blockPos)) continue;
                return new Vec3d((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p());
            }
        }
        return null;
    }

    private boolean isAreaClearAround(BlockPos size, BlockPos pos) {
        World world = (World)this.world.get();
        if (world != null) {
            if (!world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos, EnumFacing.UP)) {
                return false;
            }
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            int posX = pos.func_177958_n() - size.func_177958_n() / 2;
            int posZ = pos.func_177952_p() - size.func_177952_p() / 2;
            for (int x = posX; x < posX + size.func_177958_n(); ++x) {
                for (int y = pos.func_177956_o(); y < pos.func_177956_o() + size.func_177956_o(); ++y) {
                    for (int z = posZ; z < posZ + size.func_177952_p(); ++z) {
                        if (!world.func_180495_p((BlockPos)mutableBlockPos.func_181079_c(x, y, z)).func_185915_l()) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    private void updateGolems() {
        World world = (World)this.world.get();
        if (world != null) {
            List golems = world.func_72872_a(EntityGoldGolem.class, new AxisAlignedBB((double)(this.center.func_177958_n() - this.radius), (double)(this.center.func_177956_o() - 4), (double)(this.center.func_177952_p() - this.radius), (double)(this.center.func_177958_n() + this.radius), (double)(this.center.func_177956_o() + 4), (double)(this.center.func_177952_p() + this.radius)));
            this.golemAmount = golems.size();
        }
    }

    private void updatePigtificates() {
        World world = (World)this.world.get();
        if (world != null) {
            List pigtificates = world.func_72872_a(EntityPigtificate.class, new AxisAlignedBB((double)(this.center.func_177958_n() - this.radius), (double)(this.center.func_177956_o() - 4), (double)(this.center.func_177952_p() - this.radius), (double)(this.center.func_177958_n() + this.radius), (double)(this.center.func_177956_o() + 4), (double)(this.center.func_177952_p() + this.radius)));
            this.pigtificateAmount = pigtificates.size();
            if (this.pigtificateAmount == 0) {
                this.playerReputations.clear();
            }
        }
    }

    public BlockPos getCenter() {
        return this.center;
    }

    public int getRadius() {
        return this.radius;
    }

    public int getVillageFenceGateAmount() {
        return this.fenceGates.size();
    }

    public int getTicksSinceLastFenceGateAdded() {
        return this.tickCounter - this.lastAddedFenceGateTime;
    }

    public int getPigtificateAmount() {
        return this.pigtificateAmount;
    }

    public boolean isBlockPosWithinSqVillageRadius(BlockPos pos) {
        return this.center.func_177951_i((Vec3i)pos) < (double)(this.radius * this.radius);
    }

    public List<PigtificateVillageFenceGateInfo> getFenceGates() {
        return this.fenceGates;
    }

    public PigtificateVillageFenceGateInfo getNearestFenceGate(BlockPos pos) {
        PigtificateVillageFenceGateInfo fenceGateInfo = null;
        int maxDistance = Integer.MAX_VALUE;
        for (PigtificateVillageFenceGateInfo testFenceGate : this.fenceGates) {
            int distanceToFenceGate = testFenceGate.getDistanceToFenceGateSq(pos);
            if (distanceToFenceGate >= maxDistance) continue;
            fenceGateInfo = testFenceGate;
            maxDistance = distanceToFenceGate;
        }
        return fenceGateInfo;
    }

    public PigtificateVillageFenceGateInfo getFenceGateInfo(BlockPos pos) {
        World world = (World)this.world.get();
        if (world != null) {
            PigtificateVillageFenceGateInfo fenceGateInfo = null;
            int maxDistance = Integer.MAX_VALUE;
            for (PigtificateVillageFenceGateInfo testFenceGate : this.fenceGates) {
                EnumFacing facing;
                BlockPos blockPos;
                int distanceToFenceGate = testFenceGate.getDistanceToFenceGateSq(pos);
                distanceToFenceGate = distanceToFenceGate > 256 ? (distanceToFenceGate *= 1000) : testFenceGate.getOpenRestrictionCounter();
                if (distanceToFenceGate >= maxDistance || !world.func_180495_p((blockPos = testFenceGate.getPos()).func_177967_a(facing = testFenceGate.getInside(), 1)).func_177230_c().func_176205_b((IBlockAccess)world, blockPos.func_177967_a(facing, 1)) || !world.func_180495_p(blockPos.func_177967_a(facing, -1)).func_177230_c().func_176205_b((IBlockAccess)world, blockPos.func_177967_a(facing, -1)) || !world.func_180495_p(blockPos.func_177984_a().func_177967_a(facing, 1)).func_177230_c().func_176205_b((IBlockAccess)world, blockPos.func_177984_a().func_177967_a(facing, 1)) || !world.func_180495_p(blockPos.func_177984_a().func_177967_a(facing, -1)).func_177230_c().func_176205_b((IBlockAccess)world, blockPos.func_177984_a().func_177967_a(facing, -1))) continue;
                fenceGateInfo = testFenceGate;
                maxDistance = distanceToFenceGate;
            }
            return fenceGateInfo;
        }
        return null;
    }

    public PigtificateVillageFenceGateInfo getExistingFenceGate(BlockPos fenceGateBlock) {
        if (this.center.func_177951_i((Vec3i)fenceGateBlock) > (double)(this.radius * this.radius)) {
            return null;
        }
        for (PigtificateVillageFenceGateInfo fenceGateInfo : this.fenceGates) {
            if (fenceGateInfo.getPos().func_177958_n() != fenceGateBlock.func_177958_n() || fenceGateInfo.getPos().func_177952_p() != fenceGateBlock.func_177952_p() || Math.abs(fenceGateInfo.getPos().func_177956_o() - fenceGateBlock.func_177956_o()) > 1) continue;
            return fenceGateInfo;
        }
        return null;
    }

    public void addFenceGateInfo(PigtificateVillageFenceGateInfo fenceGateInfo) {
        this.fenceGates.add(fenceGateInfo);
        this.adjustedCenter = this.adjustedCenter.func_177971_a((Vec3i)fenceGateInfo.getPos());
        this.lastAddedFenceGateTime = fenceGateInfo.getLastActivityTime();
        this.updateVillage();
    }

    public boolean isAnnihilated() {
        return this.fenceGates.isEmpty();
    }

    public void setAggressor(EntityLivingBase entity) {
        for (VillageAggressor aggressor : this.aggressors) {
            if (aggressor.aggressor != entity) continue;
            aggressor.aggressionTime = this.tickCounter;
            return;
        }
        this.aggressors.add(new VillageAggressor(entity, this.tickCounter));
    }

    public EntityLivingBase findNearestVillageAggressor(EntityLivingBase livingEntity) {
        double maxDistance = Double.MAX_VALUE;
        VillageAggressor aggressor = null;
        for (VillageAggressor villageAggressor : this.aggressors) {
            double distanceToAggressor = villageAggressor.aggressor.func_70068_e((Entity)livingEntity);
            if (!(distanceToAggressor <= maxDistance)) continue;
            aggressor = villageAggressor;
            maxDistance = distanceToAggressor;
        }
        return aggressor == null ? null : aggressor.aggressor;
    }

    public EntityPlayer getNearestTargetPlayer(EntityLivingBase villageDefender) {
        World world = (World)this.world.get();
        if (world != null) {
            double maxDistance = Double.MAX_VALUE;
            EntityPlayer player = null;
            for (UUID s : this.playerReputations.keySet()) {
                double distanceToPlayer;
                EntityPlayer entityPlayer;
                if (!this.isPlayerReputationTooLow(s) || (entityPlayer = world.func_152378_a(s)) == null || !((distanceToPlayer = entityPlayer.func_70068_e((Entity)villageDefender)) <= maxDistance)) continue;
                player = entityPlayer;
                maxDistance = distanceToPlayer;
            }
            return player;
        }
        return null;
    }

    private void updateAggressors() {
        this.aggressors.removeIf(aggressor -> !aggressor.aggressor.func_70089_S() || Math.abs(this.tickCounter - aggressor.aggressionTime) > 300);
    }

    private void updateFenceGates() {
        World world = (World)this.world.get();
        if (world != null) {
            boolean update = false;
            boolean resetFenceGateTimer = world.field_73012_v.nextInt(50) == 0;
            Iterator<PigtificateVillageFenceGateInfo> iter = this.fenceGates.iterator();
            while (iter.hasNext()) {
                PigtificateVillageFenceGateInfo fenceGateInfo = iter.next();
                if (resetFenceGateTimer) {
                    fenceGateInfo.resetOpenRestrictionCounter();
                }
                if (Math.abs(this.tickCounter - fenceGateInfo.getLastActivityTime()) <= 1200) continue;
                this.adjustedCenter = this.adjustedCenter.func_177973_b((Vec3i)fenceGateInfo.getPos());
                update = true;
                fenceGateInfo.setDetachedFromVillageFlag(true);
                iter.remove();
            }
            if (update) {
                this.updateVillage();
            }
        }
    }

    private void updateVillage() {
        int fenceGates = this.fenceGates.size();
        if (fenceGates == 0) {
            this.center = BlockPos.field_177992_a;
            this.radius = 0;
        } else {
            this.center = new BlockPos(this.adjustedCenter.func_177958_n() / fenceGates, this.adjustedCenter.func_177956_o() / fenceGates, this.adjustedCenter.func_177952_p() / fenceGates);
            int distanceToFenceGate = 0;
            for (PigtificateVillageFenceGateInfo fenceGateInfo : this.fenceGates) {
                distanceToFenceGate = Math.max(fenceGateInfo.getDistanceToFenceGateSq(this.center), distanceToFenceGate);
            }
            this.radius = Math.max(32, (int)Math.sqrt(distanceToFenceGate) + 1);
        }
    }

    public int getPlayerReputation(UUID playerName) {
        Integer reputation = this.playerReputations.get(playerName);
        return reputation == null ? 0 : reputation;
    }

    private UUID findUUID(String name) {
        World world = (World)this.world.get();
        if (world != null) {
            if (world.func_73046_m() == null) {
                return EntityPlayer.func_175147_b((String)name);
            }
            GameProfile profile = world.func_73046_m().func_152358_ax().func_152655_a(name);
            return profile == null ? EntityPlayer.func_175147_b((String)name) : profile.getId();
        }
        return EntityPlayer.func_175147_b((String)name);
    }

    public int modifyPlayerReputation(UUID playerName, int amount) {
        int reputation = this.getPlayerReputation(playerName);
        int modifiedReputation = MathHelper.func_76125_a((int)(reputation + amount), (int)-30, (int)10);
        this.playerReputations.put(playerName, modifiedReputation);
        return modifiedReputation;
    }

    public boolean isPlayerReputationTooLow(UUID uuid) {
        return this.getPlayerReputation(uuid) <= -15;
    }

    public void readVillageDataFromNBT(NBTTagCompound compound) {
        this.pigtificateAmount = compound.func_74762_e("PopSize");
        this.radius = compound.func_74762_e("Radius");
        this.golemAmount = compound.func_74762_e("Golems");
        this.lastAddedFenceGateTime = compound.func_74762_e("Stable");
        this.tickCounter = compound.func_74762_e("Tick");
        this.matingCounter = compound.func_74762_e("MTick");
        this.center = new BlockPos(compound.func_74762_e("CX"), compound.func_74762_e("CY"), compound.func_74762_e("CZ"));
        this.adjustedCenter = new BlockPos(compound.func_74762_e("ACX"), compound.func_74762_e("ACY"), compound.func_74762_e("ACZ"));
        NBTTagList fenceGates = compound.func_150295_c("FenceGates", 10);
        for (int i = 0; i < fenceGates.func_74745_c(); ++i) {
            NBTTagCompound fenceGate = fenceGates.func_150305_b(i);
            PigtificateVillageFenceGateInfo fenceGateInfo = new PigtificateVillageFenceGateInfo(new BlockPos(fenceGate.func_74762_e("X"), fenceGate.func_74762_e("Y"), fenceGate.func_74762_e("Z")), fenceGate.func_74762_e("IDX"), fenceGate.func_74762_e("IDZ"), fenceGate.func_74762_e("TS"));
            this.fenceGates.add(fenceGateInfo);
        }
        NBTTagList players = compound.func_150295_c("Players", 10);
        for (int j = 0; j < players.func_74745_c(); ++j) {
            NBTTagCompound player = players.func_150305_b(j);
            if (player.func_74764_b("UUID")) {
                this.playerReputations.put(UUID.fromString(player.func_74779_i("UUID")), player.func_74762_e("S"));
                continue;
            }
            this.playerReputations.put(this.findUUID(player.func_74779_i("Name")), player.func_74762_e("S"));
        }
    }

    public void writeVillageDataToNBT(NBTTagCompound compound) {
        compound.func_74768_a("PopSize", this.pigtificateAmount);
        compound.func_74768_a("Radius", this.radius);
        compound.func_74768_a("Golems", this.golemAmount);
        compound.func_74768_a("Stable", this.lastAddedFenceGateTime);
        compound.func_74768_a("Tick", this.tickCounter);
        compound.func_74768_a("MTick", this.matingCounter);
        compound.func_74768_a("CX", this.center.func_177958_n());
        compound.func_74768_a("CY", this.center.func_177956_o());
        compound.func_74768_a("CZ", this.center.func_177952_p());
        compound.func_74768_a("ACX", this.adjustedCenter.func_177958_n());
        compound.func_74768_a("ACY", this.adjustedCenter.func_177956_o());
        compound.func_74768_a("ACZ", this.adjustedCenter.func_177952_p());
        NBTTagList fenceGates = new NBTTagList();
        for (PigtificateVillageFenceGateInfo fenceGateInfo : this.fenceGates) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74768_a("X", fenceGateInfo.getPos().func_177958_n());
            tagCompound.func_74768_a("Y", fenceGateInfo.getPos().func_177956_o());
            tagCompound.func_74768_a("Z", fenceGateInfo.getPos().func_177952_p());
            tagCompound.func_74768_a("IDX", fenceGateInfo.getInsideOffsetX());
            tagCompound.func_74768_a("IDZ", fenceGateInfo.getInsideOffsetZ());
            tagCompound.func_74768_a("TS", fenceGateInfo.getLastActivityTime());
            fenceGates.func_74742_a((NBTBase)tagCompound);
        }
        compound.func_74782_a("FenceGates", (NBTBase)fenceGates);
        NBTTagList players = new NBTTagList();
        for (UUID s : this.playerReputations.keySet()) {
            NBTTagCompound player = new NBTTagCompound();
            try {
                player.func_74778_a("UUID", s.toString());
                player.func_74768_a("S", this.playerReputations.get(s).intValue());
                players.func_74742_a((NBTBase)player);
            }
            catch (RuntimeException runtimeException) {}
        }
        compound.func_74782_a("Players", (NBTBase)players);
    }

    public void endMatingSeason() {
        this.matingCounter = this.tickCounter;
    }

    public boolean isMatingSeason() {
        return this.matingCounter == 0 || this.tickCounter - this.matingCounter >= 3600;
    }

    public void setDefaultPlayerReputation(int defaultReputation) {
        for (UUID uuid : this.playerReputations.keySet()) {
            this.modifyPlayerReputation(uuid, defaultReputation);
        }
    }

    class VillageAggressor {
        public EntityLivingBase aggressor;
        public int aggressionTime;

        VillageAggressor(EntityLivingBase aggressor, int aggressionTime) {
            this.aggressor = aggressor;
            this.aggressionTime = aggressionTime;
        }
    }
}

