/*
 * Decompiled with CFR 0.152.
 */
package nex.handler;

import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import nex.village.PigtificateVillageData;
import nex.village.PigtificateVillageManager;

@Mod.EventBusSubscriber(modid="nex")
public class WorldHandler {
    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            PigtificateVillageManager.loadVillageData(world);
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        PigtificateVillageData data;
        World world = event.world;
        if (event.phase == TickEvent.Phase.START && !world.field_72995_K && (data = PigtificateVillageManager.getVillageData(world, false)) != null) {
            data.tick();
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            PigtificateVillageManager.unloadVillageData(world);
        }
    }
}

