/*
 * Decompiled with CFR 0.152.
 */
package nex.handler;

import java.util.Random;
import lex.util.BlockHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nex.block.BlockNetherrackPath;
import nex.handler.ConfigHandler;
import nex.init.NetherExBlocks;
import nex.init.NetherExEffects;
import nex.init.NetherExItems;

@Mod.EventBusSubscriber(modid="nex")
public class ClickHandler {
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onMouse(MouseEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_70644_a((Potion)NetherExEffects.FREEZE)) {
            KeyBinding.func_74506_a();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerRightClick(PlayerInteractEvent.RightClickBlock event) {
        IBlockState state;
        Block block;
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = event.getItemStack();
        if ((stack.func_77973_b() == NetherExItems.GOLDEN_WITHER_BONE_SHOVEL || ConfigHandler.blockConfig.netherrack.allowAllShovelsToFlatten && stack.func_77973_b() instanceof ItemHoe) && ((block = (state = world.func_180495_p(pos)).func_177230_c()) == Blocks.field_150424_aL || block == NetherExBlocks.NETHERRACK || block == NetherExBlocks.HYPHAE)) {
            for (EnumHand hand : EnumHand.values()) {
                if (!(player.func_184586_b(hand).func_77973_b() instanceof ItemSpade)) continue;
                player.func_184609_a(hand);
            }
            int meta = block == Blocks.field_150424_aL ? 0 : (block == NetherExBlocks.HYPHAE ? 3 : NetherExBlocks.NETHERRACK.func_176201_c(state) + 1);
            world.func_184133_a(player, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
            world.func_180501_a(pos, NetherExBlocks.NETHERRACK_PATH.func_176223_P().func_177226_a(BlockNetherrackPath.TYPE, (Comparable)((Object)BlockNetherrackPath.EnumType.fromMeta(meta))), 11);
            stack.func_77972_a(1, (EntityLivingBase)player);
        }
        if ((stack.func_77973_b() == NetherExItems.GOLDEN_WITHER_BONE_HOE || ConfigHandler.blockConfig.soulSand.allowAllHoesToTill && stack.func_77973_b() instanceof ItemHoe) && world.func_180495_p(pos).func_177230_c() == Blocks.field_150425_aM) {
            for (EnumHand hand : EnumHand.values()) {
                if (!(player.func_184586_b(hand).func_77973_b() instanceof ItemHoe)) continue;
                player.func_184609_a(hand);
            }
            world.func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
            world.func_180501_a(pos, NetherExBlocks.TILLED_SOUL_SAND.func_176223_P(), 11);
            stack.func_77972_a(1, (EntityLivingBase)player);
        }
    }

    @SubscribeEvent
    public static void onPlayerLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        World world = event.getWorld();
        EnumFacing facing = event.getFace();
        BlockPos originalPos = event.getPos();
        BlockPos offsetPos = originalPos.func_177972_a(facing);
        IBlockState originalState = world.func_180495_p(originalPos);
        IBlockState offsetState = world.func_180495_p(offsetPos);
        EntityPlayer player = event.getEntityPlayer();
        if (offsetState.func_177230_c() == NetherExBlocks.BLUE_FIRE) {
            world.func_180498_a(player, 1009, offsetPos, 0);
            world.func_175698_g(offsetPos);
            event.setCanceled(true);
        }
        if (originalState.func_177230_c() == Blocks.field_150357_h && player.func_184614_ca().func_77973_b() == NetherExItems.GOLDEN_WITHER_BONE_HAMMER) {
            BlockHelper.mine3x3((World)world, (ItemStack)player.func_184614_ca(), (BlockPos)originalPos, (EntityPlayer)player);
        }
    }

    @SubscribeEvent
    public static void onBoneMealUse(BonemealEvent event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = event.getBlock();
        EntityPlayer player = event.getEntityPlayer();
        if (player.func_184614_ca().func_77973_b() == NetherExItems.WITHER_DUST) {
            if (state.func_177230_c() == Blocks.field_150388_bm) {
                int age = (Integer)state.func_177229_b((IProperty)BlockNetherWart.field_176486_a);
                if (age < 3) {
                    state = state.func_177226_a((IProperty)BlockNetherWart.field_176486_a, (Comparable)Integer.valueOf(age + 1));
                    world.func_175656_a(pos, state);
                    event.setResult(Event.Result.ALLOW);
                }
            } else if (state.func_177230_c() instanceof IGrowable) {
                IGrowable growable = (IGrowable)state.func_177230_c();
                if (growable.func_176473_a(world, pos, state, world.field_72995_K)) {
                    growable.func_176474_b(world, world.field_73012_v, pos, state);
                }
            } else {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerEntityInteract(PlayerInteractEvent.EntityInteract event) {
        World world = event.getWorld();
        EntityPlayer player = event.getEntityPlayer();
        Entity entity = event.getTarget();
        Random rand = world.field_73012_v;
        if (entity instanceof EntityPigZombie) {
            EntityPigZombie zombiePigman = (EntityPigZombie)entity;
            ItemStack stack = player.func_184614_ca();
            if (stack.func_77973_b() == NetherExItems.GHAST_QUEEN_TEAR && stack.func_77960_j() == 0 && zombiePigman.func_70644_a(MobEffects.field_76437_t)) {
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                if (!world.field_72995_K) {
                    int conversionTime = rand.nextInt(2401) + 3600;
                    zombiePigman.getEntityData().func_74768_a("ConversionTime", conversionTime);
                    zombiePigman.func_184589_d(MobEffects.field_76437_t);
                    zombiePigman.func_70690_d(new PotionEffect(MobEffects.field_76420_g, conversionTime, Math.min(world.func_175659_aa().func_151525_a() - 1, 0)));
                }
            }
        }
    }
}

