/*
 * Decompiled with CFR 0.152.
 */
package nex.block;

import java.util.Random;
import lex.IModData;
import lex.block.BlockLibEx;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nex.NetherEx;

public class BlockBlueFire
extends BlockLibEx {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)15);
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool UPPER = PropertyBool.func_177716_a((String)"up");

    public BlockBlueFire() {
        super((IModData)NetherEx.instance, "blue_fire", Material.field_151581_o);
        this.func_149715_a(1.0f);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(false)));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        block12: {
            block11: {
                if (rand.nextInt(24) == 0) {
                    world.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f, false);
                }
                if (world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) || this.canCatchFire((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP)) break block11;
                if (this.canCatchFire((IBlockAccess)world, pos.func_177976_e(), EnumFacing.EAST)) {
                    for (int j = 0; j < 2; ++j) {
                        double d3 = (double)pos.func_177958_n() + rand.nextDouble() * (double)0.1f;
                        double d8 = (double)pos.func_177956_o() + rand.nextDouble();
                        double d13 = (double)pos.func_177952_p() + rand.nextDouble();
                        world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, d3, d8, d13, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
                if (this.canCatchFire((IBlockAccess)world, pos.func_177974_f(), EnumFacing.WEST)) {
                    for (int k = 0; k < 2; ++k) {
                        double d4 = (double)(pos.func_177958_n() + 1) - rand.nextDouble() * (double)0.1f;
                        double d9 = (double)pos.func_177956_o() + rand.nextDouble();
                        double d14 = (double)pos.func_177952_p() + rand.nextDouble();
                        world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, d4, d9, d14, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
                if (this.canCatchFire((IBlockAccess)world, pos.func_177978_c(), EnumFacing.SOUTH)) {
                    for (int l = 0; l < 2; ++l) {
                        double d5 = (double)pos.func_177958_n() + rand.nextDouble();
                        double d10 = (double)pos.func_177956_o() + rand.nextDouble();
                        double d15 = (double)pos.func_177952_p() + rand.nextDouble() * (double)0.1f;
                        world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, d5, d10, d15, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
                if (this.canCatchFire((IBlockAccess)world, pos.func_177968_d(), EnumFacing.NORTH)) {
                    for (int i1 = 0; i1 < 2; ++i1) {
                        double d6 = (double)pos.func_177958_n() + rand.nextDouble();
                        double d11 = (double)pos.func_177956_o() + rand.nextDouble();
                        double d16 = (double)(pos.func_177952_p() + 1) - rand.nextDouble() * (double)0.1f;
                        world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, d6, d11, d16, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
                if (!this.canCatchFire((IBlockAccess)world, pos.func_177984_a(), EnumFacing.DOWN)) break block12;
                for (int j1 = 0; j1 < 2; ++j1) {
                    double d7 = (double)pos.func_177958_n() + rand.nextDouble();
                    double d12 = (double)(pos.func_177956_o() + 1) - rand.nextDouble() * (double)0.1f;
                    double d17 = (double)pos.func_177952_p() + rand.nextDouble();
                    world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, d7, d12, d17, 0.0, 0.0, 0.0, new int[0]);
                }
                break block12;
            }
            for (int i = 0; i < 3; ++i) {
                double d0 = (double)pos.func_177958_n() + rand.nextDouble();
                double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 0.5 + 0.5;
                double d2 = (double)pos.func_177952_p() + rand.nextDouble();
                world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149703_v() {
        return false;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149698_L() {
        return false;
    }

    public int func_149738_a(World world) {
        return 15;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.func_82736_K().func_82766_b("doFireTick")) {
            if (!this.func_176196_c(world, pos)) {
                world.func_175698_g(pos);
            }
            boolean flag = world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP);
            int i = (Integer)state.func_177229_b((IProperty)AGE);
            if (!flag && world.func_72896_J() && this.canDie(world, pos) && rand.nextFloat() < 0.2f + (float)i * 0.03f) {
                world.func_175698_g(pos);
            } else {
                if (i < 15) {
                    state = state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(i + rand.nextInt(3) / 2));
                    world.func_180501_a(pos, state, 4);
                }
                world.func_175684_a(pos, (Block)this, this.func_149738_a(world) + rand.nextInt(10));
                if (!flag) {
                    if (!this.canNeighborCatchFire(world, pos)) {
                        if (!world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) || i > 3) {
                            world.func_175698_g(pos);
                        }
                        return;
                    }
                    if (!this.canCatchFire((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) && i == 15 && rand.nextInt(4) == 0) {
                        world.func_175698_g(pos);
                        return;
                    }
                }
                boolean flag1 = world.func_180502_D(pos);
                int j = 0;
                if (flag1) {
                    j = -50;
                }
                this.tryCatchFire(world, pos.func_177974_f(), 300 + j, rand, i, EnumFacing.WEST);
                this.tryCatchFire(world, pos.func_177976_e(), 300 + j, rand, i, EnumFacing.EAST);
                this.tryCatchFire(world, pos.func_177977_b(), 250 + j, rand, i, EnumFacing.UP);
                this.tryCatchFire(world, pos.func_177984_a(), 250 + j, rand, i, EnumFacing.DOWN);
                this.tryCatchFire(world, pos.func_177978_c(), 300 + j, rand, i, EnumFacing.SOUTH);
                this.tryCatchFire(world, pos.func_177968_d(), 300 + j, rand, i, EnumFacing.NORTH);
                for (int k = -1; k <= 1; ++k) {
                    for (int l = -1; l <= 1; ++l) {
                        for (int i1 = -1; i1 <= 4; ++i1) {
                            BlockPos blockpos;
                            int k1;
                            if (k == 0 && i1 == 0 && l == 0) continue;
                            int j1 = 100;
                            if (i1 > 1) {
                                j1 += (i1 - 1) * 100;
                            }
                            if ((k1 = this.getNeighborEncouragement(world, blockpos = pos.func_177982_a(k, i1, l))) <= 0) continue;
                            int l1 = (k1 + 40 + world.func_175659_aa().func_151525_a() * 7) / (i + 30);
                            if (flag1) {
                                l1 /= 2;
                            }
                            if (l1 <= 0 || rand.nextInt(j1) > l1 || world.func_72896_J() && this.canDie(world, blockpos)) continue;
                            int i2 = i + rand.nextInt(5) / 4;
                            if (i2 > 15) {
                                i2 = 15;
                            }
                            world.func_180501_a(blockpos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(i2)), 3);
                        }
                    }
                }
            }
        }
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) || this.canNeighborCatchFire(world, pos);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (!world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) && !this.canNeighborCatchFire(world, pos)) {
            world.func_175698_g(pos);
        } else {
            world.func_175684_a(pos, (Block)this, this.func_149738_a(world) + world.field_73012_v.nextInt(10));
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) && !this.canNeighborCatchFire(world, pos)) {
            world.func_175698_g(pos);
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof EntityItem) {
            entity.func_70106_y();
        } else if (entity instanceof EntityLivingBase && !entity.func_70045_F()) {
            entity.func_70097_a(DamageSource.field_76372_a, 4.0f);
        }
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (!world.func_180495_p(pos.func_177977_b()).isSideSolid(world, pos.func_177977_b(), EnumFacing.UP) && !this.canCatchFire(world, pos.func_177977_b(), EnumFacing.UP)) {
            return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canCatchFire(world, pos.func_177978_c(), EnumFacing.SOUTH))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canCatchFire(world, pos.func_177974_f(), EnumFacing.WEST))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canCatchFire(world, pos.func_177968_d(), EnumFacing.NORTH))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canCatchFire(world, pos.func_177976_e(), EnumFacing.EAST))).func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(this.canCatchFire(world, pos.func_177984_a(), EnumFacing.DOWN)));
        }
        return this.func_176223_P();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE, NORTH, EAST, SOUTH, WEST, UPPER});
    }

    private boolean canCatchFire(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return world.func_180495_p(pos).func_177230_c().isFlammable(world, pos, face);
    }

    private boolean canNeighborCatchFire(World world, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!this.canCatchFire((IBlockAccess)world, pos.func_177972_a(enumfacing), enumfacing.func_176734_d())) continue;
            return true;
        }
        return false;
    }

    private int getNeighborEncouragement(World world, BlockPos pos) {
        if (!world.func_175623_d(pos)) {
            return 0;
        }
        int i = 0;
        for (EnumFacing enumfacing : EnumFacing.values()) {
            i = Math.max(world.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c().getFireSpreadSpeed((IBlockAccess)world, pos.func_177972_a(enumfacing), enumfacing.func_176734_d()), i);
        }
        return i;
    }

    private void tryCatchFire(World world, BlockPos pos, int chance, Random random, int age, EnumFacing face) {
        int i = world.func_180495_p(pos).func_177230_c().getFlammability((IBlockAccess)world, pos, face);
        if (random.nextInt(chance) < i) {
            IBlockState iblockstate = world.func_180495_p(pos);
            if (random.nextInt(age + 10) < 5 && !world.func_175727_C(pos)) {
                int j = age + random.nextInt(5) / 4;
                if (j > 15) {
                    j = 15;
                }
                world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(j)), 3);
            } else {
                world.func_175698_g(pos);
            }
            if (iblockstate.func_177230_c() == Blocks.field_150335_W) {
                Blocks.field_150335_W.func_176206_d(world, pos, iblockstate.func_177226_a((IProperty)BlockTNT.field_176246_a, (Comparable)Boolean.valueOf(true)));
            }
        }
    }

    private boolean canDie(World world, BlockPos pos) {
        return world.func_175727_C(pos) || world.func_175727_C(pos.func_177976_e()) || world.func_175727_C(pos.func_177974_f()) || world.func_175727_C(pos.func_177978_c()) || world.func_175727_C(pos.func_177968_d());
    }

    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return PathNodeType.DAMAGE_FIRE;
    }
}

