/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.jei;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.BlankModPlugin;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.IRecipeWrapperFactory;
import mezz.jei.api.recipe.IStackHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import micdoodle8.mods.galacticraft.api.recipe.CompressorRecipes;
import micdoodle8.mods.galacticraft.api.recipe.INasaWorkbenchRecipe;
import micdoodle8.mods.galacticraft.api.recipe.ShapedRecipesGC;
import micdoodle8.mods.galacticraft.api.recipe.ShapelessOreRecipeGC;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.client.jei.MagneticCraftingTransferInfo;
import micdoodle8.mods.galacticraft.core.client.jei.NBTSensitiveShapedRecipeWrapper;
import micdoodle8.mods.galacticraft.core.client.jei.buggy.BuggyRecipeCategory;
import micdoodle8.mods.galacticraft.core.client.jei.buggy.BuggyRecipeMaker;
import micdoodle8.mods.galacticraft.core.client.jei.buggy.BuggyRecipeWrapper;
import micdoodle8.mods.galacticraft.core.client.jei.circuitfabricator.CircuitFabricatorRecipeCategory;
import micdoodle8.mods.galacticraft.core.client.jei.circuitfabricator.CircuitFabricatorRecipeMaker;
import micdoodle8.mods.galacticraft.core.client.jei.circuitfabricator.CircuitFabricatorRecipeWrapper;
import micdoodle8.mods.galacticraft.core.client.jei.ingotcompressor.IngotCompressorRecipeCategory;
import micdoodle8.mods.galacticraft.core.client.jei.ingotcompressor.IngotCompressorShapedRecipeWrapper;
import micdoodle8.mods.galacticraft.core.client.jei.ingotcompressor.IngotCompressorShapelessRecipeWrapper;
import micdoodle8.mods.galacticraft.core.client.jei.oxygencompressor.OxygenCompressorRecipeCategory;
import micdoodle8.mods.galacticraft.core.client.jei.oxygencompressor.OxygenCompressorRecipeMaker;
import micdoodle8.mods.galacticraft.core.client.jei.oxygencompressor.OxygenCompressorRecipeWrapper;
import micdoodle8.mods.galacticraft.core.client.jei.refinery.RefineryRecipeCategory;
import micdoodle8.mods.galacticraft.core.client.jei.refinery.RefineryRecipeMaker;
import micdoodle8.mods.galacticraft.core.client.jei.refinery.RefineryRecipeWrapper;
import micdoodle8.mods.galacticraft.core.client.jei.tier1rocket.Tier1RocketRecipeCategory;
import micdoodle8.mods.galacticraft.core.client.jei.tier1rocket.Tier1RocketRecipeMaker;
import micdoodle8.mods.galacticraft.core.client.jei.tier1rocket.Tier1RocketRecipeWrapper;
import micdoodle8.mods.galacticraft.core.recipe.ShapedRecipeNBT;
import micdoodle8.mods.galacticraft.core.util.CompatibilityManager;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;

@JEIPlugin
public class GalacticraftJEI
extends BlankModPlugin {
    private static IModRegistry registryCached = null;
    private static IRecipeRegistry recipesCached = null;
    private static boolean hiddenSteel = false;
    private static boolean hiddenAdventure = false;
    public static List<IRecipeWrapper> hidden = new LinkedList<IRecipeWrapper>();
    private static IRecipeCategory ingotCompressorCategory;

    public void register(@Nonnull IModRegistry registry) {
        registryCached = registry;
        final IStackHelper stackHelper = registry.getJeiHelpers().getStackHelper();
        registry.handleRecipes(INasaWorkbenchRecipe.class, Tier1RocketRecipeWrapper::new, "galacticraft.rocketT1");
        registry.handleRecipes(INasaWorkbenchRecipe.class, BuggyRecipeWrapper::new, "galacticraft.buggy");
        registry.handleRecipes(CircuitFabricatorRecipeWrapper.class, recipe -> recipe, "galacticraft.circuits");
        registry.handleRecipes(ShapedRecipesGC.class, IngotCompressorShapedRecipeWrapper::new, "galacticraft.ingotcompressor");
        registry.handleRecipes(ShapelessOreRecipeGC.class, (IRecipeWrapperFactory)new IRecipeWrapperFactory<ShapelessOreRecipeGC>(){

            public IRecipeWrapper getRecipeWrapper(ShapelessOreRecipeGC recipe) {
                return new IngotCompressorShapelessRecipeWrapper(stackHelper, recipe);
            }
        }, "galacticraft.ingotcompressor");
        registry.handleRecipes(RefineryRecipeWrapper.class, recipe -> recipe, "galacticraft.refinery");
        registry.handleRecipes(OxygenCompressorRecipeWrapper.class, recipe -> recipe, "galacticraft.oxygencompressor");
        registry.handleRecipes(ShapedRecipeNBT.class, NBTSensitiveShapedRecipeWrapper::new, "minecraft.crafting");
        registry.addRecipes(Tier1RocketRecipeMaker.getRecipesList(), "galacticraft.rocketT1");
        registry.addRecipes(BuggyRecipeMaker.getRecipesList(), "galacticraft.buggy");
        registry.addRecipes(CircuitFabricatorRecipeMaker.getRecipesList(), "galacticraft.circuits");
        registry.addRecipes(CompressorRecipes.getRecipeListAll(), "galacticraft.ingotcompressor");
        registry.addRecipes(OxygenCompressorRecipeMaker.getRecipesList(), "galacticraft.oxygencompressor");
        registry.addRecipes(RefineryRecipeMaker.getRecipesList(), "galacticraft.refinery");
        registry.addRecipeCatalyst((Object)new ItemStack(GCBlocks.nasaWorkbench), new String[]{"galacticraft.rocketT1", "galacticraft.buggy"});
        registry.addRecipeCatalyst((Object)new ItemStack(GCBlocks.machineBase2, 1, 4), new String[]{"galacticraft.circuits"});
        registry.addRecipeCatalyst((Object)new ItemStack(GCBlocks.machineBase, 1, 12), new String[]{"galacticraft.ingotcompressor"});
        registry.addRecipeCatalyst((Object)new ItemStack(GCBlocks.machineBase2, 1, 0), new String[]{"galacticraft.ingotcompressor"});
        registry.addRecipeCatalyst((Object)new ItemStack(GCBlocks.oxygenCompressor), new String[]{"galacticraft.oxygencompressor"});
        registry.addRecipeCatalyst((Object)new ItemStack(GCBlocks.refinery), new String[]{"galacticraft.refinery"});
        registry.addRecipeCatalyst((Object)new ItemStack(GCBlocks.crafting), new String[]{"minecraft.crafting"});
        registry.getRecipeTransferRegistry().addRecipeTransferHandler((IRecipeTransferInfo)new MagneticCraftingTransferInfo());
        this.addInformationPages(registry);
        GCItems.hideItemsJEI(registry.getJeiHelpers().getIngredientBlacklist());
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        ingotCompressorCategory = new IngotCompressorRecipeCategory(guiHelper);
        registry.addRecipeCategories(new IRecipeCategory[]{new Tier1RocketRecipeCategory(guiHelper), new BuggyRecipeCategory(guiHelper), new CircuitFabricatorRecipeCategory(guiHelper), ingotCompressorCategory, new OxygenCompressorRecipeCategory(guiHelper), new RefineryRecipeCategory(guiHelper)});
    }

    private void addInformationPages(IModRegistry registry) {
        registry.addIngredientInfo((Object)new ItemStack(GCBlocks.oxygenPipe), ItemStack.class, new String[]{GCCoreUtil.translate("jei.fluid_pipe.info")});
        registry.addIngredientInfo((Object)new ItemStack(GCBlocks.fuelLoader), ItemStack.class, new String[]{GCCoreUtil.translate("jei.fuel_loader.info")});
        registry.addIngredientInfo((Object)new ItemStack(GCBlocks.oxygenCollector), ItemStack.class, new String[]{GCCoreUtil.translate("jei.oxygen_collector.info")});
        registry.addIngredientInfo((Object)new ItemStack(GCBlocks.oxygenDistributor), ItemStack.class, new String[]{GCCoreUtil.translate("jei.oxygen_distributor.info")});
        registry.addIngredientInfo((Object)new ItemStack(GCBlocks.oxygenSealer), ItemStack.class, new String[]{GCCoreUtil.translate("jei.oxygen_sealer.info")});
        if (CompatibilityManager.isAppEngLoaded()) {
            registry.addIngredientInfo((Object)new ItemStack(GCBlocks.machineBase2), ItemStack.class, new String[]{GCCoreUtil.translate("jei.electric_compressor.info"), GCCoreUtil.translate("jei.electric_compressor.appeng.info")});
        } else {
            registry.addIngredientInfo((Object)new ItemStack(GCBlocks.machineBase2), ItemStack.class, new String[]{GCCoreUtil.translate("jei.electric_compressor.info")});
        }
        registry.addIngredientInfo((Object)new ItemStack(GCBlocks.crafting), ItemStack.class, new String[]{GCCoreUtil.translate("jei.magnetic_crafting.info")});
        registry.addIngredientInfo((Object)new ItemStack(GCBlocks.brightLamp), ItemStack.class, new String[]{GCCoreUtil.translate("jei.arc_lamp.info")});
        registry.addIngredientInfo((Object)new ItemStack(GCItems.wrench), ItemStack.class, new String[]{GCCoreUtil.translate("jei.wrench.info")});
    }

    public void onRuntimeAvailable(IJeiRuntime rt) {
        recipesCached = rt.getRecipeRegistry();
    }

    public static void updateHidden(boolean hideSteel, boolean hideAdventure) {
        boolean changeHidden = false;
        if (hideSteel != hiddenSteel) {
            hiddenSteel = hideSteel;
            changeHidden = true;
        }
        if (hideAdventure != hiddenAdventure) {
            hiddenAdventure = hideAdventure;
            changeHidden = true;
        }
        if (changeHidden && recipesCached != null) {
            GalacticraftJEI.unhide();
            List<IRecipe> toHide = CompressorRecipes.getRecipeListHidden(hideSteel, hideAdventure);
            hidden.clear();
            List allRW = recipesCached.getRecipeWrappers(ingotCompressorCategory);
            for (IRecipe recipe : toHide) {
                hidden.add(recipesCached.getRecipeWrapper((Object)recipe, "galacticraft.ingotcompressor"));
            }
            GalacticraftJEI.hide();
        }
    }

    private static void hide() {
        for (IRecipeWrapper wrapper : hidden) {
            recipesCached.hideRecipe(wrapper);
        }
    }

    private static void unhide() {
        for (IRecipeWrapper wrapper : hidden) {
            recipesCached.unhideRecipe(wrapper);
        }
    }
}

