/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.data;

import java.util.ArrayList;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.modules.data.ModuleData;

public class ModuleDataGroup {
    private Localization.MODULE_INFO name;
    private ArrayList<ModuleData> modules;
    private int count;

    public ModuleDataGroup(Localization.MODULE_INFO name) {
        this.name = name;
        this.count = 1;
        this.modules = new ArrayList();
    }

    public String getName() {
        return this.name.translate(String.valueOf(this.getCount()));
    }

    public ArrayList<ModuleData> getModules() {
        return this.modules;
    }

    public int getCount() {
        return this.count;
    }

    public ModuleDataGroup add(ModuleData module) {
        this.modules.add(module);
        return this;
    }

    public ModuleDataGroup setCount(int count) {
        this.count = count;
        return this;
    }

    public ModuleDataGroup copy() {
        ModuleDataGroup newObj = new ModuleDataGroup(this.name).setCount(this.getCount());
        for (ModuleData obj : this.getModules()) {
            newObj.add(obj);
        }
        return newObj;
    }

    public ModuleDataGroup copy(int count) {
        ModuleDataGroup newObj = new ModuleDataGroup(this.name).setCount(count);
        for (ModuleData obj : this.getModules()) {
            newObj.add(obj);
        }
        return newObj;
    }

    public String getCountName() {
        switch (this.count) {
            case 1: {
                return Localization.MODULE_INFO.MODULE_COUNT_1.translate(new String[0]);
            }
            case 2: {
                return Localization.MODULE_INFO.MODULE_COUNT_2.translate(new String[0]);
            }
            case 3: {
                return Localization.MODULE_INFO.MODULE_COUNT_3.translate(new String[0]);
            }
        }
        return "???";
    }

    public static ModuleDataGroup getCombinedGroup(Localization.MODULE_INFO name, ModuleDataGroup group1, ModuleDataGroup group2) {
        ModuleDataGroup newgroup = group1.copy();
        newgroup.add(group2);
        newgroup.name = name;
        return newgroup;
    }

    public void add(ModuleDataGroup group) {
        for (ModuleData obj : group.getModules()) {
            this.add(obj);
        }
    }
}

