/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.addons;

import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import vswe.stevescarts.containers.slots.SlotBase;
import vswe.stevescarts.containers.slots.SlotCartCrafterResult;
import vswe.stevescarts.containers.slots.SlotFurnaceInput;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.guis.GuiMinecart;
import vswe.stevescarts.modules.addons.ModuleRecipe;

public class ModuleSmelter
extends ModuleRecipe {
    private int energyBuffer;
    private int cooldown = 0;

    public ModuleSmelter(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public void update() {
        if (this.getCart().field_70170_p.field_72995_K) {
            return;
        }
        if (this.getCart().hasFuelForModule() && this.energyBuffer < 10) {
            ++this.energyBuffer;
        }
        if (this.cooldown <= 0) {
            if (this.energyBuffer == 10) {
                ItemStack recipe = this.getStack(0);
                ItemStack result = ItemStack.field_190927_a;
                if (!recipe.func_190926_b()) {
                    result = FurnaceRecipes.func_77602_a().func_151395_a(recipe);
                }
                if (!result.func_190926_b()) {
                    result = result.func_77946_l();
                }
                if (!result.func_190926_b() && this.getCart().getModules() != null) {
                    this.prepareLists();
                    if (this.canCraftMoreOfResult(result)) {
                        ItemStack item;
                        int i;
                        NonNullList originals = NonNullList.func_191196_a();
                        for (i = 0; i < this.allTheSlots.size(); ++i) {
                            item = ((SlotBase)((Object)this.allTheSlots.get(i))).func_75211_c();
                            originals.add((Object)(item.func_190926_b() ? ItemStack.field_190927_a : item.func_77946_l()));
                        }
                        for (i = 0; i < this.inputSlots.size(); ++i) {
                            item = ((SlotBase)((Object)this.inputSlots.get(i))).func_75211_c();
                            if (item.func_190926_b() || !item.func_77969_a(recipe) || !ItemStack.func_77970_a((ItemStack)item, (ItemStack)recipe)) continue;
                            ItemStack itemStack = item;
                            itemStack.func_190918_g(1);
                            if (itemStack.func_190916_E() <= 0) {
                                ((SlotBase)((Object)this.inputSlots.get(i))).func_75215_d(ItemStack.field_190927_a);
                            }
                            this.getCart().addItemToChest(result, this.getValidSlot(), null);
                            if (result.func_190916_E() != 0) {
                                for (int j = 0; j < this.allTheSlots.size(); ++j) {
                                    ((SlotBase)((Object)this.allTheSlots.get(j))).func_75215_d((ItemStack)originals.get(j));
                                }
                                break;
                            }
                            this.energyBuffer = 0;
                            break;
                        }
                    }
                }
            }
            this.cooldown = 40;
        } else {
            --this.cooldown;
        }
    }

    @Override
    public int getConsumption(boolean isMoving) {
        if (this.energyBuffer < 10) {
            return 15;
        }
        return super.getConsumption(isMoving);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    protected int getInventoryWidth() {
        return 1;
    }

    @Override
    protected int getInventoryHeight() {
        return 2;
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        if (y == 0) {
            return new SlotFurnaceInput(this.getCart(), slotId, 10 + 18 * x, 15 + 18 * y);
        }
        return new SlotCartCrafterResult(this.getCart(), slotId, 10 + 18 * x, 15 + 18 * y);
    }

    @Override
    public int numberOfGuiData() {
        return super.numberOfGuiData() + 1;
    }

    @Override
    protected void checkGuiData(Object[] info) {
        super.checkGuiData(info);
        this.updateGuiData(info, super.numberOfGuiData() + 0, (short)this.energyBuffer);
    }

    @Override
    public void receiveGuiData(int id, short data) {
        super.receiveGuiData(id, data);
        if (id == super.numberOfGuiData() + 0) {
            this.energyBuffer = data;
        }
    }

    @Override
    public void onInventoryChanged() {
        if (this.getCart().field_70170_p.field_72995_K) {
            if (!this.getStack(0).func_190926_b()) {
                this.setStack(1, FurnaceRecipes.func_77602_a().func_151395_a(this.getStack(0)));
            } else {
                this.setStack(1, ItemStack.field_190927_a);
            }
        }
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        super.drawForeground(gui);
        this.drawString(gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    public int guiWidth() {
        return this.canUseAdvancedFeatures() ? 100 : 45;
    }

    @Override
    protected int[] getArea() {
        return new int[]{32, 25, 16, 16};
    }

    @Override
    protected boolean canUseAdvancedFeatures() {
        return false;
    }

    @Override
    protected void Load(NBTTagCompound tagCompound, int id) {
        super.Load(tagCompound, id);
        this.energyBuffer = tagCompound.func_74771_c(this.generateNBTName("Buffer", id));
    }

    @Override
    protected void Save(NBTTagCompound tagCompound, int id) {
        super.Save(tagCompound, id);
        tagCompound.func_74774_a(this.generateNBTName("Buffer", id), (byte)this.energyBuffer);
    }

    @Override
    protected int getLimitStartX() {
        return 55;
    }

    @Override
    protected int getLimitStartY() {
        return 15;
    }
}

