/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.client;

import li.cil.scannable.client.ScanManager;
import li.cil.scannable.client.gui.GuiHandlerClient;
import li.cil.scannable.client.renderer.OverlayRenderer;
import li.cil.scannable.client.renderer.ScannerRenderer;
import li.cil.scannable.common.ProxyCommon;
import li.cil.scannable.common.Scannable;
import li.cil.scannable.common.init.Items;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.ObjectUtils;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public final class ProxyClient
extends ProxyCommon {
    @Override
    public void onInit(FMLInitializationEvent event) {
        super.onInit(event);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)Scannable.instance, (IGuiHandler)new GuiHandlerClient());
        MinecraftForge.EVENT_BUS.register((Object)ScannerRenderer.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)OverlayRenderer.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)ScanManager.INSTANCE);
    }

    @Override
    public void onPostInit(FMLPostInitializationEvent event) {
        super.onPostInit(event);
        ScannerRenderer.INSTANCE.init();
    }

    @SubscribeEvent
    public static void handleModelRegistryEvent(ModelRegistryEvent event) {
        for (Item item : Items.getAllItems()) {
            ResourceLocation registryName = item.getRegistryName();
            assert (registryName != null);
            ModelResourceLocation location = new ModelResourceLocation(registryName, "inventory");
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)location);
        }
    }

    @SubscribeEvent
    public static void handleConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (ObjectUtils.notEqual((Object)"scannable", (Object)event.getModID())) {
            return;
        }
        ConfigManager.sync((String)"scannable", (Config.Type)Config.Type.INSTANCE);
    }
}

