/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.togetherforever.api.data;

import com.buuz135.togetherforever.api.IPlayerInformation;
import com.buuz135.togetherforever.api.ITogetherTeam;
import com.buuz135.togetherforever.api.annotation.TogetherTeam;
import com.buuz135.togetherforever.api.data.TogetherRegistries;
import com.buuz135.togetherforever.utils.TeamHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

@TogetherTeam(id="default_together_team")
public class DefaultTogetherTeam
implements ITogetherTeam {
    private String teamName;
    private UUID owner;
    private List<IPlayerInformation> playersInformation = new ArrayList<IPlayerInformation>();

    @Override
    public void addPlayer(IPlayerInformation playerInformation) {
        if (this.teamName == null) {
            this.teamName = playerInformation.getName();
            this.owner = playerInformation.getUUID();
        }
        if (!this.playersInformation.contains(playerInformation)) {
            this.playersInformation.add(playerInformation);
        }
    }

    @Override
    public void removePlayer(IPlayerInformation playerInformation) {
        this.playersInformation.remove(playerInformation);
    }

    @Override
    public void removePlayer(UUID playerUUID) {
        IPlayerInformation information = TeamHelper.findPlayerInfo(this.playersInformation, playerUUID);
        if (information != null) {
            this.playersInformation.remove(information);
        }
    }

    @Override
    public Collection<IPlayerInformation> getPlayers() {
        return this.playersInformation;
    }

    @Override
    public NBTTagCompound getNBTTag() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("Name", this.teamName);
        compound.func_74778_a("Owner", this.owner.toString());
        for (IPlayerInformation information : this.playersInformation) {
            NBTTagCompound informationCompound = new NBTTagCompound();
            informationCompound.func_74778_a("PlayerID", TogetherRegistries.getPlayerInformationID(information.getClass()));
            informationCompound.func_74782_a("Value", (NBTBase)information.getNBTTag());
            compound.func_74782_a(information.getUUID().toString(), (NBTBase)informationCompound);
        }
        return compound;
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.teamName = compound.func_74779_i("Name");
        this.owner = UUID.fromString(compound.func_74779_i("Owner"));
        for (String key : compound.func_150296_c()) {
            NBTTagCompound informationCompound;
            Class<? extends IPlayerInformation> plClass;
            if (key.equalsIgnoreCase("Name") || (plClass = TogetherRegistries.getPlayerInformationClass((informationCompound = compound.func_74775_l(key)).func_74779_i("PlayerID"))) == null) continue;
            try {
                IPlayerInformation info = plClass.newInstance();
                info.readFromNBT(informationCompound.func_74775_l("Value"));
                this.playersInformation.add(info);
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getTeamName() {
        return this.teamName;
    }

    @Override
    public UUID getOwner() {
        return this.owner;
    }
}

