/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.togetherforever.api.data;

import com.buuz135.togetherforever.api.IPlayerInformation;
import com.buuz135.togetherforever.api.TogetherForeverAPI;
import com.buuz135.togetherforever.api.annotation.PlayerInformation;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

@PlayerInformation(id="default_player_information")
public class DefaultPlayerInformation
implements IPlayerInformation {
    private String name;
    private UUID uuid;

    public static DefaultPlayerInformation createInformation(EntityPlayerMP playerMP) {
        DefaultPlayerInformation info = new DefaultPlayerInformation();
        info.setName(playerMP.func_70005_c_());
        info.setUUID(playerMP.func_110124_au());
        return info;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public NBTTagCompound getNBTTag() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("Name", this.name);
        compound.func_74778_a("Id", this.uuid.toString());
        return compound;
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.name = compound.func_74779_i("Name");
        this.uuid = UUID.fromString(compound.func_74779_i("Id"));
    }

    @Override
    @Nullable
    public EntityPlayerMP getPlayer() {
        return TogetherForeverAPI.getInstance().getPlayer(this.uuid);
    }

    public boolean equals(Object obj) {
        if (obj instanceof IPlayerInformation) {
            return this.uuid.equals(((IPlayerInformation)obj).getUUID());
        }
        return false;
    }
}

