/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.togetherforever.api.action;

import com.buuz135.togetherforever.TogetherForever;
import com.buuz135.togetherforever.api.IOfflineSyncRecovery;
import com.buuz135.togetherforever.api.IPlayerInformation;
import com.buuz135.togetherforever.api.ISyncAction;
import com.buuz135.togetherforever.api.ITogetherTeam;
import com.buuz135.togetherforever.api.TogetherForeverAPI;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public abstract class EventSyncAction<T extends PlayerEvent, S extends IOfflineSyncRecovery>
implements ISyncAction<T, S> {
    private final Class<S> recovery;
    private final Class<T> eventClass;

    public EventSyncAction(Class<T> eventClass, Class<S> offlineRecovery) {
        this.recovery = offlineRecovery;
        this.eventClass = eventClass;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onEvent(T event) {
        if (!event.getClass().equals(this.eventClass)) {
            return;
        }
        TogetherForever.LOGGER.debug("Triggering event class: " + event.getClass().toString());
        if (TogetherForeverAPI.getInstance().getWorld() == null) {
            return;
        }
        TogetherForever.LOGGER.debug("World is not null");
        ITogetherTeam team = TogetherForeverAPI.getInstance().getPlayerTeam(event.getEntityPlayer().func_110124_au());
        if (team != null) {
            TogetherForever.LOGGER.debug("Found team: " + team.getTeamName() + ". Contains this players:");
            team.getPlayers().forEach(iPlayerInformation -> TogetherForever.LOGGER.debug(iPlayerInformation.getUUID().toString() + ':' + iPlayerInformation.getName()));
            TogetherForever.LOGGER.debug("Starting to trigger sync");
            List<IPlayerInformation> playerLeft = this.triggerSync(event, team);
            TogetherForever.LOGGER.debug("Sync triggered with " + playerLeft.size() + " players not being synced:");
            NBTTagCompound compound = this.transformEventToNBT(event);
            for (IPlayerInformation information : playerLeft) {
                TogetherForever.LOGGER.debug(information.getUUID().toString() + ':' + information.getName());
                TogetherForeverAPI.getInstance().addPlayerToOfflineRecovery(this.recovery, information, compound);
            }
        }
    }

    @Override
    public Class<S> getOfflineRecovery() {
        return this.recovery;
    }

    public abstract NBTTagCompound transformEventToNBT(T var1);
}

