/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.togetherforever.action.recovery;

import codersafterdark.reskillable.api.ReskillableRegistries;
import codersafterdark.reskillable.api.data.PlayerData;
import codersafterdark.reskillable.api.data.PlayerDataHandler;
import codersafterdark.reskillable.api.data.PlayerSkillInfo;
import codersafterdark.reskillable.api.requirement.RequirementCache;
import codersafterdark.reskillable.api.requirement.TraitRequirement;
import codersafterdark.reskillable.api.toast.ToastHelper;
import codersafterdark.reskillable.api.unlockable.Unlockable;
import com.buuz135.togetherforever.action.recovery.AbstractOfflineRecovery;
import com.buuz135.togetherforever.api.IPlayerInformation;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class ReskillableUnlockableOfflineRecovery
extends AbstractOfflineRecovery {
    @Override
    public void recoverMissingPlayer(IPlayerInformation playerInformation) {
        PlayerData data = PlayerDataHandler.get((EntityPlayer)playerInformation.getPlayer());
        if (data == null) {
            return;
        }
        boolean changed = false;
        ArrayList<Map.Entry> removeList = new ArrayList<Map.Entry>();
        for (Map.Entry entry : new ArrayList(this.offlineRecoveries.entries())) {
            PlayerSkillInfo skillInfo;
            if (!((IPlayerInformation)entry.getKey()).getUUID().equals(playerInformation.getUUID())) continue;
            String skillID = ((NBTTagCompound)entry.getValue()).func_74779_i("Unlock");
            Unlockable unlockable = (Unlockable)ReskillableRegistries.UNLOCKABLES.getValue(new ResourceLocation(skillID));
            if (unlockable != null && !(skillInfo = data.getSkillInfo(unlockable.getParentSkill())).isUnlocked(unlockable)) {
                skillInfo.unlock(unlockable, (EntityPlayer)playerInformation.getPlayer());
                changed = true;
                ToastHelper.sendUnlockableToast((EntityPlayerMP)playerInformation.getPlayer(), (Unlockable)unlockable);
            }
            removeList.add(entry);
        }
        for (Map.Entry entry : removeList) {
            this.offlineRecoveries.remove(entry.getKey(), entry.getValue());
        }
        if (changed) {
            data.saveAndSync();
            RequirementCache.invalidateCache((UUID)playerInformation.getUUID(), (Class[])new Class[]{TraitRequirement.class});
        }
    }
}

