/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.rendering;

import ivorius.ivtoolkit.rendering.IvDepthBuffer;
import ivorius.ivtoolkit.rendering.IvOpenGLHelper;
import ivorius.ivtoolkit.rendering.IvRenderHelper;
import java.nio.ByteBuffer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

public class IvOpenGLTexturePingPong {
    public Logger logger;
    public int[] cacheTextures = new int[2];
    public int activeBuffer;
    public int pingPongFB;
    public boolean setup = false;
    public boolean setupRealtimeFB = false;
    public boolean setupCacheTextureForTick = false;
    private int screenWidth;
    private int screenHeight;
    private int parentFrameBuffer;
    private boolean useFramebuffer;

    public IvOpenGLTexturePingPong(Logger logger) {
        this.logger = logger;
    }

    public void initialize(boolean useFramebuffer) {
        this.destroy();
        this.useFramebuffer = useFramebuffer;
        boolean fboFailed = false;
        for (int i = 0; i < 2; ++i) {
            this.cacheTextures[i] = IvOpenGLHelper.genStandardTexture();
            GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.screenWidth, (int)this.screenHeight, (int)0, (int)6408, (int)5121, (ByteBuffer)null);
        }
        if (this.cacheTextures[0] <= 0 || this.cacheTextures[1] <= 0) {
            fboFailed = true;
            this.setup = false;
        } else if (OpenGlHelper.field_148823_f && useFramebuffer) {
            this.pingPongFB = OpenGlHelper.func_153165_e();
            OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)this.pingPongFB);
            OpenGlHelper.func_153188_a((int)OpenGlHelper.field_153198_e, (int)OpenGlHelper.field_153200_g, (int)3553, (int)this.cacheTextures[0], (int)0);
            OpenGlHelper.func_153188_a((int)OpenGlHelper.field_153198_e, (int)(OpenGlHelper.field_153200_g + 1), (int)3553, (int)this.cacheTextures[1], (int)0);
            int status = OpenGlHelper.func_153167_i((int)OpenGlHelper.field_153198_e);
            if (status != OpenGlHelper.field_153202_i) {
                this.logger.error("PingPong FBO failed setting up! (" + IvDepthBuffer.getFramebufferStatusString(status) + ")");
                fboFailed = true;
            }
            OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)this.parentFrameBuffer);
            this.setup = true;
        } else {
            fboFailed = true;
            this.setup = true;
        }
        if (!fboFailed) {
            this.setupRealtimeFB = true;
        } else {
            this.logger.error("Can not PingPong! Using screen pong workaround");
        }
    }

    public void setScreenSize(int screenWidth, int screenHeight) {
        boolean gen;
        boolean bl = gen = screenWidth != this.screenWidth || screenHeight != this.screenHeight;
        if (gen) {
            this.screenWidth = screenWidth;
            this.screenHeight = screenHeight;
            if (this.setup) {
                this.initialize(this.useFramebuffer);
            }
        }
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public int getScreenHeight() {
        return this.screenHeight;
    }

    public void setParentFrameBuffer(int parentFrameBuffer) {
        this.parentFrameBuffer = parentFrameBuffer > 0 ? parentFrameBuffer : 0;
    }

    public int getParentFrameBuffer() {
        return this.parentFrameBuffer;
    }

    public void preTick(int screenWidth, int screenHeight) {
        this.setupCacheTextureForTick = false;
        this.setScreenSize(screenWidth, screenHeight);
    }

    public void pingPong() {
        if (this.setupRealtimeFB) {
            if (!this.setupCacheTextureForTick) {
                this.activeBuffer = 0;
                this.bindCurrentTexture();
                GL11.glCopyTexImage2D((int)3553, (int)0, (int)6407, (int)0, (int)0, (int)this.screenWidth, (int)this.screenHeight, (int)0);
                OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)this.pingPongFB);
                GlStateManager.func_179123_a();
                this.setupCacheTextureForTick = true;
            } else {
                this.activeBuffer = 1 - this.activeBuffer;
                this.bindCurrentTexture();
            }
            GL11.glDrawBuffer((int)(this.activeBuffer == 1 ? OpenGlHelper.field_153200_g : OpenGlHelper.field_153200_g + 1));
            GlStateManager.func_179083_b((int)0, (int)0, (int)this.screenWidth, (int)this.screenHeight);
        } else {
            GlStateManager.func_179144_i((int)this.cacheTextures[0]);
            GL11.glCopyTexImage2D((int)3553, (int)0, (int)6407, (int)0, (int)0, (int)this.screenWidth, (int)this.screenHeight, (int)0);
        }
    }

    public void bindCurrentTexture() {
        GlStateManager.func_179144_i((int)this.cacheTextures[this.activeBuffer]);
    }

    public void postTick() {
        if (this.setupRealtimeFB && this.setupCacheTextureForTick) {
            GlStateManager.func_179099_b();
            OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)this.parentFrameBuffer);
            this.activeBuffer = 1 - this.activeBuffer;
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            this.bindCurrentTexture();
            IvRenderHelper.drawRectFullScreen(this.screenWidth, this.screenHeight);
        }
    }

    public void destroy() {
        for (int i = 0; i < 2; ++i) {
            if (this.cacheTextures[i] <= 0) continue;
            GlStateManager.func_179150_h((int)this.cacheTextures[i]);
            this.cacheTextures[i] = 0;
        }
        if (this.pingPongFB > 0) {
            OpenGlHelper.func_153174_h((int)this.pingPongFB);
            this.pingPongFB = 0;
        }
        this.setupRealtimeFB = false;
        this.setup = false;
    }
}

