/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mrriegel.storagenetwork.block.master.TileMaster;
import mrriegel.storagenetwork.data.ItemStackMatcher;
import mrriegel.storagenetwork.gui.IStorageContainer;
import mrriegel.storagenetwork.network.StackRefreshClientMessage;
import mrriegel.storagenetwork.network.StackResponseClientMessage;
import mrriegel.storagenetwork.registry.PacketRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.items.ItemHandlerHelper;

public class RequestMessage
implements IMessage,
IMessageHandler<RequestMessage, IMessage> {
    private int mouseButton = 0;
    private ItemStack stack = ItemStack.field_190927_a;
    private boolean shift;
    private boolean ctrl;

    public String toString() {
        return "RequestMessage [mouseButton=" + this.mouseButton + ", shift=" + this.shift + ", ctrl=" + this.ctrl + ", stack=" + this.stack.toString() + "]";
    }

    public RequestMessage() {
    }

    public RequestMessage(int id, ItemStack stack, boolean shift, boolean ctrl) {
        this.mouseButton = id;
        this.stack = stack;
        this.shift = shift;
        this.ctrl = ctrl;
    }

    public IMessage onMessage(RequestMessage message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        WorldServer mainThread = (WorldServer)player.field_70170_p;
        mainThread.func_152344_a(() -> {
            TileMaster tileMaster = null;
            if (player.field_71070_bA instanceof IStorageContainer) {
                IStorageContainer ctr = (IStorageContainer)player.field_71070_bA;
                tileMaster = ctr.getTileMaster();
            }
            if (tileMaster == null) {
                return;
            }
            int in = tileMaster.getAmount(new ItemStackMatcher(message.stack, true, false, true));
            boolean isLeftClick = message.mouseButton == 0;
            boolean isRightClick = message.mouseButton == 1;
            int sizeRequested = 0;
            if (message.ctrl) {
                sizeRequested = 1;
            } else if (isLeftClick) {
                sizeRequested = message.stack.func_77976_d();
            } else if (isRightClick) {
                sizeRequested = Math.min(message.stack.func_77976_d() / 2, in / 2);
            }
            sizeRequested = Math.max(sizeRequested, 1);
            ItemStack stack = tileMaster.request(new ItemStackMatcher(message.stack, true, false, true), sizeRequested, false);
            if (stack.func_190926_b()) {
                stack = tileMaster.request(new ItemStackMatcher(message.stack, true, false, false), sizeRequested, false);
            }
            if (!stack.func_190926_b()) {
                if (message.shift) {
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stack);
                } else {
                    player.field_71071_by.func_70437_b(stack);
                    PacketRegistry.INSTANCE.sendTo((IMessage)new StackResponseClientMessage(stack), player);
                }
            }
            List<ItemStack> list = tileMaster.getStacks();
            PacketRegistry.INSTANCE.sendTo((IMessage)new StackRefreshClientMessage(list, new ArrayList<ItemStack>()), player);
            player.field_71070_bA.func_75142_b();
        });
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        this.mouseButton = buf.readInt();
        this.stack = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.stack.func_190920_e(buf.readInt());
        this.shift = buf.readBoolean();
        this.ctrl = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.mouseButton);
        ItemStack toWrite = this.stack.func_77946_l();
        toWrite.func_190920_e(1);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)toWrite);
        buf.writeInt(this.stack.func_190916_E());
        buf.writeBoolean(this.shift);
        buf.writeBoolean(this.ctrl);
    }
}

