/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.capabilities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import mrriegel.storagenetwork.api.capability.IConnectable;
import mrriegel.storagenetwork.api.capability.IConnectableLink;
import mrriegel.storagenetwork.api.data.DimPos;
import mrriegel.storagenetwork.api.data.EnumStorageDirection;
import mrriegel.storagenetwork.api.data.IItemStackMatcher;
import mrriegel.storagenetwork.capabilities.CapabilityConnectable;
import mrriegel.storagenetwork.capabilities.StorageNetworkCapabilities;
import mrriegel.storagenetwork.util.inventory.FilterItemStackHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class CapabilityConnectableLink
implements IConnectableLink,
INBTSerializable<NBTTagCompound> {
    public IConnectable connectable;
    private boolean operationMustBeSmaller = true;
    private ItemStack operationStack = ItemStack.field_190927_a;
    private int operationLimit = 0;
    public FilterItemStackHandler filters = new FilterItemStackHandler();
    public EnumStorageDirection filterDirection = EnumStorageDirection.BOTH;
    protected EnumFacing inventoryFace;
    public int priority;

    public CapabilityConnectableLink() {
        this.connectable = new CapabilityConnectable();
        this.filters.setIsWhitelist(false);
    }

    public CapabilityConnectableLink(TileEntity tile) {
        this.connectable = (IConnectable)tile.getCapability(StorageNetworkCapabilities.CONNECTABLE_CAPABILITY, null);
        this.filters.setIsWhitelist(false);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public List<ItemStack> getStoredStacks() {
        if (this.inventoryFace == null) {
            return Collections.emptyList();
        }
        DimPos inventoryPos = this.connectable.getPos().offset(this.inventoryFace);
        IItemHandler itemHandler = (IItemHandler)inventoryPos.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.inventoryFace.func_176734_d());
        if (itemHandler == null) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stack = itemHandler.getStackInSlot(slot);
            if (stack == null || stack.func_190926_b() || this.filters.isStackFiltered(stack)) continue;
            result.add(stack.func_77946_l());
        }
        return result;
    }

    @Override
    public ItemStack insertStack(ItemStack stack, boolean simulate) {
        if (this.filterDirection == EnumStorageDirection.IN) {
            return stack;
        }
        if (this.filters.isStackFiltered(stack)) {
            return stack;
        }
        if (this.inventoryFace == null) {
            return stack;
        }
        DimPos inventoryPos = this.connectable.getPos().offset(this.inventoryFace);
        IItemHandler itemHandler = (IItemHandler)inventoryPos.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.inventoryFace.func_176734_d());
        if (itemHandler == null) {
            return stack;
        }
        return ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)stack, (boolean)simulate);
    }

    @Override
    public ItemStack extractStack(IItemStackMatcher matcher, int size, boolean simulate) {
        if (size <= 0) {
            return ItemStack.field_190927_a;
        }
        if (this.filterDirection == EnumStorageDirection.IN) {
            return ItemStack.field_190927_a;
        }
        if (this.inventoryFace == null) {
            return ItemStack.field_190927_a;
        }
        DimPos inventoryPos = this.connectable.getPos().offset(this.inventoryFace);
        IItemHandler itemHandler = (IItemHandler)inventoryPos.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.inventoryFace.func_176734_d());
        if (itemHandler == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack firstMatchedStack = ItemStack.field_190927_a;
        int remaining = size;
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stack = itemHandler.extractItem(slot, remaining, true);
            if (stack == null || stack.func_190926_b() || this.filters.isStackFiltered(stack)) continue;
            if (firstMatchedStack.func_190926_b()) {
                if (!matcher.match(stack)) continue;
                firstMatchedStack = stack.func_77946_l();
            } else if (!ItemHandlerHelper.canItemStacksStack((ItemStack)firstMatchedStack, (ItemStack)stack)) continue;
            int toExtract = Math.min(stack.func_190916_E(), remaining);
            ItemStack extractedStack = itemHandler.extractItem(slot, toExtract, simulate);
            if ((remaining -= extractedStack.func_190916_E()) <= 0) break;
        }
        int extractCount = size - remaining;
        if (!firstMatchedStack.func_190926_b() && extractCount > 0) {
            firstMatchedStack.func_190920_e(extractCount);
        }
        return firstMatchedStack;
    }

    @Override
    public int getEmptySlots() {
        if (this.filterDirection == EnumStorageDirection.IN) {
            return 0;
        }
        if (this.inventoryFace == null) {
            return 0;
        }
        DimPos inventoryPos = this.connectable.getPos().offset(this.inventoryFace);
        IItemHandler itemHandler = (IItemHandler)inventoryPos.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.inventoryFace.func_176734_d());
        if (itemHandler == null) {
            return 0;
        }
        int emptySlots = 0;
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stack = itemHandler.getStackInSlot(slot);
            if (stack != null && !stack.func_190926_b()) continue;
            ++emptySlots;
        }
        return emptySlots;
    }

    @Override
    public EnumStorageDirection getSupportedTransferDirection() {
        return this.filterDirection;
    }

    public void setInventoryFace(EnumFacing inventoryFace) {
        this.inventoryFace = inventoryFace;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound result = new NBTTagCompound();
        NBTTagCompound filters = this.filters.serializeNBT();
        result.func_74782_a("filters", (NBTBase)filters);
        result.func_74768_a("prio", this.priority);
        if (this.inventoryFace != null) {
            result.func_74778_a("inventoryFace", this.inventoryFace.toString());
        }
        result.func_74778_a("way", this.filterDirection.toString());
        NBTTagCompound operation = new NBTTagCompound();
        operation.func_74782_a("stack", (NBTBase)this.operationStack.serializeNBT());
        operation.func_74757_a("mustBeSmaller", this.operationMustBeSmaller);
        operation.func_74768_a("limit", this.operationLimit);
        result.func_74782_a("operation", (NBTBase)operation);
        return result;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        NBTTagCompound filters = nbt.func_74775_l("filters");
        this.filters.deserializeNBT(filters);
        this.priority = nbt.func_74762_e("prio");
        if (nbt.func_74764_b("inventoryFace")) {
            this.inventoryFace = EnumFacing.func_176739_a((String)nbt.func_74779_i("inventoryFace"));
        }
        try {
            this.filterDirection = EnumStorageDirection.valueOf(nbt.func_74779_i("way"));
        }
        catch (Exception e) {
            this.filterDirection = EnumStorageDirection.BOTH;
        }
        NBTTagCompound operation = nbt.func_74775_l("operation");
        this.operationLimit = operation.func_74762_e("limit");
        this.operationMustBeSmaller = operation.func_74767_n("mustBeSmaller");
        this.operationStack = operation.func_150297_b("stack", 10) ? new ItemStack(operation.func_74775_l("stack")) : ItemStack.field_190927_a;
    }

    public static class Storage
    implements Capability.IStorage<IConnectableLink> {
        @Nullable
        public NBTBase writeNBT(Capability<IConnectableLink> capability, IConnectableLink rawInstance, EnumFacing side) {
            CapabilityConnectableLink instance = (CapabilityConnectableLink)rawInstance;
            return instance.serializeNBT();
        }

        public void readNBT(Capability<IConnectableLink> capability, IConnectableLink rawInstance, EnumFacing side, NBTBase nbt) {
            CapabilityConnectableLink instance = (CapabilityConnectableLink)rawInstance;
            instance.deserializeNBT((NBTTagCompound)nbt);
        }
    }

    public static class Factory
    implements Callable<IConnectableLink> {
        @Override
        public IConnectableLink call() throws Exception {
            return new CapabilityConnectableLink();
        }
    }
}

