/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import mcjty.rftoolscontrol.api.parameters.Parameter;
import mcjty.rftoolscontrol.api.parameters.ParameterType;
import mcjty.rftoolscontrol.api.parameters.ParameterValue;
import mcjty.rftoolscontrol.blocks.processor.ProcessorTileEntity;
import mcjty.rftoolscontrol.logic.ParameterTypeTools;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketVariableToServer
implements IMessage {
    private BlockPos pos;
    private int varIndex;
    private NBTTagCompound tagCompound;

    public void fromBytes(ByteBuf buf) {
        this.pos = NetworkTools.readPos((ByteBuf)buf);
        this.varIndex = buf.readInt();
        this.tagCompound = NetworkTools.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
        buf.writeInt(this.varIndex);
        NetworkTools.writeTag((ByteBuf)buf, (NBTTagCompound)this.tagCompound);
    }

    public PacketVariableToServer() {
    }

    public PacketVariableToServer(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketVariableToServer(BlockPos pos, int varIndex, NBTTagCompound tagCompound) {
        this.pos = pos;
        this.varIndex = varIndex;
        this.tagCompound = tagCompound;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ProcessorTileEntity processor;
            Parameter[] variables;
            EntityPlayerMP playerEntity = ctx.getSender();
            TileEntity te = playerEntity.func_130014_f_().func_175625_s(this.pos);
            if (te instanceof ProcessorTileEntity && this.varIndex < (variables = (processor = (ProcessorTileEntity)te).getVariableArray()).length) {
                Parameter parameter = variables[this.varIndex];
                ParameterType type = parameter.getParameterType();
                ParameterValue value = ParameterTypeTools.readFromNBT(this.tagCompound, type);
                variables[this.varIndex] = Parameter.builder().type(type).value(value).build();
                processor.func_70296_d();
            }
        });
        ctx.setPacketHandled(true);
    }
}

