/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.blocks.workbench;

import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.GenericCrafter;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.FacedSidedInvWrapper;
import mcjty.lib.varia.NullSidedInvWrapper;
import mcjty.rftoolscontrol.blocks.workbench.WorkbenchContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class WorkbenchTileEntity
extends GenericTileEntity
implements DefaultSidedInventory,
GenericCrafter {
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, WorkbenchContainer.factory, 37);
    private int realItems = 0;
    private static final int[] DOWN_SLOTS;
    private static final int[] UP_SLOTS;
    private static final int[] SIDE_SLOTS;
    private static final int[] ALL_SLOTS;
    protected FacedSidedInvWrapper[] handler = new FacedSidedInvWrapper[]{null, null, null, null, null, null};

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        return tagCompound;
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.realItems = tagCompound.func_74762_e("realItems");
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        tagCompound.func_74768_a("realItems", this.realItems);
    }

    private boolean isCraftInputSlot(int slot) {
        return slot >= 0 && slot < 9;
    }

    private boolean isBufferSlot(int slot) {
        return slot >= 10 && slot < 37;
    }

    private boolean isCraftOutput(int slot) {
        return slot == 9;
    }

    private void updateRecipe() {
        if (this.func_70301_a(9) == null || this.realItems == 0) {
            InventoryCrafting workInventory = this.makeWorkInventory();
            IRecipe recipe = CraftingManager.func_192413_b((InventoryCrafting)workInventory, (World)this.func_145831_w());
            if (recipe != null) {
                ItemStack stack = recipe.func_77572_b(workInventory);
                this.getInventoryHelper().setInventorySlotContents(this.func_70297_j_(), 9, stack);
            } else {
                this.getInventoryHelper().setInventorySlotContents(this.func_70297_j_(), 9, ItemStack.field_190927_a);
            }
        }
    }

    private InventoryCrafting makeWorkInventory() {
        InventoryCrafting workInventory = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            workInventory.func_70299_a(i, this.func_70301_a(i + 0));
        }
        return workInventory;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.getInventoryHelper().setInventorySlotContents(this.func_70297_j_(), index, stack);
        if (this.isCraftInputSlot(index)) {
            this.updateRecipe();
        }
    }

    public void craftItem() {
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        if (direction == null) {
            return !this.isCraftOutput(index);
        }
        if (direction == EnumFacing.DOWN) {
            return false;
        }
        if (direction == EnumFacing.UP) {
            return this.isCraftInputSlot(index);
        }
        return this.isBufferSlot(index);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        if (direction == null) {
            return true;
        }
        if (direction == EnumFacing.DOWN) {
            return this.isCraftOutput(index);
        }
        if (direction == EnumFacing.UP) {
            return this.isCraftInputSlot(index);
        }
        return this.isBufferSlot(index);
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == null) {
            return ALL_SLOTS;
        }
        if (side == EnumFacing.DOWN) {
            return DOWN_SLOTS;
        }
        if (side == EnumFacing.UP) {
            return UP_SLOTS;
        }
        return SIDE_SLOTS;
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.isCraftOutput(index) && this.realItems == 0) {
            InventoryCrafting workInventory = this.makeWorkInventory();
            NonNullList remainingItems = CraftingManager.func_180303_b((InventoryCrafting)workInventory, (World)this.func_145831_w());
            for (int i = 0; i < 9; ++i) {
                ItemStack s = this.func_70301_a(i + 0);
                if (!s.func_190926_b()) {
                    this.getInventoryHelper().decrStackSize(i + 0, 1);
                    s = this.func_70301_a(i + 0);
                }
                if (((ItemStack)remainingItems.get(i)).func_190926_b()) continue;
                if (s.func_190926_b()) {
                    this.getInventoryHelper().setStackInSlot(i + 0, (ItemStack)remainingItems.get(i));
                    continue;
                }
                if (!ItemStack.func_179545_c((ItemStack)s, (ItemStack)((ItemStack)remainingItems.get(i))) || !ItemStack.func_77970_a((ItemStack)s, (ItemStack)((ItemStack)remainingItems.get(i)))) continue;
                ItemStack stack = (ItemStack)remainingItems.get(i);
                stack.func_190917_f(s.func_190916_E());
                this.getInventoryHelper().setInventorySlotContents(this.func_70297_j_(), i + 0, (ItemStack)remainingItems.get(i));
            }
        }
        ItemStack rc = this.getInventoryHelper().decrStackSize(index, count);
        if (this.isCraftOutput(index)) {
            ItemStack stack = this.func_70301_a(index);
            this.realItems = !stack.func_190926_b() ? stack.func_190916_E() : 0;
        }
        if (this.isCraftInputSlot(index) || this.isCraftOutput(index)) {
            this.updateRecipe();
        }
        return rc;
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                if (this.invHandlerNull == null) {
                    this.invHandlerNull = new NullSidedInvWrapper((ISidedInventory)this);
                }
                return (T)this.invHandlerNull;
            }
            if (this.handler[facing.ordinal()] == null) {
                this.handler[facing.ordinal()] = new FacedSidedInvWrapper((ISidedInventory)this, facing);
            }
            return (T)this.handler[facing.ordinal()];
        }
        return (T)super.getCapability(capability, facing);
    }

    static {
        int i;
        DOWN_SLOTS = new int[]{9};
        UP_SLOTS = new int[9];
        for (i = 0; i < 9; ++i) {
            WorkbenchTileEntity.UP_SLOTS[i] = i + 0;
        }
        SIDE_SLOTS = new int[27];
        for (i = 0; i < 27; ++i) {
            WorkbenchTileEntity.SIDE_SLOTS[i] = i + 10;
        }
        ALL_SLOTS = new int[36];
        for (i = 0; i < 9; ++i) {
            WorkbenchTileEntity.ALL_SLOTS[i] = i + 0;
        }
        for (i = 0; i < 27; ++i) {
            WorkbenchTileEntity.ALL_SLOTS[i + 9] = i + 10;
        }
    }
}

