/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.world;

import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.common.api.GeolosysAPI;
import com.oitsjustjose.geolosys.common.api.GeolosysSaveData;
import com.oitsjustjose.geolosys.common.util.Utils;
import com.oitsjustjose.geolosys.common.world.ToDoBlocks;
import com.oitsjustjose.geolosys.common.world.WorldGenMinableSafe;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;

public class OreGenerator
implements IWorldGenerator {
    private static final List<IBlockState> blockStateMatchers = GeolosysAPI.replacementMats;
    private static final String dataID = "geolosysOreGeneratorPending";
    private static HashMap<Integer, OreGen> oreSpawnWeights = new HashMap();
    private static int last = 0;

    public static void addOreGen(IBlockState state, int maxVeinSize, int minY, int maxY, int weight, int[] blacklist) {
        OreGen gen = new OreGen(state, maxVeinSize, minY, maxY, weight, blacklist);
        for (int i = last; i < last + weight; ++i) {
            oreSpawnWeights.put(i, gen);
        }
        last += weight;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        ToDoBlocks.getForWorld(world, dataID).processPending(new ChunkPos(chunkX, chunkZ), world, blockStateMatchers);
        if (oreSpawnWeights.keySet().size() > 0) {
            int rng = random.nextInt(oreSpawnWeights.keySet().size());
            oreSpawnWeights.get(rng).generate(world, random, chunkX * 16, chunkZ * 16);
        }
    }

    public static class OreGen {
        WorldGenMinableSafe pluton;
        IBlockState state;
        int minY;
        int maxY;
        int weight;
        int[] blacklistedDims;

        public OreGen(IBlockState state, int maxVeinSize, int minY, int maxY, int weight, int[] blacklist) {
            this.pluton = new WorldGenMinableSafe(state, maxVeinSize, this.doesOreHaveSpecialMatchers(state) ? GeolosysAPI.oreBlocksSpecific.get(state) : blockStateMatchers, OreGenerator.dataID);
            this.state = state;
            this.minY = Math.min(minY, maxY);
            this.maxY = Math.max(minY, maxY);
            this.weight = weight;
            this.blacklistedDims = blacklist;
        }

        public void generate(World world, Random rand, int x, int z) {
            if (!Geolosys.getInstance().chunkOreGen.canGenerateInChunk(world, new ChunkPos(x / 16, z / 16), world.field_73011_w.getDimension())) {
                return;
            }
            boolean lastState = ForgeModContainer.logCascadingWorldGeneration;
            ForgeModContainer.logCascadingWorldGeneration = false;
            for (int d : this.blacklistedDims) {
                if (d != world.field_73011_w.getDimension()) continue;
                return;
            }
            if (rand.nextInt(100) < this.weight) {
                int y;
                int n = y = this.minY != this.maxY ? this.minY + rand.nextInt(this.maxY - this.minY) : this.minY;
                if (Loader.isModLoaded((String)"twilightforest") && world.field_73011_w.getDimension() == 7) {
                    y /= 2;
                    y /= 2;
                }
                if (this.pluton.func_180709_b(world, rand, new BlockPos(x, y, z))) {
                    GeolosysAPI.putWorldDeposit(new ChunkPos(x / 16, z / 16), world.field_73011_w.getDimension(), this.state.func_177230_c().getRegistryName() + ":" + this.state.func_177230_c().func_176201_c(this.state));
                    GeolosysSaveData.get(world).func_76185_a();
                    Geolosys.getInstance().chunkOreGen.addChunk(new ChunkPos(x / 16, z / 16), world, GeolosysAPI.oreBlocks.get(this.state), y);
                }
            }
            ForgeModContainer.logCascadingWorldGeneration = lastState;
        }

        private boolean doesOreHaveSpecialMatchers(IBlockState state) {
            for (IBlockState iBlockState : GeolosysAPI.oreBlocksSpecific.keySet()) {
                if (!Utils.doStatesMatch(iBlockState, state)) continue;
                return true;
            }
            return false;
        }
    }
}

