/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.oitsjustjose.geolosys.client.ClientRegistry;
import com.oitsjustjose.geolosys.client.TranslationManager;
import com.oitsjustjose.geolosys.common.CommonProxy;
import com.oitsjustjose.geolosys.common.api.GeolosysAPI;
import com.oitsjustjose.geolosys.common.blocks.BlockOre;
import com.oitsjustjose.geolosys.common.blocks.BlockOreVanilla;
import com.oitsjustjose.geolosys.common.blocks.BlockSample;
import com.oitsjustjose.geolosys.common.blocks.BlockSampleVanilla;
import com.oitsjustjose.geolosys.common.config.ConfigOres;
import com.oitsjustjose.geolosys.common.config.ConfigParser;
import com.oitsjustjose.geolosys.common.config.ModConfig;
import com.oitsjustjose.geolosys.common.items.ItemCluster;
import com.oitsjustjose.geolosys.common.items.ItemCoal;
import com.oitsjustjose.geolosys.common.items.ItemCoalCoke;
import com.oitsjustjose.geolosys.common.items.ItemFieldManual;
import com.oitsjustjose.geolosys.common.items.ItemIngot;
import com.oitsjustjose.geolosys.common.items.ItemProPick;
import com.oitsjustjose.geolosys.common.util.Recipes;
import com.oitsjustjose.geolosys.common.util.Utils;
import com.oitsjustjose.geolosys.common.world.ChunkData;
import com.oitsjustjose.geolosys.common.world.OreGenerator;
import com.oitsjustjose.geolosys.common.world.StoneGenerator;
import com.oitsjustjose.geolosys.common.world.VanillaWorldGenOverride;
import com.oitsjustjose.geolosys.compat.CompatLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;

@Mod(modid="geolosys", name="Geolosys", version="2.2.6", acceptedMinecraftVersions="1.12", dependencies="after:immersiveengineering@[0.12,);after:contenttweaker;")
public class Geolosys {
    public static final String MODID = "geolosys";
    public static final String VERSION = "2.2.6";
    @SidedProxy(clientSide="com.oitsjustjose.geolosys.client.ClientProxy", serverSide="com.oitsjustjose.geolosys.common.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="geolosys")
    private static Geolosys instance;
    public Logger LOGGER;
    public ConfigOres configOres;
    public ClientRegistry clientRegistry;
    public ChunkData chunkOreGen;
    public BlockOre ORE;
    public BlockOreVanilla ORE_VANILLA;
    public BlockSample ORE_SAMPLE;
    public BlockSampleVanilla ORE_SAMPLE_VANILLA;
    public Item CLUSTER;
    public Item INGOT;
    public Item COAL;
    public Item COAL_COKE;
    public ItemProPick PRO_PICK;
    public Item ALMANAC;

    public static Geolosys getInstance() {
        return instance;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.LOGGER = event.getModLog();
        this.configOres = this.getOresConfig(event.getModConfigurationDirectory());
        this.clientRegistry = new ClientRegistry();
        MinecraftForge.EVENT_BUS.register((Object)this.clientRegistry);
        MinecraftForge.EVENT_BUS.register((Object)new ModConfig.EventHandler());
        this.chunkOreGen = new ChunkData();
        if (event.getSide() == Side.CLIENT) {
            TranslationManager.init();
        }
        this.ORE = new BlockOre();
        this.ORE_SAMPLE = new BlockSample();
        this.ORE_VANILLA = new BlockOreVanilla();
        this.ORE_SAMPLE_VANILLA = new BlockSampleVanilla();
        this.CLUSTER = new ItemCluster();
        this.ALMANAC = new ItemFieldManual();
        if (ModConfig.featureControl.enableIngots) {
            this.INGOT = new ItemIngot();
        }
        if (ModConfig.featureControl.enableCoals) {
            this.COAL = new ItemCoal();
        }
        if (ModConfig.prospecting.enableProPick) {
            this.PRO_PICK = new ItemProPick();
        }
        if (Loader.isModLoaded((String)"immersiveengineering") && ModConfig.featureControl.enableIECompat && ModConfig.featureControl.enableCoals) {
            this.COAL_COKE = new ItemCoalCoke();
        }
        this.registerGeolosysOreGen();
        this.registerVanillaOreGen();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
        MinecraftForge.ORE_GEN_BUS.register((Object)new VanillaWorldGenOverride());
        CompatLoader.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
        if (ModConfig.featureControl.enableSmelting) {
            Recipes.init(this.configOres, this.CLUSTER);
        }
        ConfigParser.init();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new OreGenerator(), (int)0);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new StoneGenerator(), (int)100);
    }

    private void registerVanillaOreGen() {
        if (this.configOres.coal.getChance() > 0) {
            GeolosysAPI.registerMineralDeposit(Utils.getStateFromMeta(this.ORE_VANILLA, 0), Utils.getStateFromMeta(this.ORE_SAMPLE_VANILLA, 0), this.configOres.coal);
        }
        if (this.configOres.cinnabar.getChance() > 0) {
            GeolosysAPI.registerMineralDeposit(Utils.getStateFromMeta(this.ORE_VANILLA, 1), Utils.getStateFromMeta(this.ORE_SAMPLE_VANILLA, 1), this.configOres.cinnabar);
        }
        if (this.configOres.gold.getChance() > 0) {
            GeolosysAPI.registerMineralDeposit(Utils.getStateFromMeta(this.ORE_VANILLA, 2), Utils.getStateFromMeta(this.ORE_SAMPLE_VANILLA, 2), this.configOres.gold);
        }
        if (this.configOres.lapis.getChance() > 0) {
            GeolosysAPI.registerMineralDeposit(Utils.getStateFromMeta(this.ORE_VANILLA, 3), Utils.getStateFromMeta(this.ORE_SAMPLE_VANILLA, 3), this.configOres.lapis);
        }
        if (this.configOres.quartz.getChance() > 0) {
            GeolosysAPI.registerMineralDeposit(Utils.getStateFromMeta(this.ORE_VANILLA, 4), Utils.getStateFromMeta(this.ORE_SAMPLE_VANILLA, 4), this.configOres.quartz);
        }
        if (this.configOres.kimberlite.getChance() > 0) {
            GeolosysAPI.registerMineralDeposit(Utils.getStateFromMeta(this.ORE_VANILLA, 5), Utils.getStateFromMeta(this.ORE_SAMPLE_VANILLA, 5), this.configOres.kimberlite);
        }
        if (this.configOres.beryl.getChance() > 0) {
            GeolosysAPI.registerMineralDeposit(Utils.getStateFromMeta(this.ORE_VANILLA, 6), Utils.getStateFromMeta(this.ORE_SAMPLE_VANILLA, 6), this.configOres.beryl);
        }
        if (ModConfig.featureControl.modStones) {
            IBlockState diorite = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.DIORITE);
            IBlockState andesite = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE);
            IBlockState granite = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.GRANITE);
            GeolosysAPI.registerStoneDeposit(andesite, 2, 70, 40);
            GeolosysAPI.registerStoneDeposit(diorite, 2, 70, 40);
            GeolosysAPI.registerStoneDeposit(granite, 2, 70, 40);
        }
    }

    private void registerGeolosysOreGen() {
        if (this.configOres.hematite.getChance() > 0) {
            GeolosysAPI.registerMineralDeposit(Utils.getStateFromMeta(this.ORE, 0), Utils.getStateFromMeta(this.ORE_SAMPLE, 0), this.configOres.hematite);
        }
        if (this.configOres.lapis.getChance() > 0) {
            GeolosysAPI.registerMineralDeposit(Utils.getStateFromMeta(this.ORE, 1), Utils.getStateFromMeta(this.ORE_SAMPLE, 1), this.configOres.limonite);
        }
        if (this.configOres.malachite.getChance() > 0) {
            GeolosysAPI.registerMineralDeposit(Utils.getStateFromMeta(this.ORE, 2), Utils.getStateFromMeta(this.ORE_SAMPLE, 2), this.configOres.malachite);
        }
        if (this.configOres.azurite.getChance() > 0) {
            GeolosysAPI.registerMineralDeposit(Utils.getStateFromMeta(this.ORE, 3), Utils.getStateFromMeta(this.ORE_SAMPLE, 3), this.configOres.azurite);
        }
        if (this.configOres.cassiterite.getChance() > 0) {
            GeolosysAPI.registerMineralDeposit(Utils.getStateFromMeta(this.ORE, 4), Utils.getStateFromMeta(this.ORE_SAMPLE, 4), this.configOres.cassiterite);
        }
        if (this.configOres.teallite.getChance() > 0) {
            GeolosysAPI.registerMineralDeposit(Utils.getStateFromMeta(this.ORE, 5), Utils.getStateFromMeta(this.ORE_SAMPLE, 5), this.configOres.teallite);
        }
        if (this.configOres.galena.getChance() > 0) {
            GeolosysAPI.registerMineralDeposit(Utils.getStateFromMeta(this.ORE, 6), Utils.getStateFromMeta(this.ORE_SAMPLE, 6), this.configOres.galena);
        }
        if (this.configOres.bauxite.getChance() > 0) {
            GeolosysAPI.registerMineralDeposit(Utils.getStateFromMeta(this.ORE, 7), Utils.getStateFromMeta(this.ORE_SAMPLE, 7), this.configOres.bauxite);
        }
        if (this.configOres.platinum.getChance() > 0) {
            GeolosysAPI.registerMineralDeposit(Utils.getStateFromMeta(this.ORE, 8), Utils.getStateFromMeta(this.ORE_SAMPLE, 8), this.configOres.platinum);
        }
        if (this.configOres.autunite.getChance() > 0) {
            GeolosysAPI.registerMineralDeposit(Utils.getStateFromMeta(this.ORE, 9), Utils.getStateFromMeta(this.ORE_SAMPLE, 9), this.configOres.autunite);
        }
        if (this.configOres.sphalerite.getChance() > 0) {
            GeolosysAPI.registerMineralDeposit(Utils.getStateFromMeta(this.ORE, 10), Utils.getStateFromMeta(this.ORE_SAMPLE, 10), this.configOres.sphalerite);
        }
    }

    @Nonnull
    private ConfigOres getOresConfig(File configDir) {
        try {
            FileReader fr = new FileReader(configDir.getAbsolutePath() + "/geolosys_ores.json".replace("/", File.separator));
            BufferedReader br = new BufferedReader(fr);
            StringBuilder json = new StringBuilder();
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    json.append(line);
                }
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                ConfigOres ret = (ConfigOres)gson.fromJson(json.toString(), ConfigOres.class);
                ret.validate(configDir);
                br.close();
                return ret;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (FileNotFoundException e) {
            ConfigOres props = new ConfigOres();
            props.populateConfigs();
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson((Object)props);
            try {
                FileWriter fw = new FileWriter(configDir.getAbsolutePath() + "/geolosys_ores.json".replace("/", File.separator));
                fw.write(json);
                fw.close();
                return props;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return this.getOresConfig(configDir);
    }
}

