/*
 * Decompiled with CFR 0.152.
 */
package lex.config;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lex.LibEx;
import lex.util.BlockStateHelper;
import lex.util.ConfigHelper;
import lex.util.NBTHelper;
import lex.util.NumberHelper;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.util.Strings;

public class Config {
    protected static final JsonParser JSON_PARSER = new JsonParser();
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    protected Map<String, JsonElement> DATA;
    protected Map<String, JsonElement> FALLBACK_DATA;
    protected Map<String, Config> DATA_BRANCHES;
    private boolean keepDataOrder;

    public Config(File configFile, boolean keepDataOrder) {
        String jsonString = new JsonObject().toString();
        if (configFile.exists()) {
            try {
                jsonString = FileUtils.readFileToString((File)configFile, (Charset)Charset.defaultCharset());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.keepDataOrder = keepDataOrder;
        if (keepDataOrder) {
            this.DATA = new LinkedHashMap<String, JsonElement>();
            this.FALLBACK_DATA = new LinkedHashMap<String, JsonElement>();
            this.DATA_BRANCHES = new LinkedHashMap<String, Config>();
        } else {
            this.DATA = new HashMap<String, JsonElement>();
            this.FALLBACK_DATA = new HashMap<String, JsonElement>();
            this.DATA_BRANCHES = new HashMap<String, Config>();
        }
        this.deserialize(jsonString);
    }

    public Config(String jsonString, boolean keepDataOrder) {
        this.keepDataOrder = keepDataOrder;
        if (keepDataOrder) {
            this.DATA = new LinkedHashMap<String, JsonElement>();
            this.FALLBACK_DATA = new LinkedHashMap<String, JsonElement>();
            this.DATA_BRANCHES = new LinkedHashMap<String, Config>();
        } else {
            this.DATA = new HashMap<String, JsonElement>();
            this.FALLBACK_DATA = new HashMap<String, JsonElement>();
            this.DATA_BRANCHES = new HashMap<String, Config>();
        }
        this.deserialize(jsonString);
    }

    public void deserialize(String jsonString) {
        JsonElement element;
        if (!Strings.isBlank((String)jsonString) && ConfigHelper.isObject(element = JSON_PARSER.parse(jsonString))) {
            for (Map.Entry entry : element.getAsJsonObject().entrySet()) {
                this.DATA.put((String)entry.getKey(), (JsonElement)entry.getValue());
            }
        }
    }

    public JsonElement serialize() {
        JsonObject object = new JsonObject();
        for (Map.Entry<String, Config> entry : this.DATA_BRANCHES.entrySet()) {
            if (this.hasData(entry.getKey())) {
                this.addData(entry.getKey(), entry.getValue().serialize());
                continue;
            }
            if (!this.hasFallbackData(entry.getKey())) continue;
            this.addFallbackData(entry.getKey(), entry.getValue().serialize());
        }
        for (Map.Entry<String, Config> entry : this.DATA.entrySet()) {
            object.add(entry.getKey(), (JsonElement)entry.getValue());
        }
        for (Map.Entry<String, Config> entry : this.FALLBACK_DATA.entrySet()) {
            if (object.has(entry.getKey())) continue;
            object.add(entry.getKey(), (JsonElement)entry.getValue());
        }
        return object;
    }

    public void addData(String key, JsonElement element) {
        this.DATA.put(key, element);
    }

    public void addFallbackData(String key, JsonElement element) {
        this.FALLBACK_DATA.put(key, element);
    }

    public void addDataBranch(String key, Config config) {
        this.DATA_BRANCHES.put(key, config);
    }

    public boolean hasData(String key) {
        return this.DATA.containsKey(key);
    }

    public boolean hasFallbackData(String key) {
        return this.FALLBACK_DATA.containsKey(key);
    }

    public boolean hasDataBranch(String key) {
        return this.DATA_BRANCHES.containsKey(key);
    }

    public JsonElement getData(String key) {
        return this.DATA.get(key);
    }

    public JsonElement getFallbackData(String key) {
        return this.FALLBACK_DATA.get(key);
    }

    public Map<String, JsonElement> getAllData() {
        return ImmutableMap.copyOf(this.DATA);
    }

    public void removeData(String key) {
        this.DATA.remove(key);
    }

    public void removeFallbackData(String key) {
        this.FALLBACK_DATA.remove(key);
    }

    public JsonElement replaceData(String key, JsonElement data) {
        return this.DATA.replace(key, data);
    }

    public JsonElement replaceFallbackData(String key, JsonElement data) {
        return this.FALLBACK_DATA.replace(key, data);
    }

    public String getString(String key, String fallbackValue) {
        String value = this.getString(key);
        if (value.equals("MissingNo")) {
            this.addFallbackData(key, (JsonElement)new JsonPrimitive(fallbackValue));
            return fallbackValue;
        }
        return value;
    }

    public int getInt(String key, int fallbackValue) {
        int value = this.getInt(key);
        if (value == -999) {
            this.addFallbackData(key, (JsonElement)new JsonPrimitive((Number)fallbackValue));
            return fallbackValue;
        }
        return value;
    }

    public float getFloat(String key, float fallbackValue) {
        float value = this.getFloat(key);
        if (value == -999.0f) {
            this.addFallbackData(key, (JsonElement)new JsonPrimitive((Number)Float.valueOf(fallbackValue)));
            return fallbackValue;
        }
        return value;
    }

    public boolean getBoolean(String key, boolean fallbackValue) {
        boolean value = this.getBoolean(key);
        if (!ConfigHelper.isBoolean(this.getData(key))) {
            this.addFallbackData(key, (JsonElement)new JsonPrimitive(Boolean.valueOf(fallbackValue)));
            return fallbackValue;
        }
        return value;
    }

    public <E extends Enum> E getEnum(String key, Class<? extends E> enumClass, E fallbackValue) {
        E value = this.getEnum(key, enumClass);
        if (value == null) {
            this.addFallbackData(key, (JsonElement)new JsonPrimitive(fallbackValue.name().toLowerCase()));
            return fallbackValue;
        }
        return value;
    }

    public ResourceLocation getResource(String key, ResourceLocation fallbackValue) {
        ResourceLocation value = this.getResource(key);
        if (value == null) {
            this.addFallbackData(key, (JsonElement)new JsonPrimitive(fallbackValue.toString()));
            return fallbackValue;
        }
        return value;
    }

    public IBlockState getBlock(String key, IBlockState fallbackValue) {
        IBlockState value = this.getBlock(key);
        if (value == null) {
            JsonObject block = new JsonObject();
            JsonObject properties = new JsonObject();
            block.addProperty("block", fallbackValue.func_177230_c().getRegistryName().toString());
            for (Map.Entry entry : fallbackValue.func_177228_b().entrySet()) {
                properties.addProperty(((IProperty)entry.getKey()).func_177701_a(), ((Comparable)entry.getValue()).toString().toLowerCase());
            }
            block.add("properties", (JsonElement)properties);
            this.addFallbackData(key, (JsonElement)block);
            return fallbackValue;
        }
        return value;
    }

    public ItemStack getItem(String key, ItemStack fallbackValue) {
        ItemStack value = this.getItem(key);
        if (value.func_190926_b()) {
            JsonObject item = new JsonObject();
            item.addProperty("item", fallbackValue.func_77973_b().getRegistryName().toString());
            item.addProperty("meta", (Number)fallbackValue.func_77952_i());
            this.addFallbackData(key, (JsonElement)item);
            return fallbackValue;
        }
        return value;
    }

    public Config getDataBranch(String key, JsonObject fallbackValue) {
        Config value = this.getDataBranch(key);
        if (value == null) {
            this.addFallbackData(key, (JsonElement)fallbackValue);
            return new Config(fallbackValue.toString(), this.keepDataOrder);
        }
        return value;
    }

    public String getString(String key) {
        if (ConfigHelper.isString(this.getData(key))) {
            return this.getData(key).getAsJsonPrimitive().getAsString();
        }
        return "MissingNo";
    }

    public int getInt(String key) {
        if (ConfigHelper.isInt(this.getData(key))) {
            return this.getData(key).getAsJsonPrimitive().getAsInt();
        }
        return -999;
    }

    public float getFloat(String key) {
        if (ConfigHelper.isFloat(this.getData(key))) {
            return this.getData(key).getAsJsonPrimitive().getAsFloat();
        }
        return -999.0f;
    }

    public boolean getBoolean(String key) {
        if (ConfigHelper.isBoolean(this.getData(key))) {
            return this.getData(key).getAsJsonPrimitive().getAsBoolean();
        }
        return false;
    }

    public <E extends Enum> E getEnum(String key, Class<? extends E> enumClass) {
        if (ConfigHelper.isString(this.getData(key))) {
            String enumIdentifier = this.getData(key).getAsJsonPrimitive().getAsString();
            if (enumIdentifier.equalsIgnoreCase("random") || enumIdentifier.equalsIgnoreCase("rand")) {
                return (E)((Enum[])enumClass.getEnumConstants())[NumberHelper.getRand().nextInt(((Enum[])enumClass.getEnumConstants()).length)];
            }
            for (Enum value : (Enum[])enumClass.getEnumConstants()) {
                if (!value.name().equalsIgnoreCase(enumIdentifier)) continue;
                return (E)value;
            }
        }
        return null;
    }

    public ResourceLocation getResource(String key) {
        if (ConfigHelper.isString(this.getData(key))) {
            return new ResourceLocation(this.getString(key));
        }
        return null;
    }

    public IBlockState getBlock(String key) {
        Block block;
        if (!ConfigHelper.isObject(this.getData(key))) {
            return null;
        }
        JsonObject object = this.getData(key).getAsJsonObject();
        JsonElement blockName = null;
        if (ConfigHelper.isString(object.get("block"))) {
            blockName = object.get("block");
        } else if (ConfigHelper.isString(object.get("itemBlock"))) {
            blockName = object.get("itemBlock");
        }
        if (blockName != null && (block = Block.func_149684_b((String)blockName.getAsJsonPrimitive().getAsString())) != null) {
            JsonElement properties;
            IBlockState state = block.func_176223_P();
            if (object.has("properties") && ConfigHelper.isObject(properties = object.get("properties"))) {
                for (Map.Entry entry : properties.getAsJsonObject().entrySet()) {
                    Comparable propertyValue;
                    IProperty property = BlockStateHelper.getProperty(state, (String)entry.getKey());
                    if (property == null || !ConfigHelper.isString((JsonElement)entry.getValue()) || (propertyValue = BlockStateHelper.getPropertyValue(property, ((JsonElement)entry.getValue()).getAsJsonPrimitive().getAsString())) == null) continue;
                    state = state.func_177226_a(property, propertyValue);
                }
            }
            return state;
        }
        return null;
    }

    public ItemStack getItem(String key) {
        Config itemConfig = this.getDataBranch(key);
        ItemStack stack = ItemStack.field_190927_a;
        if (itemConfig != null) {
            ResourceLocation item = null;
            if (ConfigHelper.isString(itemConfig.getData("item"))) {
                item = itemConfig.getResource("item");
            } else if (ConfigHelper.isString(itemConfig.getData("itemBlock"))) {
                item = itemConfig.getResource("itemBlock");
            }
            if (item != null) {
                int meta = itemConfig.getInt("meta", 0);
                if (ForgeRegistries.ITEMS.containsKey(item)) {
                    stack = new ItemStack(Item.func_111206_d((String)item.toString()), 1, meta);
                } else if (ForgeRegistries.BLOCKS.containsKey(item)) {
                    IBlockState state = this.getBlock(key);
                    Block block = state.func_177230_c();
                    stack = new ItemStack(block, 1, block.func_176201_c(state));
                }
                if (!stack.func_190926_b()) {
                    List<Config> enchantmentConfigs;
                    Config loreConfig;
                    if (ConfigHelper.isString(itemConfig.getData("displayName"))) {
                        stack.func_151001_c(itemConfig.getString("displayName"));
                    }
                    if ((loreConfig = this.getDataBranch("lore")) != null && loreConfig.getAllData().size() > 0) {
                        NBTHelper.setTagCompound(stack);
                        NBTTagList loreList = new NBTTagList();
                        for (Map.Entry entry : loreConfig.getAllData().entrySet()) {
                            if (!ConfigHelper.isString((JsonElement)entry.getValue())) continue;
                            loreList.func_74742_a((NBTBase)new NBTTagString(((JsonElement)entry.getValue()).getAsJsonPrimitive().getAsString()));
                        }
                        NBTTagCompound displayCompound = new NBTTagCompound();
                        displayCompound.func_74782_a("Lore", (NBTBase)loreList);
                        NBTTagCompound nBTTagCompound = new NBTTagCompound();
                        nBTTagCompound.func_74782_a("display", (NBTBase)displayCompound);
                        NBTHelper.setTagCompound(stack, nBTTagCompound);
                    }
                    if ((enchantmentConfigs = itemConfig.getDataBranches("enchantments")) != null) {
                        for (Config config : enchantmentConfigs) {
                            Enchantment enchantment;
                            if (!ConfigHelper.isString(config.getData("enchantment")) || (enchantment = Enchantment.func_180305_b((String)config.getString("enchantment"))) == null) continue;
                            int enchantmentLevel = NumberHelper.getNumberInRange(config.getInt("minEnchantmentLevel", 1), config.getInt("minEnchantmentLevel", 3), NumberHelper.getRand());
                            if (stack.func_77973_b() instanceof ItemEnchantedBook) {
                                ItemEnchantedBook.func_92115_a((ItemStack)stack, (EnchantmentData)new EnchantmentData(enchantment, enchantmentLevel));
                                continue;
                            }
                            stack.func_77966_a(enchantment, enchantmentLevel);
                        }
                    }
                }
            }
        }
        return stack;
    }

    public Config getDataBranch(String key) {
        if (this.hasDataBranch(key)) {
            return this.DATA_BRANCHES.get(key);
        }
        if (ConfigHelper.isObject(this.getData(key))) {
            Config config = new Config(this.getData(key).toString(), this.keepDataOrder);
            this.DATA_BRANCHES.put(key, config);
            return config;
        }
        return null;
    }

    public List<Config> getDataBranches(String key, List<JsonObject> fallbackValue) {
        List<Config> value = this.getDataBranches(key);
        if (value == null) {
            JsonArray array = new JsonArray();
            fallbackValue.forEach(arg_0 -> ((JsonArray)array).add(arg_0));
            this.addFallbackData(key, (JsonElement)array);
            ArrayList<Config> ret = new ArrayList<Config>();
            fallbackValue.forEach(k -> ret.add(new Config(k.toString(), this.keepDataOrder)));
            return ret;
        }
        return value;
    }

    public List<Config> getDataBranches(String key) {
        if (ConfigHelper.isArray(this.getData(key))) {
            JsonArray array = this.getData(key).getAsJsonArray();
            ArrayList<Config> subConfigs = new ArrayList<Config>();
            for (JsonElement element : array) {
                if (!ConfigHelper.isObject(element)) continue;
                subConfigs.add(new Config(element.toString(), this.keepDataOrder));
            }
            return subConfigs;
        }
        return null;
    }

    public List<String> getStrings(String key, List<String> fallbackValue) {
        List<String> value = this.getStrings(key);
        if (value == null) {
            JsonArray array = new JsonArray();
            fallbackValue.forEach(arg_0 -> ((JsonArray)array).add(arg_0));
            this.addFallbackData(key, (JsonElement)array);
            return fallbackValue;
        }
        return value;
    }

    public List<String> getStrings(String key) {
        if (ConfigHelper.isArray(this.getData(key))) {
            JsonArray array = this.getData(key).getAsJsonArray();
            ArrayList<String> strings = new ArrayList<String>();
            for (JsonElement element : array) {
                if (!ConfigHelper.isPrimitive(element)) continue;
                strings.add(element.getAsJsonPrimitive().getAsString());
            }
            return strings;
        }
        return null;
    }

    public void save(File configFile) {
        if (configFile != null) {
            if (configFile.getPath().startsWith("~")) {
                configFile = new File(configFile.getPath().replace("~", LibEx.CONFIG_DIRECTORY.getPath()));
            }
            String jsonString = GSON.toJson(this.serialize());
            try {
                FileUtils.write((File)configFile, (CharSequence)jsonString, (Charset)Charset.defaultCharset());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

