/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.util;

import cd4017be.lib.util.IFilter;
import cd4017be.lib.util.OreDictStack;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemFluidUtil {
    public static final String Tag_ItemList = "Items";
    public static final String Tag_ItemIndex = "ItIdx";
    public static final String Tag_FluidList = "Fluids";
    public static final String Tag_FluidIndex = "FlIdx";
    public static final Container CraftContDummy = new Container(){

        public boolean func_75145_c(EntityPlayer var1) {
            return true;
        }

        public void func_75130_a(IInventory par1IInventory) {
        }
    };
    public static final IFluidTankProperties[] NO_TANKS = new IFluidTankProperties[0];

    public static void loadInventory(NBTTagList list, ItemStack[] inv) {
        Arrays.fill(inv, ItemStack.field_190927_a);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            int s = tag.func_74771_c("slot") & 0xFF;
            if (s >= inv.length) continue;
            inv[s] = new ItemStack(tag);
        }
    }

    public static NBTTagList saveInventory(ItemStack[] inv) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < inv.length; ++i) {
            if (inv[i].func_190926_b()) continue;
            NBTTagCompound tag = new NBTTagCompound();
            inv[i].func_77955_b(tag);
            tag.func_74774_a("slot", (byte)i);
            list.func_74742_a((NBTBase)tag);
        }
        return list;
    }

    public static ItemStack[] loadItems(NBTTagList list) {
        ItemStack[] items = new ItemStack[list.func_74745_c()];
        for (int i = 0; i < items.length; ++i) {
            items[i] = new ItemStack(list.func_150305_b(i));
        }
        return items;
    }

    public static void loadItems(NBTTagList list, ItemStack[] items) {
        int m = Math.min(items.length, list.func_74745_c());
        for (int i = 0; i < m; ++i) {
            items[i] = new ItemStack(list.func_150305_b(i));
        }
        Arrays.fill(items, m, items.length, ItemStack.field_190927_a);
    }

    public static NBTTagList saveItems(ItemStack[] items) {
        NBTTagList list = new NBTTagList();
        for (ItemStack item : items) {
            if (item.func_190926_b()) continue;
            NBTTagCompound tag = new NBTTagCompound();
            item.func_77955_b(tag);
            list.func_74742_a((NBTBase)tag);
        }
        return list;
    }

    public static NBTTagCompound saveItemHighRes(ItemStack item) {
        NBTTagCompound nbt = new NBTTagCompound();
        item.func_77955_b(nbt);
        nbt.func_82580_o("Count");
        nbt.func_74768_a("Num", item.func_190916_E());
        return nbt;
    }

    public static ItemStack loadItemHighRes(NBTTagCompound nbt) {
        ItemStack item = new ItemStack(nbt);
        item.func_190920_e(nbt.func_74762_e("Num"));
        return item;
    }

    public static NBTTagList saveFluids(FluidStack[] fluids) {
        NBTTagList list = new NBTTagList();
        for (FluidStack fluid : fluids) {
            if (fluid == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            fluid.writeToNBT(tag);
            list.func_74742_a((NBTBase)tag);
        }
        return list;
    }

    public static FluidStack[] loadFluids(NBTTagList list) {
        FluidStack[] fluids = new FluidStack[list.func_74745_c()];
        for (int i = 0; i < fluids.length; ++i) {
            fluids[i] = FluidStack.loadFluidStackFromNBT((NBTTagCompound)list.func_150305_b(i));
        }
        return fluids;
    }

    public static InventoryCrafting craftingInventory(ItemStack[] grid, int size) {
        InventoryCrafting icr = new InventoryCrafting(CraftContDummy, size, size);
        int m = Math.min(grid.length, icr.func_70302_i_());
        for (int i = 0; i < m; ++i) {
            icr.func_70299_a(i, grid[i]);
        }
        return icr;
    }

    public static int transferItems(IItemHandler src, IItemHandler dst, IFilter<ItemStack, IItemHandler> extr, IFilter<ItemStack, IItemHandler> ins) {
        int m = 0;
        for (int i = 0; i < src.getSlots(); ++i) {
            ItemStack stack = src.extractItem(i, 65536, true);
            int n = stack.func_190916_E();
            if (n == 0 || extr != null && (n = (stack = extr.getExtract(stack, src)).func_190916_E()) == 0) continue;
            if (ins != null) {
                n = ins.insertAmount(stack, dst);
                if (n == 0) continue;
                stack = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)n);
            }
            if ((n -= ItemHandlerHelper.insertItemStacked((IItemHandler)dst, (ItemStack)stack, (boolean)false).func_190916_E()) <= 0) continue;
            src.extractItem(i, n, false);
            m += n;
        }
        return m;
    }

    public static int findStack(ItemStack item, IItemHandler inv, int p) {
        if (item.func_190926_b()) {
            return -1;
        }
        for (int i = p; i < inv.getSlots(); ++i) {
            if (!ItemStack.func_77989_b((ItemStack)item, (ItemStack)inv.getStackInSlot(i))) continue;
            return i;
        }
        return -1;
    }

    public static ItemStack putInSlots(IItemHandler inv, ItemStack stack, int ... slots) {
        for (int s : slots) {
            if (inv.getStackInSlot(s).func_190916_E() <= 0 || (stack = inv.insertItem(s, stack, false)).func_190916_E() != 0) continue;
            return stack;
        }
        for (int s : slots) {
            if (inv.getStackInSlot(s).func_190916_E() == 0 && (stack = inv.insertItem(s, stack, false)).func_190916_E() == 0) break;
        }
        return stack;
    }

    public static int drain(IItemHandler inv, ItemStack type, int am) {
        int m = 0;
        for (int i = 0; i < inv.getSlots() && m < am; ++i) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)type, (ItemStack)inv.getStackInSlot(i))) continue;
            ItemStack stack = inv.extractItem(i, am - m, false);
            m += stack.func_190916_E();
        }
        return m;
    }

    public static int drain(IItemHandler inv, OreDictStack ore, ArrayList<ItemStack> buffer) {
        int n = ore.stacksize;
        int m = 0;
        for (int i = 0; i < inv.getSlots() && m < n; ++i) {
            ItemStack stack;
            int x;
            if (!ore.isEqual(inv.getStackInSlot(i)) || (x = (stack = inv.extractItem(i, n - m, false)).func_190916_E()) <= 0) continue;
            m += x;
            ItemFluidUtil.addToList(buffer, stack);
        }
        return m;
    }

    public static void addToList(ArrayList<ItemStack> list, ItemStack item) {
        for (ItemStack stack : list) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)item, (ItemStack)stack)) continue;
            stack.func_190917_f(item.func_190916_E());
            return;
        }
        list.add(item);
    }

    public static void addToList(ArrayList<FluidStack> list, FluidStack fluid) {
        for (FluidStack stack : list) {
            if (!fluid.isFluidEqual(stack)) continue;
            stack.amount += fluid.amount;
            return;
        }
        list.add(fluid);
    }

    public static ItemStack drain(IItemHandler inv, int am) {
        boolean mss;
        boolean bl = mss = am < 0;
        if (mss) {
            am = 65536;
        }
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.extractItem(i, am, true);
            if (stack.func_190916_E() == 0) continue;
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)ItemFluidUtil.drain(inv, stack, mss ? stack.func_77976_d() : am));
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack drain(IItemHandler inv, ToIntFunction<ItemStack> filter) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            int m;
            ItemStack stack = inv.extractItem(i, 1, true);
            if (stack.func_190916_E() <= 0 || (m = filter.applyAsInt(stack)) <= 0) continue;
            int n = inv.extractItem(i, m, false).func_190916_E();
            while (n < m && ++i < inv.getSlots()) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)inv.getStackInSlot(i), (ItemStack)stack)) continue;
                n += inv.extractItem(i, m, false).func_190916_E();
            }
            stack.func_190920_e(n);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public static IFluidTankProperties[] listTanks(IFluidHandler acc) {
        IFluidTankProperties[] p = acc.getTankProperties();
        return p == null ? NO_TANKS : p;
    }

    public static void dropStack(ItemStack stack, Entity entity) {
        if (stack.func_190926_b()) {
            return;
        }
        EntityItem ei = new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, stack);
        entity.field_70170_p.func_72838_d((Entity)ei);
    }

    public static void dropStack(ItemStack stack, World world, BlockPos pos) {
        if (stack.func_190926_b()) {
            return;
        }
        EntityItem ei = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
        world.func_72838_d((Entity)ei);
    }

    public static void writeFluidStack(PacketBuffer buf, FluidStack stack) {
        if (stack == null) {
            buf.func_180714_a("");
            return;
        }
        buf.func_180714_a(FluidRegistry.getFluidName((FluidStack)stack));
        buf.writeInt(stack.amount);
        buf.func_150786_a(stack.tag);
    }

    public static FluidStack readFluidStack(PacketBuffer buf) throws IOException {
        String s = buf.func_150789_c(Short.MAX_VALUE);
        if (s.isEmpty()) {
            return null;
        }
        int n = buf.readInt();
        NBTTagCompound tag = buf.func_150793_b();
        Fluid fluid = FluidRegistry.getFluid((String)s);
        if (fluid == null) {
            return null;
        }
        FluidStack stack = new FluidStack(fluid, n);
        stack.tag = tag;
        return stack;
    }

    public static class StackedFluidAccess
    implements IFluidHandler {
        public final IFluidHandlerItem acc;
        private final int n;

        public StackedFluidAccess(ItemStack item) {
            this.n = item.func_190916_E();
            this.acc = this.n > 0 ? FluidUtil.getFluidHandler((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)item, (int)1)) : null;
        }

        public boolean valid() {
            return this.acc != null;
        }

        public IFluidTankProperties[] getTankProperties() {
            return this.acc.getTankProperties();
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (this.n > 1) {
                resource = new FluidStack(resource, resource.amount / this.n);
            }
            return this.acc.fill(resource, doFill) * this.n;
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            FluidStack stack;
            if (this.n > 1) {
                resource = new FluidStack(resource, resource.amount / this.n);
            }
            if ((stack = this.acc.drain(resource, doDrain)) != null) {
                stack.amount *= this.n;
            }
            return stack;
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            FluidStack stack = this.acc.drain(maxDrain / this.n, doDrain);
            if (stack != null) {
                stack.amount *= this.n;
            }
            return stack;
        }

        public ItemStack result() {
            ItemStack item = this.acc.getContainer();
            item.func_190920_e(item.func_190916_E() * this.n);
            return item;
        }
    }
}

