/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.Gui.inWorld;

import cd4017be.lib.BlockGuiHandler;
import cd4017be.lib.Gui.inWorld.ClickType;
import cd4017be.lib.block.AdvancedBlock;
import cd4017be.lib.tileentity.BaseTileEntity;
import cd4017be.lib.util.Orientation;
import cd4017be.lib.util.Utils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class InWorldUITile
extends BaseTileEntity
implements AdvancedBlock.IInteractiveTile {
    public static double VIEW_DIST = 4.0;
    protected static final byte SEND_INTERVAL = 10;
    protected byte packetTimer;

    public InWorldUITile() {
    }

    public InWorldUITile(IBlockState state) {
        super(state);
    }

    protected void sendPacket(boolean force) {
        if (!force && (this.packetTimer = (byte)(this.packetTimer + 1)) < 10) {
            return;
        }
        this.packetTimer = 0;
        PacketBuffer data = BlockGuiHandler.getPacketTargetData(this.field_174879_c);
        this.getPacketData(data);
        BlockGuiHandler.sendPacketToAllNear(this, VIEW_DIST * 2.0, data);
    }

    protected abstract void getPacketData(PacketBuffer var1);

    protected abstract UIElement[] getBoxes();

    protected abstract void onInteract(EntityPlayer var1, ItemStack var2, EnumHand var3, RayTraceResult var4, ClickType var5);

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack item, EnumFacing s, float X, float Y, float Z) {
        RayTraceResult hit = this.getAimTarget((Entity)player, 1.0f);
        if (hit == null) {
            return false;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.onInteract(player, item, hand, hit, ClickType.use);
        }
        return true;
    }

    @Override
    public void onClicked(EntityPlayer player) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        RayTraceResult hit = this.getAimTarget((Entity)player, 1.0f);
        if (hit != null) {
            this.onInteract(player, player.func_184586_b(player.field_184622_au), player.field_184622_au, hit, ClickType.hit);
        }
    }

    public RayTraceResult getAimTarget(Entity e, float t) {
        Orientation o = this.getOrientation();
        Vec3d start = o.invRotate(e.func_174824_e(t).func_178786_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5)).func_72441_c(0.5, 0.5, 0.5);
        Vec3d end = o.invRotate(e.func_70676_i(t).func_186678_a(VIEW_DIST)).func_178787_e(start);
        RayTraceResult hit = null;
        UIElement[] boxes = this.getBoxes();
        for (int i = 0; i < boxes.length; ++i) {
            RayTraceResult h = boxes[i].intercept(start, end);
            if (h == null) continue;
            hit = h;
            end = hit.field_72307_f;
        }
        return hit;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return VIEW_DIST * VIEW_DIST;
    }

    public static class UIElement {
        public final AxisAlignedBB box;
        public final int id;
        public byte accSides;

        public UIElement(int id, double x0, double y0, double z0, double x1, double y1, double z1, int sides) {
            this.id = id;
            this.box = new AxisAlignedBB(x0 / 16.0, y0 / 16.0, z0 / 16.0, x1 / 16.0, y1 / 16.0, z1 / 16.0);
            this.accSides = (byte)sides;
        }

        public RayTraceResult intercept(Vec3d start, Vec3d end) {
            RayTraceResult res = this.box.func_72327_a(start, end);
            if (res == null || (this.accSides >> res.field_178784_b.ordinal() & 1) == 0) {
                return null;
            }
            res.subHit = this.id;
            return res;
        }

        public double interpolate(Vec3d hit, EnumFacing dir) {
            double p = Utils.coord(hit.field_72450_a, hit.field_72448_b, hit.field_72449_c, dir);
            double a = Utils.coord(this.box.field_72340_a, this.box.field_72338_b, this.box.field_72339_c, dir);
            double b = Utils.coord(this.box.field_72336_d, this.box.field_72337_e, this.box.field_72334_f, dir);
            return (dir.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? p - a : b - p) / (b - a);
        }
    }
}

