/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.rs_ctr.wire;

import cd4017be.api.rs_ctr.port.IConnector;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.api.rs_ctr.port.Port;
import cd4017be.api.rs_ctr.wire.RelayPort;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public interface IWiredConnector
extends IConnector {
    public Port getLinkPort(MountedPort var1);

    public boolean isLinked(MountedPort var1);

    public boolean isCompatible(Class<?> var1);

    default public void onWireRemoved(MountedPort host, MountedPort link, EntityPlayer player) {
        if (this.isLinked(link)) {
            host.setConnector(null, player);
        }
    }

    @Override
    default public void onRemoved(MountedPort port, EntityPlayer player) {
        IConnector c;
        Port p = this.getLinkPort(port);
        if (p instanceof MountedPort && (c = ((MountedPort)p).getConnector()) instanceof IWiredConnector) {
            ((IWiredConnector)c).onWireRemoved((MountedPort)p, port, player);
        }
    }

    default public void onLinkMove(MountedPort host, MountedPort link) {
    }

    @Override
    default public void onPortMove(MountedPort port) {
        Port p = this.getLinkPort(port);
        if (!(p instanceof MountedPort)) {
            return;
        }
        MountedPort lp = (MountedPort)p;
        this.onLinkMove(port, lp);
        IConnector c = lp.getConnector();
        if (c instanceof IWiredConnector) {
            ((IWiredConnector)c).onLinkMove(lp, port);
        }
    }

    public static Vec3d getPath(MountedPort from, MountedPort to) {
        Vec3d path = new Vec3d((Vec3i)to.getPos().func_177973_b((Vec3i)from.getPos())).func_178787_e(to.pos.func_178788_d(from.pos));
        if (!(from instanceof RelayPort)) {
            path = path.func_178788_d(new Vec3d(from.face.func_176730_m()).func_186678_a(0.125));
        }
        if (!(to instanceof RelayPort)) {
            path = path.func_178787_e(new Vec3d(to.face.func_176730_m()).func_186678_a(0.125));
        }
        return path;
    }

    public static interface IWiredConnectorItem
    extends IConnector.IConnectorItem {
        default public void doAttach(ItemStack stack, RelayPort port, EntityPlayer player) {
            this.doAttach(stack, (MountedPort)port, player);
        }
    }
}

