/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.recipes;

import cd4017be.api.recipes.ItemOperand;
import cd4017be.lib.script.obj.Error;
import cd4017be.lib.script.obj.IOperand;
import cd4017be.lib.script.obj.NBTWrapper;
import cd4017be.lib.script.obj.Nil;
import cd4017be.lib.script.obj.Number;
import net.minecraftforge.fluids.FluidStack;

public class FluidOperand
implements IOperand {
    boolean copied;
    final FluidStack stack;

    public FluidOperand(FluidStack stack) {
        this.stack = stack;
    }

    @Override
    public IOperand onCopy() {
        this.copied = true;
        return this;
    }

    @Override
    public boolean asBool() throws Error {
        return this.stack.amount > 0;
    }

    @Override
    public Object value() {
        return this.stack;
    }

    @Override
    public IOperand addR(IOperand x) {
        FluidStack stack = this.stack;
        if (this.copied) {
            stack = stack.copy();
        }
        if (x instanceof NBTWrapper) {
            stack.tag = ((NBTWrapper)x).nbt;
        } else if (x == Nil.NIL) {
            stack.tag = null;
        } else {
            return IOperand.super.addR(x);
        }
        return this.copied ? new FluidOperand(stack) : this;
    }

    @Override
    public IOperand mulR(IOperand x) {
        if (this.copied) {
            return new FluidOperand(new FluidStack(this.stack, x.asIndex()));
        }
        this.stack.amount = x.asIndex();
        return this;
    }

    @Override
    public IOperand mulL(IOperand x) {
        return this.mulR(x);
    }

    @Override
    public IOperand len() {
        return new Number(this.stack.amount);
    }

    @Override
    public boolean equals(IOperand obj) {
        if (obj instanceof FluidOperand) {
            return this.stack.isFluidEqual(((FluidOperand)obj).stack);
        }
        return false;
    }

    @Override
    public IOperand grR(IOperand x) {
        if (x instanceof ItemOperand) {
            return this.stack.isFluidEqual(((ItemOperand)x).stack) ? Number.TRUE : Number.FALSE;
        }
        return x.grL(this);
    }

    @Override
    public IOperand nlsR(IOperand x) {
        if (x instanceof FluidOperand) {
            return this.stack.isFluidEqual(((FluidOperand)x).stack) ? Number.TRUE : Number.FALSE;
        }
        if (x instanceof ItemOperand) {
            return this.stack.isFluidEqual(((ItemOperand)x).stack) ? Number.TRUE : Number.FALSE;
        }
        return x.nlsL(this);
    }

    public String toString() {
        return this.stack.amount + "*" + this.stack.getFluid().getName();
    }
}

