/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.multipart.IModelRenderPart;
import codechicken.multipart.IconHitEffects;
import codechicken.multipart.minecraft.McBlockPart;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class McMetaPart
extends McBlockPart
implements IModelRenderPart {
    public IBlockState state;

    public McMetaPart() {
    }

    public McMetaPart(IBlockState state) {
        this.state = state;
    }

    @Override
    public void save(NBTTagCompound tag) {
        tag.func_74774_a("meta", this.getMeta());
    }

    @Override
    public void load(NBTTagCompound tag) {
        this.setMeta(tag.func_74771_c("meta"));
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        packet.writeByte((int)this.getMeta());
    }

    @Override
    public void readDesc(MCDataInput packet) {
        this.setMeta(packet.readByte());
    }

    public byte getMeta() {
        return (byte)this.getBlock().func_176201_c(this.state);
    }

    public void setMeta(byte meta) {
        this.state = this.getBlock().func_176203_a((int)meta);
    }

    @Override
    public ResourceLocation getModelPath() {
        return null;
    }

    @Override
    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return this.getBlock().canRenderInLayer(this.state, layer);
    }

    @Override
    public BlockStateContainer createBlockStateContainer() {
        return this.getBlock().func_176194_O();
    }

    @Override
    public IBlockState getCurrentState(IBlockState state) {
        return this.state;
    }

    @Override
    public IBlockState getExtendedState(IBlockState state) {
        return state;
    }

    public void setStateOnPlacement(World world, BlockPos pos, EnumFacing facing, Vec3d hitVec, EntityLivingBase placer, ItemStack held) {
        this.state = this.getBlock().func_180642_a(world, pos, facing, (float)hitVec.field_72450_a, (float)hitVec.field_72448_b, (float)hitVec.field_72449_c, 0, placer);
    }

    @Override
    public float getStrength(EntityPlayer player, CuboidRayTraceResult hit) {
        return ForgeHooks.blockStrength((IBlockState)this.state, (EntityPlayer)player, (World)this.world(), (BlockPos)new BlockPos(0, -1, 0));
    }

    @Override
    public int getLightValue() {
        return this.state.func_185906_d();
    }

    @Override
    public Cuboid6 getBounds() {
        if (this.tile() != null) {
            return new Cuboid6(this.getBlock().func_185496_a(this.state, (IBlockAccess)this.world(), this.pos()));
        }
        return new Cuboid6(this.getBlock().func_185496_a(this.state, null, null));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getBreakingIcon(CuboidRayTraceResult hit) {
        return this.getBrokenIcon(hit.field_178784_b.ordinal());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getBrokenIcon(int side) {
        return TextureUtils.getParticleIconForBlock((IBlockState)this.state);
    }

    @Override
    public void addHitEffects(CuboidRayTraceResult hit, ParticleManager manager) {
        IconHitEffects.addHitEffects(this, hit, manager);
    }

    @Override
    public void addDestroyEffects(CuboidRayTraceResult hit, ParticleManager manager) {
        IconHitEffects.addDestroyEffects(this, manager, false);
    }
}

