/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevator.init;

import java.util.EnumMap;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xyz.vsngamer.elevator.blocks.BlockElevator;
import xyz.vsngamer.elevator.render.ModelCamoElevator;
import xyz.vsngamer.elevator.tile.TileElevator;

@Mod.EventBusSubscriber(modid="elevatorid")
public class Registry {
    public static EnumMap<EnumDyeColor, BlockElevator> ELEVATOR_BLOCKS = new EnumMap(EnumDyeColor.class);
    public static EnumMap<EnumDyeColor, ItemBlock> ELEVATOR_ITEMBLOCKS = new EnumMap(EnumDyeColor.class);

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> e) {
        ELEVATOR_BLOCKS.values().forEach(block -> e.getRegistry().register((IForgeRegistryEntry)block));
        GameRegistry.registerTileEntity(TileElevator.class, (ResourceLocation)new ResourceLocation("elevatorid", "tile_elevator"));
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> e) {
        ELEVATOR_ITEMBLOCKS.values().forEach(item -> {
            e.getRegistry().register((IForgeRegistryEntry)item);
            OreDictionary.registerOre((String)"blockElevator", (Item)item);
        });
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent event) {
        for (ItemBlock itemBlock : ELEVATOR_ITEMBLOCKS.values()) {
            ResourceLocation regName = itemBlock.getRegistryName();
            if (regName == null) continue;
            ModelResourceLocation tag = new ModelResourceLocation(regName.toString(), "normal");
            IBakedModel model = (IBakedModel)event.getModelRegistry().func_82594_a((Object)tag);
            event.getModelRegistry().func_82595_a((Object)tag, (Object)new ModelCamoElevator(model));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent e) {
        for (ItemBlock itemBlock : ELEVATOR_ITEMBLOCKS.values()) {
            ResourceLocation regName = itemBlock.getRegistryName();
            if (regName == null) continue;
            ModelLoader.setCustomModelResourceLocation((Item)itemBlock, (int)0, (ModelResourceLocation)new ModelResourceLocation(regName, "inventory"));
        }
    }

    static {
        for (EnumDyeColor color : EnumDyeColor.values()) {
            BlockElevator block = new BlockElevator(color);
            ELEVATOR_BLOCKS.put(color, block);
            ELEVATOR_ITEMBLOCKS.put(color, new BlockElevator.ItemBlockElevator(block));
        }
    }
}

