/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevator.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import xyz.vsngamer.elevator.ElevatorModTab;
import xyz.vsngamer.elevator.init.ModConfig;
import xyz.vsngamer.elevator.tile.Properties;
import xyz.vsngamer.elevator.tile.TileElevator;

public class BlockElevator
extends Block {
    public BlockElevator(EnumDyeColor color) {
        super(Material.field_151580_n);
        this.func_149711_c(0.8f);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_149647_a(ElevatorModTab.TAB);
        this.setRegistryName(new ResourceLocation("elevatorid", "elevator_" + color.func_176610_l()));
        this.func_149663_c("elevator_" + color.func_176610_l());
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return ModConfig.mobSpawn && super.canCreatureSpawn(state, world, pos, type);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileElevator();
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        ItemStack handStack = playerIn.func_184614_ca();
        if (!this.isValidItem(handStack)) {
            return false;
        }
        Block handBlock = Block.func_149634_a((Item)handStack.func_77973_b());
        IBlockState handState = handBlock.getStateForPlacement(worldIn, pos, facing, hitX, hitY, hitZ, handStack.func_77960_j(), (EntityLivingBase)playerIn, null);
        IBlockState stateToApply = handState.func_185899_b((IBlockAccess)worldIn, pos);
        TileElevator tile = this.getTileElevator((IBlockAccess)worldIn, pos);
        if (tile == null || tile.func_145837_r()) {
            return false;
        }
        if (!handStack.func_190926_b() && stateToApply != tile.getCamoState()) {
            this.setCamoAndUpdate(stateToApply, tile, worldIn, pos);
            return true;
        }
        if (handStack.func_190926_b() && tile.getCamoState() != null) {
            this.setCamoAndUpdate(null, tile, worldIn, pos);
            return true;
        }
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IUnlistedProperty[]{Properties.HELD_STATE}).build();
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extState = (IExtendedBlockState)state;
        TileElevator tile = this.getTileElevator(world, pos);
        if (tile != null) {
            return extState.withProperty(Properties.HELD_STATE, (Object)tile.getCamoState());
        }
        return extState;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileElevator tile = this.getTileElevator(blockAccess, pos);
        if (tile != null && tile.getCamoState() != null && tile.getCamoState().func_177230_c().func_180664_k() != BlockRenderLayer.SOLID) {
            TileElevator adjacentTile = this.getTileElevator(blockAccess, pos.func_177972_a(side));
            if (adjacentTile != null) {
                return adjacentTile.getCamoState() != tile.getCamoState();
            }
            IBlockState adjacentState = blockAccess.func_180495_p(pos.func_177972_a(side));
            return tile.getCamoState() != adjacentState;
        }
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public float getSlipperiness(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable Entity entity) {
        TileElevator tile = this.getTileElevator(world, pos);
        if (tile != null && tile.getCamoState() != null) {
            return tile.getCamoState().func_177230_c().getSlipperiness(state, world, pos, entity);
        }
        return super.getSlipperiness(state, world, pos, entity);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        TileElevator tile = this.getTileElevator((IBlockAccess)worldIn, pos);
        if (tile != null && tile.getCamoState() != null) {
            try {
                tile.getCamoState().func_177230_c().func_180634_a(worldIn, pos, state, entityIn);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        super.func_180634_a(worldIn, pos, state, entityIn);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        TileElevator tile = this.getTileElevator(worldIn, pos);
        if (tile != null && tile.getCamoState() != null) {
            return tile.getCamoState().func_185890_d(worldIn, pos);
        }
        return super.func_180646_a(blockState, worldIn, pos);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TileElevator tile = this.getTileElevator(source, pos);
        if (tile != null && tile.getCamoState() != null) {
            return tile.getCamoState().func_185900_c(source, pos);
        }
        return super.func_185496_a(state, source, pos);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        TileElevator tile = this.getTileElevator((IBlockAccess)worldIn, pos);
        if (tile != null && tile.getCamoState() != null) {
            try {
                tile.getCamoState().func_185908_a(worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return;
        }
        super.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState actualState;
        IBlockState camoState;
        TileElevator tile = this.getTileElevator(worldIn, pos);
        if (tile != null && tile.getCamoState() != null && (camoState = tile.getCamoState()) != (actualState = camoState.func_185899_b(worldIn, pos))) {
            tile.setCamoState(actualState);
        }
        return super.func_176221_a(state, worldIn, pos);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileElevator tile = this.getTileElevator(world, pos);
        if (tile != null && tile.getCamoState() != null) {
            return tile.getCamoState().getLightValue(world, pos);
        }
        return 0;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileElevator tile = this.getTileElevator(world, pos);
        if (tile != null && tile.getCamoState() != null) {
            return tile.getCamoState().getLightOpacity(world, pos);
        }
        return 255;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        TileElevator tile = this.getTileElevator(world, pos);
        if (tile != null && tile.getCamoState() != null) {
            return tile.getCamoState().func_177230_c().canConnectRedstone(tile.getCamoState(), world, pos, side);
        }
        return false;
    }

    public boolean shouldCheckWeakPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState heldState;
        TileElevator tile = this.getTileElevator(world, pos);
        if (tile != null && (heldState = tile.getCamoState()) != null) {
            return tile.getCamoState().func_177230_c().shouldCheckWeakPower(heldState, world, pos, side);
        }
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileElevator tile = this.getTileElevator(blockAccess, pos);
        if (tile != null && tile.getCamoState() != null) {
            return tile.getCamoState().func_185911_a(blockAccess, pos, side);
        }
        return 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileElevator tile = this.getTileElevator(blockAccess, pos);
        if (tile != null && tile.getCamoState() != null) {
            return tile.getCamoState().func_185893_b(blockAccess, pos, side);
        }
        return 0;
    }

    @Nullable
    public TileElevator getTileElevator(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileElevator && !tile.func_145837_r()) {
            return (TileElevator)tile;
        }
        return null;
    }

    private boolean isValidItem(ItemStack stack) {
        Item item = stack.func_77973_b();
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (stack.func_190926_b()) {
            return true;
        }
        if (!(item instanceof ItemBlock)) {
            return false;
        }
        if (block instanceof BlockElevator) {
            return false;
        }
        if (block.func_176223_P().func_185901_i() != EnumBlockRenderType.MODEL) {
            return false;
        }
        return block.func_176223_P().func_185904_a().func_76220_a();
    }

    private void setCamoAndUpdate(IBlockState camoState, TileElevator tile, World world, BlockPos pos) {
        SoundEvent sound = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("entity.endermen.teleport"));
        tile.setCamoState(camoState);
        if (sound != null) {
            world.func_184133_a(null, pos, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public class ItemBlockElevator
    extends ItemBlock {
        public ItemBlockElevator() {
            super((Block)BlockElevator.this);
            ResourceLocation regName = BlockElevator.this.getRegistryName();
            if (regName != null) {
                this.setRegistryName(regName);
            }
        }
    }
}

