/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.json.deserializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class BlockStateDeserializer
implements JsonDeserializer<IBlockState> {
    public IBlockState deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject;
        String blockName;
        Block block;
        if (json != null && json.isJsonObject() && (block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName = JsonUtils.func_151200_h((JsonObject)(jsonObject = json.getAsJsonObject()), (String)"block")))) != null) {
            if (jsonObject.has("properties")) {
                BlockStateContainer blockStateContainer = block.func_176194_O();
                IBlockState blockState = block.func_176223_P();
                JsonObject properties = jsonObject.getAsJsonObject("properties");
                for (Map.Entry entry : properties.entrySet()) {
                    IProperty property = blockStateContainer.func_185920_a((String)entry.getKey());
                    if (property != null) {
                        blockState = BlockStateDeserializer.setValueHelper(blockState, property, ((JsonElement)entry.getValue()).getAsString());
                        continue;
                    }
                    throw new JsonParseException("Failed to find property: " + (String)entry.getKey());
                }
                return blockState;
            }
            return block.func_176223_P();
        }
        if (json == null) {
            throw new JsonParseException("Found null value for BlockState Input");
        }
        throw new JsonParseException("Failed to deserialize BlockState for: " + json.toString());
    }

    private static <T extends Comparable<T>> IBlockState setValueHelper(IBlockState blockState, IProperty<T> property, String stringValue) throws JsonParseException {
        return property.func_185929_b(stringValue).toJavaUtil().map(propertyValue -> blockState.func_177226_a(property, propertyValue)).orElseThrow(() -> new JsonParseException("Failed to find value " + stringValue + " for property " + property.func_177701_a()));
    }
}

