/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.client.render;

import buildcraft.factory.BCFactoryBlocks;
import buildcraft.factory.tile.TileHeatExchange;
import buildcraft.lib.block.BlockBCBase_Neptune;
import buildcraft.lib.client.render.fluid.FluidRenderer;
import buildcraft.lib.client.render.fluid.FluidSpriteType;
import buildcraft.lib.fluid.FluidSmoother;
import buildcraft.lib.misc.RenderUtil;
import buildcraft.lib.misc.VecUtil;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.profiler.Profiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fluids.FluidStack;

public class RenderHeatExchange
extends TileEntitySpecialRenderer<TileHeatExchange> {
    private static final Map<EnumFacing, TankSideData> TANK_SIDES = new EnumMap<EnumFacing, TankSideData>(EnumFacing.class);
    private static final FluidRenderer.TankSize TANK_BOTTOM;
    private static final FluidRenderer.TankSize TANK_TOP;

    public void render(TileHeatExchange tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        super.func_192841_a((TileEntity)tile, x, y, z, partialTicks, destroyStage, alpha);
        if (!tile.isStart()) {
            return;
        }
        TileHeatExchange.ExchangeSectionStart section = (TileHeatExchange.ExchangeSectionStart)tile.getSection();
        TileHeatExchange.ExchangeSectionEnd sectionEnd = section.getEndSection();
        IBlockState state = tile.getCurrentStateForBlock((Block)BCFactoryBlocks.heatExchange);
        if (state == null) {
            return;
        }
        Profiler profiler = Minecraft.func_71410_x().field_71424_I;
        profiler.func_76320_a("bc");
        profiler.func_76320_a("heat_exchange");
        int combinedLight = tile.func_145831_w().func_175626_b(tile.func_174877_v(), 0);
        RenderHelper.func_74518_a();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        try (RenderUtil.AutoTessellator tess = RenderUtil.getThreadLocalUnusedTessellator();){
            BufferBuilder bb = tess.tessellator.func_178180_c();
            bb.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            bb.func_178969_c(x, y, z);
            profiler.func_76320_a("tank");
            EnumFacing face = ((EnumFacing)state.func_177229_b(BlockBCBase_Neptune.PROP_FACING)).func_176735_f();
            TankSideData sideTank = TANK_SIDES.get(face);
            RenderHeatExchange.renderTank(TANK_BOTTOM, section.smoothedTankInput, combinedLight, partialTicks, bb);
            RenderHeatExchange.renderTank(sideTank.start, section.smoothedTankOutput, combinedLight, partialTicks, bb);
            int middles = section.middleCount;
            if (sectionEnd != null) {
                BlockPos diff = sectionEnd.getTile().func_174877_v().func_177973_b((Vec3i)tile.func_174877_v());
                bb.func_178969_c(x + (double)diff.func_177958_n(), y + (double)diff.func_177956_o(), z + (double)diff.func_177952_p());
                RenderHeatExchange.renderTank(TANK_TOP, sectionEnd.smoothedTankOutput, combinedLight, partialTicks, bb);
                RenderHeatExchange.renderTank(sideTank.end, sectionEnd.smoothedTankInput, combinedLight, partialTicks, bb);
                bb.func_178969_c(x, y, z);
            }
            profiler.func_76318_c("flow");
            if (middles > 0 && sectionEnd != null) {
                TileHeatExchange.EnumProgressState progressState = section.getProgressState();
                double progress = section.getProgress(partialTicks);
                if (progress > 0.0) {
                    double length = (double)(middles + 2) - 0.25 - 0.02;
                    double p0 = 0.135;
                    double p1 = p0 + length - 0.01;
                    double progressStart = p0;
                    double progressEnd = p0 + length * progress;
                    boolean flip = progressState == TileHeatExchange.EnumProgressState.PREPARING;
                    if (flip ^= face.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE) {
                        progressStart = p1 - length * progress;
                        progressEnd = p1;
                    }
                    BlockPos diff = BlockPos.field_177992_a;
                    if (face.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE) {
                        diff = diff.func_177967_a(face, middles + 1);
                    }
                    double otherStart = flip ? p0 : p1 - length * progress;
                    double otherEnd = flip ? p0 + length * progress : p1;
                    Vec3d vDiff = new Vec3d((Vec3i)diff).func_72441_c(x, y, z);
                    RenderHeatExchange.renderFlow(vDiff, face, bb, progressStart + 0.01, progressEnd - 0.01, sectionEnd.smoothedTankInput.getFluidForRender(), 4, partialTicks);
                    RenderHeatExchange.renderFlow(vDiff, face.func_176734_d(), bb, otherStart, otherEnd, section.smoothedTankInput.getFluidForRender(), 2, partialTicks);
                }
            }
            bb.func_178969_c(0.0, 0.0, 0.0);
            profiler.func_76318_c("draw");
            tess.tessellator.func_78381_a();
        }
        RenderHelper.func_74519_b();
        profiler.func_76319_b();
        profiler.func_76319_b();
        profiler.func_76319_b();
    }

    private static void renderTank(FluidRenderer.TankSize size, FluidSmoother tank, int combinedLight, float partialTicks, BufferBuilder bb) {
        FluidSmoother.FluidStackInterp fluid = tank.getFluidForRender((double)partialTicks);
        if (fluid == null || fluid.amount <= 0.0) {
            return;
        }
        int blockLight = fluid.fluid.getFluid().getLuminosity(fluid.fluid) & 0xF;
        FluidRenderer.vertex.lighti(combinedLight |= blockLight << 4);
        FluidRenderer.renderFluid((FluidSpriteType)FluidSpriteType.STILL, (FluidStack)fluid.fluid, (double)fluid.amount, (double)tank.getCapacity(), (Vec3d)size.min, (Vec3d)size.max, (BufferBuilder)bb, null);
    }

    private static void renderFlow(Vec3d diff, EnumFacing face, BufferBuilder bb, double s, double e, FluidStack fluid, int point, float partialTicks) {
        double tickTime = Minecraft.func_71410_x().field_71441_e.func_82737_E();
        double offset = (tickTime + (double)partialTicks) % 31.0 / 31.0;
        if (face.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE) {
            offset = -offset;
            face = face.func_176734_d();
        }
        Vec3d dirVec = new Vec3d(face.func_176730_m());
        double ds = ((double)point + 0.1) / 16.0;
        Vec3d vs = new Vec3d(ds, ds, ds);
        Vec3d ve = new Vec3d(1.0 - ds, 1.0 - ds, 1.0 - ds);
        diff = diff.func_178788_d(VecUtil.scale((Vec3d)dirVec, (double)offset));
        s += offset;
        e += offset;
        if (s < 0.0) {
            s += 1.0;
            e += 1.0;
            diff = diff.func_178788_d(dirVec);
        }
        int i = 0;
        while ((double)i <= e) {
            Vec3d d = diff;
            diff = diff.func_178787_e(dirVec);
            if (!((double)i < s - 1.0)) {
                bb.func_178969_c(d.field_72450_a, d.field_72448_b, d.field_72449_c);
                double s1 = s < (double)i ? 0.0 : s % 1.0;
                double e1 = e > (double)(i + 1) ? 1.0 : e % 1.0;
                vs = VecUtil.replaceValue((Vec3d)vs, (EnumFacing.Axis)face.func_176740_k(), (double)s1);
                ve = VecUtil.replaceValue((Vec3d)ve, (EnumFacing.Axis)face.func_176740_k(), (double)e1);
                boolean[] sides = new boolean[6];
                Arrays.fill(sides, true);
                if (s < (double)i) {
                    sides[face.func_176734_d().ordinal()] = false;
                }
                if (e > (double)(i + 1)) {
                    sides[face.ordinal()] = false;
                }
                FluidRenderer.renderFluid((FluidSpriteType)FluidSpriteType.FROZEN, (FluidStack)fluid, (double)1.0, (double)1.0, (Vec3d)vs, (Vec3d)ve, (BufferBuilder)bb, (boolean[])sides);
            }
            ++i;
        }
    }

    public boolean isGlobalRenderer(TileHeatExchange tile) {
        return tile.isStart();
    }

    static {
        double s = 0.015625;
        TANK_BOTTOM = new FluidRenderer.TankSize(2, 0, 2, 14, 2, 14).shrink(s, 0.0, s);
        TANK_TOP = new FluidRenderer.TankSize(2, 14, 2, 14, 16, 14).shrink(s, 0.0, s);
        FluidRenderer.TankSize start = new FluidRenderer.TankSize(0, 4, 4, 2, 12, 12).shrink(0.0, s, s);
        FluidRenderer.TankSize end = new FluidRenderer.TankSize(14, 4, 4, 16, 12, 12).shrink(0.0, s, s);
        TankSideData sides = new TankSideData(start, end);
        EnumFacing face = EnumFacing.EAST;
        for (int i = 0; i < 4; ++i) {
            TANK_SIDES.put(face, sides);
            face = face.func_176746_e();
            sides = sides.rotateY();
        }
    }

    static class TankSideData {
        public final FluidRenderer.TankSize start;
        public final FluidRenderer.TankSize end;

        public TankSideData(FluidRenderer.TankSize start, FluidRenderer.TankSize end) {
            this.start = start;
            this.end = end;
        }

        public TankSideData rotateY() {
            return new TankSideData(this.start.rotateY(), this.end.rotateY());
        }
    }
}

