/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.world.underground;

import java.util.Map;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.BiomeDictionary;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.world.world.underground.BasicUndergroundBiome;

public class UndergroundBiomeSandstone
extends BasicUndergroundBiome {
    public static final ResourceLocation HUSK_GRAVE_STRUCTURE = new ResourceLocation("quark", "husk_grave");
    public static int stalactiteChance;
    public static int chiseledSandstoneChance;
    public static int deadBushChance;
    public static boolean enableSand;
    public static boolean allowGenInMesa;

    public UndergroundBiomeSandstone() {
        super(Blocks.field_150322_A.func_176223_P(), Blocks.field_150322_A.func_176223_P(), Blocks.field_150322_A.func_176223_P());
    }

    @Override
    public boolean isValidBiome(Biome biome) {
        return allowGenInMesa || !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MESA);
    }

    @Override
    public void fillCeiling(World world, BlockPos pos, IBlockState state) {
        if (stalactiteChance > 0 && world.field_73012_v.nextInt(stalactiteChance) == 0) {
            world.func_180501_a(pos.func_177977_b(), this.ceilingState, 2);
        }
        super.fillCeiling(world, pos, state);
    }

    @Override
    public void fillFloor(World world, BlockPos pos, IBlockState state) {
        if (enableSand && world.field_73012_v.nextBoolean()) {
            world.func_180501_a(pos, Blocks.field_150354_m.func_176223_P(), 2);
            if (deadBushChance > 0 && world.field_73012_v.nextInt(deadBushChance) == 0) {
                world.func_180501_a(pos.func_177984_a(), Blocks.field_150330_I.func_176223_P(), 2);
            }
        } else {
            super.fillFloor(world, pos, state);
        }
    }

    @Override
    public void fillWall(World world, BlockPos pos, IBlockState state) {
        if (chiseledSandstoneChance > 0 && world.field_73012_v.nextInt(chiseledSandstoneChance) == 0) {
            world.func_180501_a(pos, this.wallState.func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.CHISELED), 2);
        } else {
            super.fillWall(world, pos, state);
        }
    }

    @Override
    public boolean hasDungeon() {
        return true;
    }

    @Override
    public void spawnDungeon(WorldServer world, BlockPos pos, EnumFacing side) {
        if (side == null) {
            side = EnumFacing.NORTH;
        }
        switch (side) {
            case NORTH: {
                pos = pos.func_177982_a(3, -7, 6);
                break;
            }
            case SOUTH: {
                pos = pos.func_177982_a(-3, -7, -6);
                break;
            }
            case EAST: {
                pos = pos.func_177982_a(-6, -7, 3);
                break;
            }
            case WEST: {
                pos = pos.func_177982_a(6, -7, -3);
                break;
            }
        }
        MinecraftServer server = world.func_73046_m();
        Template template = world.func_184163_y().func_186237_a(server, HUSK_GRAVE_STRUCTURE);
        PlacementSettings settings = new PlacementSettings();
        settings.func_186220_a(UndergroundBiomeSandstone.rotationFromFacing(side.func_176734_d()));
        template.func_186253_b((World)world, pos, settings);
        Map dataBlocks = template.func_186258_a(pos, settings);
        for (Map.Entry entry : dataBlocks.entrySet()) {
            BlockPos dataPos = (BlockPos)entry.getKey();
            switch ((String)entry.getValue()) {
                case "spawner": {
                    world.func_180501_a(dataPos, Blocks.field_150474_ac.func_176223_P(), 2);
                    TileEntity spawner = world.func_175625_s(dataPos);
                    if (!(spawner instanceof TileEntityMobSpawner)) break;
                    ((TileEntityMobSpawner)spawner).func_145881_a().func_190894_a(EntityList.func_191306_a(EntityZombie.class));
                    break;
                }
                case "chest": {
                    IBlockState chestState = Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.WEST);
                    world.func_175656_a(dataPos, chestState);
                    TileEntity chest = world.func_175625_s(dataPos);
                    if (!(chest instanceof TileEntityLockableLoot)) break;
                    ((TileEntityLockableLoot)chest).func_189404_a(LootTableList.field_186429_k, world.field_73012_v.nextLong());
                }
            }
        }
    }

    @Override
    public void setupConfig(String category) {
        stalactiteChance = ModuleLoader.config.getInt("Stalactite Chance", category, 10, 0, Integer.MAX_VALUE, "The higher, the less stalactites will spawn");
        chiseledSandstoneChance = ModuleLoader.config.getInt("Chiseled Sandstone Chance", category, 10, 0, Integer.MAX_VALUE, "The higher, the less chiseled sandstone will spawn");
        deadBushChance = ModuleLoader.config.getInt("Dead Bush Chance", category, 20, 0, Integer.MAX_VALUE, "The higher, the less dead bushes will spawn");
        enableSand = ModuleLoader.config.getBoolean("Enable Sand Floors", category, true, "");
        allowGenInMesa = ModuleLoader.config.getBoolean("Allow in Mesa biomes", category, false, "");
    }
}

