/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.entity;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import vazkii.quark.misc.feature.Pickarang;

public class EntityPickarang
extends EntityThrowable {
    private static final DataParameter<ItemStack> STACK = EntityDataManager.func_187226_a(EntityPickarang.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Boolean> RETURNING = EntityDataManager.func_187226_a(EntityPickarang.class, (DataSerializer)DataSerializers.field_187198_h);
    private int liveTime;
    private int slot;
    private static final String TAG_RETURNING = "returning";
    private static final String TAG_LIVE_TIME = "liveTime";
    private static final String TAG_RETURN_SLOT = "returnSlot";
    private static final String TAG_ITEM_STACK = "itemStack";

    public EntityPickarang(World worldIn) {
        super(worldIn);
    }

    public EntityPickarang(World worldIn, EntityLivingBase throwerIn) {
        super(worldIn, throwerIn);
    }

    public void setThrowData(int slot, ItemStack stack) {
        this.slot = slot;
        this.setStack(stack.func_77946_l());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STACK, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(RETURNING, (Object)false);
    }

    protected void func_70184_a(@Nonnull RayTraceResult result) {
        Entity hit;
        if (((Boolean)this.field_70180_af.func_187225_a(RETURNING)).booleanValue()) {
            return;
        }
        EntityLivingBase owner = this.func_85052_h();
        if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
            int harvestLevel;
            this.field_70180_af.func_187227_b(RETURNING, (Object)true);
            if (!(owner instanceof EntityPlayer)) {
                return;
            }
            EntityPlayer player = (EntityPlayer)owner;
            BlockPos hit2 = result.func_178782_a();
            IBlockState state = this.field_70170_p.func_180495_p(hit2);
            Block block = state.func_177230_c();
            float hardness = state.func_185887_b(this.field_70170_p, hit2);
            int neededHarvestLevel = block.getHarvestLevel(state);
            if (neededHarvestLevel <= (harvestLevel = 3) && hardness != -1.0f && hardness < 50.0f) {
                this.field_70170_p.func_175698_g(hit2);
                this.field_70170_p.func_175718_b(2001, hit2, Block.func_176210_f((IBlockState)state));
                block.func_180657_a(this.field_70170_p, player, hit2, state, this.field_70170_p.func_175625_s(hit2), this.getStack());
            }
        } else if (result.field_72313_a == RayTraceResult.Type.ENTITY && (hit = result.field_72308_g) != owner) {
            this.field_70180_af.func_187227_b(RETURNING, (Object)true);
            if (owner instanceof EntityPlayer) {
                hit.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)owner)), 3.0f);
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70128_L) {
            return;
        }
        boolean returning = (Boolean)this.field_70180_af.func_187225_a(RETURNING);
        ++this.liveTime;
        if (!returning) {
            if (this.liveTime > Pickarang.timeout) {
                this.field_70180_af.func_187227_b(RETURNING, (Object)true);
            }
        } else {
            this.field_70145_X = true;
            ItemStack stack = this.getStack();
            List items = this.field_70170_p.func_72872_a(EntityItem.class, this.func_174813_aQ().func_186662_g(2.0));
            Vec3d ourPos = this.func_174791_d();
            for (EntityItem item : items) {
                Vec3d itemPos = item.func_174791_d();
                Vec3d motion = ourPos.func_178788_d(itemPos);
                if (motion.func_72433_c() > 1.0) {
                    motion = motion.func_72432_b();
                }
                item.field_70159_w = motion.field_72450_a;
                item.field_70181_x = motion.field_72448_b;
                item.field_70179_y = motion.field_72449_c;
                item.func_174867_a(2);
            }
            EntityLivingBase owner = this.func_85052_h();
            if (owner == null || owner.field_70128_L || !(owner instanceof EntityPlayer)) {
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70099_a(stack, 0.0f);
                    this.func_70106_y();
                }
                return;
            }
            Vec3d ownerPos = owner.func_174791_d().func_72441_c(0.0, 1.0, 0.0);
            Vec3d motion = ownerPos.func_178788_d(ourPos);
            if (motion.func_189985_c() < 3.0) {
                EntityPlayer player = (EntityPlayer)owner;
                ItemStack stackInSlot = player.field_71071_by.func_70301_a(this.slot);
                if (stack.func_77984_f()) {
                    stack.func_77972_a(1, (EntityLivingBase)player);
                }
                if (!this.field_70170_p.field_72995_K) {
                    if (!stack.func_190926_b()) {
                        if (stackInSlot.func_190926_b()) {
                            player.field_71071_by.func_70299_a(this.slot, stack);
                        } else if (!player.field_71071_by.func_70441_a(stack)) {
                            this.func_70099_a(stack, 0.0f);
                        }
                    }
                    this.func_70106_y();
                }
            } else {
                motion = motion.func_72432_b().func_186678_a(0.7);
                this.field_70159_w = motion.field_72450_a;
                this.field_70181_x = motion.field_72448_b;
                this.field_70179_y = motion.field_72449_c;
            }
        }
    }

    public ItemStack getStack() {
        return (ItemStack)this.field_70180_af.func_187225_a(STACK);
    }

    public void setStack(ItemStack stack) {
        this.field_70180_af.func_187227_b(STACK, (Object)stack);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(RETURNING, (Object)compound.func_74767_n(TAG_RETURNING));
        this.liveTime = compound.func_74762_e(TAG_LIVE_TIME);
        this.slot = compound.func_74762_e(TAG_RETURN_SLOT);
        this.setStack(new ItemStack(compound.func_74775_l(TAG_ITEM_STACK)));
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a(TAG_RETURNING, ((Boolean)this.field_70180_af.func_187225_a(RETURNING)).booleanValue());
        compound.func_74768_a(TAG_LIVE_TIME, this.liveTime);
        compound.func_74768_a(TAG_RETURN_SLOT, this.slot);
        compound.func_74782_a(TAG_ITEM_STACK, (NBTBase)this.getStack().serializeNBT());
    }

    protected float func_70185_h() {
        return 0.0f;
    }
}

