/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.oddities.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import vazkii.arl.interf.IItemColorProvider;
import vazkii.arl.item.ItemModArmor;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.base.handler.ProxiedItemStackHandler;
import vazkii.quark.base.item.IQuarkItem;
import vazkii.quark.oddities.client.model.ModelBackpack;
import vazkii.quark.oddities.feature.Backpacks;

public class ItemBackpack
extends ItemModArmor
implements IQuarkItem,
IItemColorProvider {
    private static final String WORN_TEXTURE = "quark:textures/misc/backpack_worn.png";
    private static final String WORN_OVERLAY_TEXTURE = "quark:textures/misc/backpack_worn_overlay.png";
    @SideOnly(value=Side.CLIENT)
    public static ModelBiped model;

    public ItemBackpack() {
        super("backpack", ItemArmor.ArmorMaterial.LEATHER, 0, EntityEquipmentSlot.CHEST);
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.func_77656_e(0);
        this.func_185043_a(new ResourceLocation("has_items"), (stack, world, entity) -> !Backpacks.superOpMode && ItemBackpack.doesBackpackHaveItems(stack) ? 1.0f : 0.0f);
    }

    public static boolean doesBackpackHaveItems(ItemStack stack) {
        IItemHandler handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (handler == null) {
            return false;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public Multimap<String, AttributeModifier> func_111205_h(@Nonnull EntityEquipmentSlot equipmentSlot) {
        return HashMultimap.create();
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (worldIn.field_72995_K) {
            return;
        }
        boolean hasItems = !Backpacks.superOpMode && ItemBackpack.doesBackpackHaveItems(stack);
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)stack);
        boolean isCursed = enchants.containsKey(Enchantments.field_190941_k);
        boolean changedEnchants = false;
        if (hasItems) {
            if (Backpacks.isEntityWearingBackpack(entityIn, stack)) {
                if (!isCursed) {
                    enchants.put(Enchantments.field_190941_k, 1);
                    changedEnchants = true;
                }
            } else {
                ItemStack copy = stack.func_77946_l();
                stack.func_190920_e(0);
                entityIn.func_70099_a(copy, 0.0f);
            }
        } else if (isCursed) {
            enchants.remove(Enchantments.field_190941_k);
            changedEnchants = true;
        }
        if (changedEnchants) {
            EnchantmentHelper.func_82782_a((Map)enchants, (ItemStack)stack);
        }
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (Backpacks.superOpMode || entityItem.field_70170_p.field_72995_K) {
            return false;
        }
        ItemStack stack = entityItem.func_92059_d();
        if (!ItemNBTHelper.detectNBT((ItemStack)stack)) {
            return false;
        }
        IItemHandler handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (handler == null) {
            return false;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stackAt = handler.getStackInSlot(i);
            if (stackAt.func_190926_b()) continue;
            ItemStack copy = stackAt.func_77946_l();
            InventoryHelper.func_180173_a((World)entityItem.field_70170_p, (double)entityItem.field_70165_t, (double)entityItem.field_70163_u, (double)entityItem.field_70161_v, (ItemStack)copy);
        }
        NBTTagCompound comp = ItemNBTHelper.getNBT((ItemStack)stack);
        comp.func_82580_o("Inventory");
        if (comp.func_186856_d() == 0) {
            stack.func_77982_d(null);
        }
        return false;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return type != null && type.equals("overlay") ? WORN_OVERLAY_TEXTURE : WORN_TEXTURE;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        if (model == null) {
            model = new ModelBackpack();
        }
        return model;
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    @Nonnull
    public IRarity getForgeRarity(@Nonnull ItemStack stack) {
        return EnumRarity.COMMON;
    }

    public boolean func_77616_k(@Nonnull ItemStack stack) {
        return false;
    }

    @Nonnull
    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound oldCapNbt) {
        ProxiedItemStackHandler handler = new ProxiedItemStackHandler(stack, 27);
        if (oldCapNbt != null && oldCapNbt.func_74764_b("Parent")) {
            NBTTagCompound itemData = oldCapNbt.func_74775_l("Parent");
            ItemStackHandler stacks = new ItemStackHandler();
            stacks.deserializeNBT(itemData);
            for (int i = 0; i < stacks.getSlots(); ++i) {
                handler.setStackInSlot(i, stacks.getStackInSlot(i));
            }
            oldCapNbt.func_82580_o("Parent");
        }
        return handler;
    }

    public IItemColor getItemColor() {
        return (stack, i) -> i == 1 ? ((ItemArmor)stack.func_77973_b()).func_82814_b(stack) : -1;
    }
}

