/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.misc.feature;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.quark.base.module.Feature;
import vazkii.quark.misc.block.BlockBlackAsh;

public class BlackAsh
extends Feature {
    public static Block black_ash;
    public static int witherSkeletonMin;
    public static int witherSkeletonMax;
    public static int witherMin;
    public static int witherMax;
    public static boolean removeCoalDrops;

    @Override
    public void setupConfig() {
        witherSkeletonMin = this.loadPropInt("Wither Skeleton Min Drop", "", 0);
        witherSkeletonMax = this.loadPropInt("Wither Skeleton Max Drop", "", 3);
        witherMin = this.loadPropInt("Wither Min Drop", "", 12);
        witherMax = this.loadPropInt("Wither Max Drop", "", 20);
        removeCoalDrops = this.loadPropBool("Remove Wither Skeleton Coal Drops", "", true);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        black_ash = new BlockBlackAsh();
    }

    @SubscribeEvent
    public void onDrops(LivingDropsEvent event) {
        Entity e = event.getEntity();
        if (e instanceof EntityWitherSkeleton) {
            if (removeCoalDrops) {
                event.getDrops().removeIf(ei -> ei.func_92059_d().func_77973_b() == Items.field_151044_h);
            }
            this.addDrop(event.getDrops(), e, witherSkeletonMin, witherSkeletonMax);
        } else if (e instanceof EntityWither) {
            this.addDrop(event.getDrops(), e, witherMin, witherMax);
        }
    }

    @SubscribeEvent
    public void onSpawnCheck(LivingSpawnEvent.CheckSpawn event) {
        BlockPos pos;
        Entity e = event.getEntity();
        World world = event.getWorld();
        if (world.func_180495_p(pos = e.func_180425_c()).func_177230_c() == black_ash || world.func_180495_p(pos.func_177979_c(2)).func_177230_c() == black_ash) {
            event.setResult(Event.Result.DENY);
        }
    }

    private void addDrop(List<EntityItem> drops, Entity e, int min, int max) {
        int amount = e.field_70170_p.field_73012_v.nextInt(Math.abs(max - min) + 1) + Math.min(min, max);
        if (amount > 0) {
            drops.add(new EntityItem(e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v, new ItemStack(black_ash, amount)));
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }
}

