/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.experimental.world;

import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.ChunkGeneratorSettings;

public class BiomeLocator {
    public static BlockPos spiralOutwardsLookingForBiome(World world, Biome biomeToFind, double startX, double startZ) {
        int sampleSpacing = 4 << BiomeLocator.getBiomeSize(world);
        int maxDist = sampleSpacing * 100;
        return BiomeLocator.spiralOutwardsLookingForBiome(world, biomeToFind, startX, startZ, maxDist, sampleSpacing);
    }

    private static BlockPos spiralOutwardsLookingForBiome(World world, Biome biomeToFind, double startX, double startZ, int maxDist, int sampleSpace) {
        if (maxDist <= 0 || sampleSpace <= 0) {
            throw new IllegalArgumentException("maxDist and sampleSpace must be positive");
        }
        if (world.field_72995_K) {
            return null;
        }
        BiomeProvider chunkManager = world.func_72959_q();
        double a = (double)sampleSpace / Math.sqrt(Math.PI);
        double b = 2.0 * Math.sqrt(Math.PI);
        double dist = 0.0;
        int n = 0;
        while (dist < (double)maxDist) {
            double z;
            double rootN = Math.sqrt(n);
            dist = a * rootN;
            double x = startX + dist * Math.sin(b * rootN);
            Biome[] biomesAtSample = chunkManager.func_76931_a(null, (int)x, (int)(z = startZ + dist * Math.cos(b * rootN)), 1, 1, false);
            if (biomesAtSample[0] == biomeToFind) {
                return new BlockPos((int)x, 0, (int)z);
            }
            ++n;
        }
        return null;
    }

    private static int getBiomeSize(World world) {
        String generatorSettingsJson = world.func_72912_H().func_82571_y();
        return ChunkGeneratorSettings.Factory.func_177865_a((String)generatorSettingsJson).func_177864_b().field_177780_G;
    }
}

