/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.quark.api.module.ModuleLoadedEvent;
import vazkii.quark.automation.QuarkAutomation;
import vazkii.quark.base.Quark;
import vazkii.quark.base.handler.RecipeProcessor;
import vazkii.quark.base.module.ConfigHelper;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.module.GlobalConfig;
import vazkii.quark.base.module.Module;
import vazkii.quark.building.QuarkBuilding;
import vazkii.quark.client.QuarkClient;
import vazkii.quark.decoration.QuarkDecoration;
import vazkii.quark.experimental.QuarkExperimental;
import vazkii.quark.management.QuarkManagement;
import vazkii.quark.misc.QuarkMisc;
import vazkii.quark.oddities.QuarkOddities;
import vazkii.quark.tweaks.QuarkTweaks;
import vazkii.quark.vanity.QuarkVanity;
import vazkii.quark.world.QuarkWorld;

public final class ModuleLoader {
    public static final boolean DEBUG_MODE = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("-agentlib:jdwp");
    private static List<Class<? extends Module>> moduleClasses;
    public static final Map<Class<? extends Module>, Module> moduleInstances;
    public static final Map<Class<? extends Feature>, Feature> featureInstances;
    public static final Map<String, Feature> featureClassnames;
    public static List<Module> enabledModules;
    public static final List<Runnable> lazyOreDictRegisters;
    public static Configuration config;
    public static File configFile;
    public static boolean firstLoad;

    private static void setupModuleClasses() {
        moduleClasses = new ArrayList<Class<? extends Module>>();
        ModuleLoader.registerModule(QuarkTweaks.class);
        ModuleLoader.registerModule(QuarkWorld.class);
        ModuleLoader.registerModule(QuarkVanity.class);
        ModuleLoader.registerModule(QuarkDecoration.class);
        ModuleLoader.registerModule(QuarkBuilding.class);
        ModuleLoader.registerModule(QuarkAutomation.class);
        ModuleLoader.registerModule(QuarkManagement.class);
        ModuleLoader.registerModule(QuarkClient.class);
        ModuleLoader.registerModule(QuarkMisc.class);
        if (Loader.isModLoaded((String)"quarkoddities")) {
            ModuleLoader.registerModule(QuarkOddities.class);
        }
        ModuleLoader.registerModule(QuarkExperimental.class);
    }

    public static void preInit(FMLPreInitializationEvent event) {
        ModuleLoader.setupModuleClasses();
        moduleClasses.forEach(clazz -> {
            try {
                Module instance = (Module)clazz.newInstance();
                if (!MinecraftForge.EVENT_BUS.post((Event)new ModuleLoadedEvent(instance))) {
                    moduleInstances.put((Class<? extends Module>)clazz, instance);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Can't initialize module " + clazz, e);
            }
        });
        ModuleLoader.setupConfig(event);
        ModuleLoader.forEachModule(module -> Quark.LOG.info("Module " + module.name + " is " + (module.enabled ? "enabled" : "disabled")));
        ModuleLoader.forEachEnabled(module -> module.preInit(event));
        ModuleLoader.forEachEnabled(module -> module.postPreInit());
        RecipeProcessor.runConsumers();
    }

    public static void init(FMLInitializationEvent event) {
        ModuleLoader.forEachEnabled(module -> module.init());
    }

    public static void postInit(FMLPostInitializationEvent event) {
        ModuleLoader.forEachEnabled(module -> module.postInit());
    }

    public static void finalInit(FMLPostInitializationEvent event) {
        ModuleLoader.forEachEnabled(module -> module.finalInit());
    }

    @SideOnly(value=Side.CLIENT)
    public static void preInitClient(FMLPreInitializationEvent event) {
        ModuleLoader.forEachEnabled(module -> module.preInitClient());
    }

    @SideOnly(value=Side.CLIENT)
    public static void initClient(FMLInitializationEvent event) {
        ModuleLoader.forEachEnabled(module -> module.initClient());
    }

    @SideOnly(value=Side.CLIENT)
    public static void postInitClient(FMLPostInitializationEvent event) {
        ModuleLoader.forEachEnabled(module -> module.postInitClient());
    }

    public static void serverStarting(FMLServerStartingEvent event) {
        ModuleLoader.forEachEnabled(module -> module.serverStarting());
    }

    public static void setupConfig(FMLPreInitializationEvent event) {
        configFile = event.getSuggestedConfigurationFile();
        if (!configFile.exists()) {
            firstLoad = true;
        }
        config = new Configuration(configFile);
        config.load();
        ModuleLoader.loadConfig();
    }

    public static void loadConfig() {
        GlobalConfig.initGlobalConfig();
        ModuleLoader.forEachModule(module -> {
            module.enabled = true;
            if (module.canBeDisabled()) {
                ConfigHelper.needsRestart = true;
                module.enabled = ConfigHelper.loadPropBool(module.name, "_modules", module.getModuleDescription(), module.isEnabledByDefault());
                module.prop = ConfigHelper.lastProp;
            }
        });
        enabledModules = new ArrayList<Module>(moduleInstances.values());
        enabledModules.removeIf(module -> !module.enabled);
        ModuleLoader.loadModuleConfigs();
        if (config.hasChanged()) {
            config.save();
        }
    }

    private static void loadModuleConfigs() {
        ModuleLoader.forEachModule(Module::setupConfig);
    }

    public static boolean isModuleEnabled(Class<? extends Module> clazz) {
        return ModuleLoader.moduleInstances.get(clazz).enabled;
    }

    public static boolean isFeatureEnabled(Class<? extends Feature> clazz) {
        return ModuleLoader.featureInstances.get(clazz).enabled;
    }

    public static void forEachModule(Consumer<Module> consumer) {
        moduleInstances.values().forEach(consumer);
    }

    public static void forEachEnabled(Consumer<Module> consumer) {
        enabledModules.forEach(consumer);
    }

    private static void registerModule(Class<? extends Module> clazz) {
        if (!moduleClasses.contains(clazz)) {
            moduleClasses.add(clazz);
        }
    }

    static {
        moduleInstances = new HashMap<Class<? extends Module>, Module>();
        featureInstances = new HashMap<Class<? extends Feature>, Feature>();
        featureClassnames = new HashMap<String, Feature>();
        lazyOreDictRegisters = new ArrayList<Runnable>();
    }

    @Mod.EventBusSubscriber(modid="quark")
    public static class EventHandler {
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
            if (eventArgs.getModID().equals("quark")) {
                ModuleLoader.loadConfig();
            }
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void onRegistered(RegistryEvent.Register<Item> event) {
            lazyOreDictRegisters.forEach(Runnable::run);
        }
    }
}

