/*
 * Decompiled with CFR 0.152.
 */
package net.crazysnailboy.mods.villagertrades.loaders;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.crazysnailboy.mods.villagertrades.VillagerTradesMod;
import net.crazysnailboy.mods.villagertrades.common.config.ModConfiguration;
import net.crazysnailboy.mods.villagertrades.common.registry.VillagerRegistryHelper;
import net.crazysnailboy.mods.villagertrades.nbt.JsonToNBT;
import net.crazysnailboy.mods.villagertrades.trades.CustomTrades;
import net.crazysnailboy.mods.villagertrades.trades.TradeHandlers;
import net.crazysnailboy.mods.villagertrades.util.FileUtils;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import org.apache.commons.lang3.ArrayUtils;

public class TradeLoader {
    public static void loadCustomTradeData() {
        HashMap<String, String> tradeFiles = FileUtils.createFileMap("trade_tables", ModConfiguration.loadTradesFromJar);
        for (String fileName : tradeFiles.keySet()) {
            String fileContents = tradeFiles.get(fileName);
            try {
                TradeLoader.loadTradesFromFile(fileContents);
            }
            catch (UnknownProfessionException ex) {
                VillagerTradesMod.LOGGER.error("Unknown profession \"" + ex.professionName + "\" in \"" + fileName + "\"");
            }
            catch (UnknownCareerException ex) {
                VillagerTradesMod.LOGGER.error("Unknown career \"" + ex.careerName + "\" in \"" + fileName + "\"");
            }
            catch (Exception ex) {
                VillagerTradesMod.LOGGER.catching((Throwable)ex);
            }
        }
    }

    private static void loadTradesFromFile(String fileContents) {
        JsonObject jsonObject = new JsonParser().parse(fileContents).getAsJsonObject();
        String jsonProfession = jsonObject.get("Profession").getAsString();
        String jsonCareer = jsonObject.get("Career").getAsString();
        VillagerRegistry.VillagerProfession profession = VillagerRegistryHelper.getProfession(jsonProfession);
        if (profession == null) {
            throw new UnknownProfessionException(jsonProfession);
        }
        VillagerRegistry.VillagerCareer career = new VillagerRegistryHelper.VTTVillagerProfession(profession).getCareer(jsonCareer);
        if (career == null) {
            throw new UnknownCareerException(jsonCareer);
        }
        JsonArray jsonRecipes = jsonObject.get("Offers").getAsJsonObject().get("Recipes").getAsJsonArray();
        for (JsonElement jsonRecipe : jsonRecipes) {
            int jsonCareerLevel;
            JsonObject jsonRecipeObject = jsonRecipe.getAsJsonObject();
            String jsonRecipeAction = jsonRecipeObject.get("action").getAsString();
            int n = jsonCareerLevel = jsonRecipeObject.has("CareerLevel") ? jsonRecipeObject.get("CareerLevel").getAsInt() : 0;
            if (jsonRecipeAction.equals("add")) {
                TradeLoader.addTradeToCareer(career, jsonCareerLevel, jsonRecipeObject);
                continue;
            }
            if (jsonRecipeAction.equals("remove")) {
                TradeLoader.removeTradeFromCareer(career, jsonCareerLevel, jsonRecipeObject);
                continue;
            }
            if (jsonRecipeAction.equals("replace")) {
                TradeLoader.removeTradeFromCareer(career, jsonCareerLevel, jsonRecipeObject);
                TradeLoader.addTradeToCareer(career, jsonCareerLevel, jsonRecipeObject);
                continue;
            }
            if (!jsonRecipeAction.equals("clear")) continue;
            if (jsonCareerLevel > 0) {
                TradeLoader.clearCareerTrades(career, jsonCareerLevel);
                continue;
            }
            TradeLoader.clearCareerTrades(career);
        }
        if (ModConfiguration.sortTrades) {
            TradeLoader.sortCareerTrades(career);
        }
    }

    private static void addTradeToCareer(VillagerRegistry.VillagerCareer career, int careerLevel, JsonObject jsonRecipeObject) {
        boolean isVillagerSelling;
        JsonElement jsonBuyElement = jsonRecipeObject.get("buy");
        JsonElement jsonBuyElementB = jsonRecipeObject.has("buyB") ? jsonRecipeObject.get("buyB") : null;
        JsonElement jsonSellElement = jsonRecipeObject.get("sell");
        CustomTrades.ExtraTradeData extraTradeData = new CustomTrades.ExtraTradeData();
        double d = extraTradeData.chance = jsonRecipeObject.has("chance") ? jsonRecipeObject.get("chance").getAsDouble() : 1.0;
        if (jsonRecipeObject.has("rewardExp")) {
            extraTradeData.rewardsExp = jsonRecipeObject.get("rewardExp").getAsBoolean();
        }
        if (jsonRecipeObject.has("maxUses")) {
            extraTradeData.maxTradeUses = jsonRecipeObject.get("maxUses").getAsInt();
        }
        ItemStacksAndPrices buy = TradeLoader.getItemStacksAndPrices(jsonBuyElement);
        ItemStacksAndPrices buyB = jsonBuyElementB != null ? TradeLoader.getItemStacksAndPrices(jsonBuyElementB) : null;
        ItemStacksAndPrices sell = TradeLoader.getItemStacksAndPrices(jsonSellElement);
        boolean isVillagerBuying = TradeLoader.containsCurrencyItems(sell.getItemStacks());
        boolean bl = isVillagerSelling = TradeLoader.containsCurrencyItems(buy.getItemStacks()) || buyB != null && TradeLoader.containsCurrencyItems(buyB.getItemStacks());
        if (isVillagerBuying) {
            career.addTrade(careerLevel, new EntityVillager.ITradeList[]{new CustomTrades.VTTVillagerBuyingTrade(buy, buyB, sell, extraTradeData)});
        } else if (isVillagerSelling) {
            career.addTrade(careerLevel, new EntityVillager.ITradeList[]{new CustomTrades.VTTVillagerSellingTrade(buy, buyB, sell, extraTradeData)});
        } else {
            career.addTrade(careerLevel, new EntityVillager.ITradeList[]{new CustomTrades.VTTVillagerTradeBase(buy, buyB, sell, extraTradeData)});
        }
    }

    private static void removeTradeFromCareer(VillagerRegistry.VillagerCareer career, int careerLevel, JsonObject jsonRecipeObject) {
        TradeHandlers.ITradeHandler handler;
        EntityVillager.ITradeList trade;
        ItemStack stack;
        JsonElement jsonBuyElement = jsonRecipeObject.get("buy");
        JsonElement jsonBuyElementB = jsonRecipeObject.has("buyB") ? jsonRecipeObject.get("buyB") : null;
        JsonElement jsonSellElement = jsonRecipeObject.get("sell");
        ItemStacksAndPrices buy = TradeLoader.getItemStacksAndPrices(jsonBuyElement);
        ItemStacksAndPrices buyB = jsonBuyElementB != null ? TradeLoader.getItemStacksAndPrices(jsonBuyElementB) : null;
        ItemStacksAndPrices sell = TradeLoader.getItemStacksAndPrices(jsonSellElement);
        boolean isVillagerBuying = TradeLoader.containsCurrencyItems(sell.getItemStacks());
        boolean isVillagerSelling = TradeLoader.containsCurrencyItems(buy.getItemStacks()) || buyB != null && TradeLoader.containsCurrencyItems(buyB.getItemStacks());
        List<EntityVillager.ITradeList> trades = new VillagerRegistryHelper.VTTVillagerCareer(career).getTrades(careerLevel);
        Iterator<EntityVillager.ITradeList> iterator = trades.iterator();
        if (isVillagerBuying) {
            stack = buy.getItemStacks().get(0);
            while (iterator.hasNext()) {
                ItemStack buyingStack;
                trade = iterator.next();
                handler = TradeHandlers.tradeHandlers.get(trade.getClass());
                if (handler == null || !(handler instanceof TradeHandlers.VTTVillagerBuyingHandler) || !ItemStack.func_179545_c((ItemStack)stack, (ItemStack)(buyingStack = ((TradeHandlers.VTTVillagerBuyingHandler)handler).getBuyingStack(trade)))) continue;
                iterator.remove();
            }
        }
        if (isVillagerSelling) {
            stack = sell.getItemStacks().get(0);
            while (iterator.hasNext()) {
                ItemStack sellingStack;
                trade = iterator.next();
                handler = TradeHandlers.tradeHandlers.get(trade.getClass());
                if (handler == null || !(handler instanceof TradeHandlers.VTTVillagerSellingHandler) || !ItemStack.func_179545_c((ItemStack)stack, (ItemStack)(sellingStack = ((TradeHandlers.VTTVillagerSellingHandler)handler).getSellingStack(trade)))) continue;
                iterator.remove();
            }
        }
    }

    private static void clearCareerTrades(VillagerRegistry.VillagerCareer career) {
        List<List<EntityVillager.ITradeList>> trades = new VillagerRegistryHelper.VTTVillagerCareer(career).getTrades();
        for (List<EntityVillager.ITradeList> careerTrades : trades) {
            careerTrades.clear();
        }
        trades.clear();
    }

    private static void clearCareerTrades(VillagerRegistry.VillagerCareer career, int careerLevel) {
        List<EntityVillager.ITradeList> trades = new VillagerRegistryHelper.VTTVillagerCareer(career).getTrades(careerLevel);
        trades.clear();
    }

    private static void sortCareerTrades(VillagerRegistry.VillagerCareer career) {
        List<List<EntityVillager.ITradeList>> trades = new VillagerRegistryHelper.VTTVillagerCareer(career).getTrades();
        for (List<EntityVillager.ITradeList> levelTrades : trades) {
            Collections.sort(levelTrades, new Comparator<EntityVillager.ITradeList>(){

                @Override
                public int compare(EntityVillager.ITradeList tradeA, EntityVillager.ITradeList tradeB) {
                    TradeHandlers.ITradeHandler handlerA = TradeHandlers.tradeHandlers.get(tradeA.getClass());
                    TradeHandlers.ITradeHandler handlerB = TradeHandlers.tradeHandlers.get(tradeB.getClass());
                    if (handlerA != null && handlerB != null) {
                        if (handlerA instanceof TradeHandlers.VTTVillagerBuyingHandler && handlerB instanceof TradeHandlers.VTTVillagerSellingHandler) {
                            return -1;
                        }
                        if (handlerA instanceof TradeHandlers.VTTVillagerSellingHandler && handlerB instanceof TradeHandlers.VTTVillagerBuyingHandler) {
                            return 1;
                        }
                    }
                    return 0;
                }
            });
        }
    }

    private static ItemStacksAndPrices getItemStacksAndPrices(JsonElement jsonTradeElement) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ArrayList<EntityVillager.PriceInfo> prices = new ArrayList<EntityVillager.PriceInfo>();
        if (jsonTradeElement.isJsonArray()) {
            JsonArray jsonArray = jsonTradeElement.getAsJsonArray();
            for (JsonElement jsonElement : jsonArray) {
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                String id = jsonObject.get("id").getAsString();
                ItemStack stack = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(id)));
                if (jsonObject.has("Damage")) {
                    stack.func_77964_b(jsonObject.get("Damage").getAsInt());
                }
                if (jsonObject.has("tag")) {
                    try {
                        String jsonString = jsonObject.get("tag").getAsJsonObject().toString();
                        NBTTagCompound compound = JsonToNBT.getTagFromJson(jsonString);
                        stack.func_77982_d(compound);
                    }
                    catch (NBTException ex) {
                        VillagerTradesMod.LOGGER.catching((Throwable)ex);
                    }
                }
                EntityVillager.PriceInfo price = null;
                if (jsonObject.has("Count")) {
                    int minPrice = jsonObject.get("Count").isJsonObject() ? jsonObject.get("Count").getAsJsonObject().get("min").getAsInt() : jsonObject.get("Count").getAsInt();
                    int maxPrice = jsonObject.get("Count").isJsonObject() ? jsonObject.get("Count").getAsJsonObject().get("max").getAsInt() : jsonObject.get("Count").getAsInt();
                    price = new EntityVillager.PriceInfo(minPrice, maxPrice);
                }
                stacks.add(stack);
                prices.add(price);
            }
        } else {
            JsonObject jsonObject = jsonTradeElement.getAsJsonObject();
            int length = 1;
            for (String memberName : new String[]{"id", "Count", "Damage", "tag"}) {
                if (!jsonObject.has(memberName) || !jsonObject.get(memberName).isJsonArray()) continue;
                length = jsonObject.get(memberName).getAsJsonArray().size();
                break;
            }
            boolean isIdArray = jsonObject.has("id") && jsonObject.get("id").isJsonArray();
            boolean isCountArray = jsonObject.has("Count") && jsonObject.get("Count").isJsonArray();
            boolean isDamageArray = jsonObject.has("Damage") && jsonObject.get("Damage").isJsonArray();
            boolean isTagArray = jsonObject.has("tag") && jsonObject.get("tag").isJsonArray();
            for (int i = 0; i < length; ++i) {
                JsonElement damageElement;
                JsonElement countElement;
                JsonElement idElement;
                JsonElement jsonElement = idElement = isIdArray ? jsonObject.get("id").getAsJsonArray().get(i) : jsonObject.get("id");
                JsonElement jsonElement2 = isCountArray ? jsonObject.get("Count").getAsJsonArray().get(i) : (countElement = jsonObject.has("Count") ? jsonObject.get("Count") : null);
                JsonElement jsonElement3 = isDamageArray ? jsonObject.get("Damage").getAsJsonArray().get(i) : (damageElement = jsonObject.has("Damage") ? jsonObject.get("Damage") : null);
                JsonElement tagElement = isTagArray ? jsonObject.get("tag").getAsJsonArray().get(i) : (jsonObject.has("tag") ? jsonObject.get("tag") : null);
                String id = idElement.getAsString();
                ItemStack stack = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(id)));
                if (damageElement != null) {
                    stack.func_77964_b(damageElement.getAsInt());
                }
                if (tagElement != null) {
                    try {
                        NBTTagCompound tag = JsonToNBT.getTagFromJson(tagElement.toString());
                        stack.func_77982_d(tag);
                    }
                    catch (NBTException ex) {
                        VillagerTradesMod.LOGGER.catching((Throwable)ex);
                    }
                }
                EntityVillager.PriceInfo price = null;
                if (countElement != null) {
                    int minPrice = countElement.isJsonObject() ? countElement.getAsJsonObject().get("min").getAsInt() : countElement.getAsInt();
                    int maxPrice = countElement.isJsonObject() ? countElement.getAsJsonObject().get("max").getAsInt() : countElement.getAsInt();
                    price = new EntityVillager.PriceInfo(minPrice, maxPrice);
                }
                stacks.add(stack);
                prices.add(price);
            }
        }
        return new ItemStacksAndPrices(stacks, prices);
    }

    private static boolean containsCurrencyItems(List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            String resourceName = ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack.func_77973_b())).toString();
            if (stack.func_77952_i() > 0) {
                resourceName = resourceName + "," + Integer.toString(stack.func_77952_i());
            }
            if (!ArrayUtils.contains((Object[])ModConfiguration.currencyItems, (Object)resourceName)) continue;
            return true;
        }
        return false;
    }

    public static class UnknownCareerException
    extends RuntimeException {
        public String careerName;

        public UnknownCareerException(String careerName) {
            this.careerName = careerName;
        }
    }

    public static class UnknownProfessionException
    extends RuntimeException {
        public String professionName;

        public UnknownProfessionException(String professionName) {
            this.professionName = professionName;
        }
    }

    public static class ItemStacksAndPrices {
        private List<ItemStack> stacks;
        private List<EntityVillager.PriceInfo> prices;

        public ItemStacksAndPrices(List<ItemStack> stacks, List<EntityVillager.PriceInfo> prices) {
            this.stacks = stacks;
            this.prices = prices;
        }

        public List<ItemStack> getItemStacks() {
            return this.stacks;
        }

        public List<EntityVillager.PriceInfo> getPrices() {
            return this.prices;
        }
    }
}

