/*
 * Decompiled with CFR 0.152.
 */
package prospector.traverse.world.biomes;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBlockBlob;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import prospector.traverse.config.TraverseConfig;
import prospector.traverse.world.WorldGenConstants;
import prospector.traverse.world.features.WorldGenFallenTree;

public class BiomeBadlands
extends Biome
implements WorldGenConstants {
    protected static final WorldGenFallenTree FALLEN_TREE_FEATURE = new WorldGenFallenTree(true);
    protected static final WorldGenBlockBlob COBBLESTONE_BOULDER_FEATURE = new WorldGenBlockBlob(Blocks.field_150347_e, 1);
    protected static final WorldGenLakes LAVA_LAKE_FEATURE = new WorldGenLakes((Block)Blocks.field_150353_l);
    public static Biome.BiomeProperties properties = new Biome.BiomeProperties("Badlands");

    public BiomeBadlands() {
        super(properties);
        this.field_76760_I.field_76832_z = 1;
        this.field_76760_I.field_189870_A = 4.0f;
        this.field_76760_I.field_76802_A = 0;
        this.field_76760_I.field_76803_B = 16;
        this.field_76762_K.clear();
        this.field_76762_K.add(new Biome.SpawnListEntry(EntitySheep.class, 4, 2, 4));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityPig.class, 3, 2, 4));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityChicken.class, 3, 2, 4));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityCow.class, 2, 2, 4));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityRabbit.class, 1, 2, 7));
    }

    public int getModdedBiomeGrassColor(int original) {
        return super.getModdedBiomeGrassColor(-2373764);
    }

    public int func_76731_a(float currentTemperature) {
        if (TraverseConfig.disableCustomSkies) {
            return super.func_76731_a(currentTemperature);
        }
        return -12650;
    }

    public int getModdedBiomeFoliageColor(int original) {
        return super.getModdedBiomeFoliageColor(-4013720);
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        int num = rand.nextInt(2);
        if (num == 0) {
            return new WorldGenShrub(OAK_LOG, OAK_LEAVES);
        }
        return field_76757_N;
    }

    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        if (noiseVal > 1.5) {
            this.field_76752_A = Blocks.field_150348_b.func_176223_P();
            this.field_76753_B = Blocks.field_150348_b.func_176223_P();
        } else {
            this.field_76752_A = Blocks.field_150349_c.func_176223_P();
            this.field_76753_B = Blocks.field_150346_d.func_176223_P();
        }
        this.func_180628_b(worldIn, rand, chunkPrimerIn, x, z, noiseVal);
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        int boulderChance;
        BlockPos blockpos;
        int l;
        int k6;
        int fallenTreeChance;
        if (TerrainGen.decorate((World)worldIn, (Random)rand, (BlockPos)pos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE) && (fallenTreeChance = rand.nextInt(3)) == 0) {
            k6 = rand.nextInt(16) + 8;
            l = rand.nextInt(16) + 8;
            blockpos = worldIn.func_175645_m(pos.func_177982_a(k6, 0, l));
            FALLEN_TREE_FEATURE.func_180709_b(worldIn, rand, blockpos);
        }
        if (!TraverseConfig.disallowBoulders && TerrainGen.decorate((World)worldIn, (Random)rand, (BlockPos)pos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.ROCK) && (boulderChance = rand.nextInt(5)) == 0) {
            k6 = rand.nextInt(16) + 8;
            l = rand.nextInt(16) + 8;
            blockpos = worldIn.func_175645_m(pos.func_177982_a(k6, 0, l));
            COBBLESTONE_BOULDER_FEATURE.func_180709_b(worldIn, rand, blockpos);
        }
        if (TerrainGen.decorate((World)worldIn, (Random)rand, (BlockPos)pos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_LAVA) && (boulderChance = rand.nextInt(12)) == 0) {
            k6 = rand.nextInt(16) + 8;
            l = rand.nextInt(16) + 8;
            blockpos = worldIn.func_175645_m(pos.func_177982_a(k6, 0, l));
            LAVA_LAKE_FEATURE.func_180709_b(worldIn, rand, blockpos);
        }
        if (TerrainGen.decorate((World)worldIn, (Random)rand, (BlockPos)pos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.GRASS)) {
            field_180280_ag.func_180710_a(BlockDoublePlant.EnumPlantType.GRASS);
            for (int i = 0; i < 7; ++i) {
                int j = rand.nextInt(16) + 8;
                int k = rand.nextInt(16) + 8;
                int l2 = rand.nextInt(worldIn.func_175645_m(pos.func_177982_a(j, 0, k)).func_177956_o() + 32);
                field_180280_ag.func_180709_b(worldIn, rand, pos.func_177982_a(j, l2, k));
            }
        }
        super.func_180624_a(worldIn, rand, pos);
    }

    static {
        properties.func_185410_a(0.6f);
        properties.func_185395_b(0.1f);
        properties.func_185398_c(0.6f);
        properties.func_185400_d(0.55f);
    }
}

