/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.chameleon.resources;

import com.jaquadro.minecraft.chameleon.Chameleon;
import com.jaquadro.minecraft.chameleon.resources.IItemMeshMapper;
import com.jaquadro.minecraft.chameleon.resources.IItemMeshResolver;
import com.jaquadro.minecraft.chameleon.resources.IItemVariantProvider;
import com.jaquadro.minecraft.chameleon.resources.register.IBlockModelRegister;
import com.jaquadro.minecraft.chameleon.resources.register.IItemModelRegister;
import com.jaquadro.minecraft.chameleon.resources.register.IUnifiedRegister;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public class ModelRegistry {
    private final Set<IBlockModelRegister> blockRegistry = new HashSet<IBlockModelRegister>();
    private final Set<IItemModelRegister> itemRegistry = new HashSet<IItemModelRegister>();
    public final ChamModelLoader loader = new ChamModelLoader();

    public void registerModel(IBlockModelRegister modelRegister) {
        if (modelRegister != null) {
            this.blockRegistry.add(modelRegister);
        }
    }

    public void registerModel(IItemModelRegister modelRegister) {
        if (modelRegister != null) {
            this.itemRegistry.add(modelRegister);
            this.registerItemVariants(modelRegister.getItem());
        }
    }

    public void registerModel(IUnifiedRegister modelRegister) {
        if (modelRegister != null) {
            this.blockRegistry.add(modelRegister);
            this.itemRegistry.add(modelRegister);
            this.registerItemVariants(modelRegister.getItem());
            this.registerTextureResources(modelRegister.getTextureResources());
        }
    }

    public void registerItemVariants(Block block) {
        if (block != null && Block.field_149771_c.func_148757_b((Object)block) != Block.func_149682_b((Block)Blocks.field_150350_a)) {
            Item item = Item.func_150898_a((Block)block);
            this.registerItemVariants(item);
        }
    }

    public void registerItemVariants(Item item) {
        if (item != null && item.getRegistryName() != null) {
            this.registerItemMapping(item);
            if (item instanceof IItemVariantProvider) {
                this.registerItemVariants(item, (IItemVariantProvider)item);
            } else if (item instanceof IItemMeshMapper) {
                this.registerItemVariants(item, (IItemMeshMapper)item);
            }
        }
    }

    public void registerItemVariants(Item item, IItemVariantProvider provider) {
        if (item != null && provider != null && item.getRegistryName() != null) {
            List<ResourceLocation> variants = ((IItemVariantProvider)item).getItemVariants();
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])variants.toArray(new ResourceLocation[variants.size()]));
        }
    }

    public void registerItemVariants(Item item, IItemMeshMapper mapper) {
        if (item != null && mapper != null && item.getRegistryName() != null) {
            ArrayList<Object> variants = new ArrayList<Object>();
            for (Pair<ItemStack, ModelResourceLocation> pair : mapper.getMeshMappings()) {
                variants.add(pair.getValue());
            }
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])variants.toArray(new ResourceLocation[variants.size()]));
        }
    }

    public void loadModels(IRegistry<ModelResourceLocation, IBakedModel> modelIRegistry) {
        int defaultBlockId = Block.func_149682_b((Block)Blocks.field_150350_a);
        for (IBlockModelRegister iBlockModelRegister : this.blockRegistry) {
            for (IBlockState state : iBlockModelRegister.getBlockStates()) {
                if (Block.field_149771_c.func_148757_b((Object)state.func_177230_c()) == defaultBlockId) continue;
                ModelResourceLocation location = ModelRegistry.getResourceLocation(state);
                modelIRegistry.func_82595_a((Object)location, (Object)iBlockModelRegister.getModel(state, (IBakedModel)modelIRegistry.func_82594_a((Object)location)));
            }
        }
        for (IItemModelRegister iItemModelRegister : this.itemRegistry) {
            Item item = iItemModelRegister.getItem();
            if (item.getRegistryName() == null) continue;
            for (ItemStack stack : iItemModelRegister.getItemVariants()) {
                ModelResourceLocation location = ModelRegistry.getResourceLocation(stack);
                modelIRegistry.func_82595_a((Object)location, (Object)iItemModelRegister.getModel(stack, (IBakedModel)modelIRegistry.func_82594_a((Object)location)));
            }
            this.registerItemMapping(item, iItemModelRegister);
        }
    }

    private void registerItemMapping(Item item) {
        this.registerItemMapping(item, null);
    }

    private void registerItemMapping(Item item, IItemModelRegister register) {
        if (item instanceof IItemMeshResolver) {
            ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)((IItemMeshResolver)item).getMeshResolver());
        } else if (register != null) {
            for (ItemStack stack : register.getItemVariants()) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)stack.func_77960_j(), (ModelResourceLocation)ModelRegistry.getResourceLocation(stack));
            }
        } else if (item instanceof IItemMeshMapper) {
            for (Pair<ItemStack, ModelResourceLocation> pair : ((IItemMeshMapper)item).getMeshMappings()) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)((ItemStack)pair.getKey()).func_77960_j(), (ModelResourceLocation)((ModelResourceLocation)pair.getValue()));
            }
        } else {
            NonNullList variants = NonNullList.func_191196_a();
            item.func_150895_a(item.func_77640_w(), variants);
            for (ItemStack stack : variants) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)stack.func_77960_j(), (ModelResourceLocation)ModelRegistry.getResourceLocation(stack));
            }
        }
    }

    private void registerTextureResources(List<ResourceLocation> resources) {
        for (ResourceLocation resource : resources) {
            Chameleon.instance.iconRegistry.registerIcon(resource);
        }
    }

    private static ModelResourceLocation getResourceLocation(IBlockState state) {
        ResourceLocation loc = state.func_177230_c().getRegistryName();
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : state.func_177228_b().entrySet()) {
            builder.append(((IProperty)entry.getKey()).func_177701_a()).append('=').append(((Comparable)entry.getValue()).toString()).append(',');
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return new ModelResourceLocation(loc, builder.toString());
    }

    private static ModelResourceLocation getResourceLocation(ItemStack stack) {
        Block block;
        Object resolver;
        Item item = stack.func_77973_b();
        if (item instanceof ItemMeshDefinition) {
            return ((ItemMeshDefinition)item).func_178113_a(stack);
        }
        if (item instanceof IItemMeshResolver && (resolver = ((IItemMeshResolver)item).getMeshResolver()) != null) {
            return resolver.func_178113_a(stack);
        }
        if (item instanceof IItemMeshMapper) {
            for (Pair pair : ((IItemMeshMapper)item).getMeshMappings()) {
                if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)((ItemStack)pair.getKey()))) continue;
                return (ModelResourceLocation)pair.getValue();
            }
        }
        if ((block = Block.func_149634_a((Item)item)) != Blocks.field_150350_a) {
            return new ModelResourceLocation(block.getRegistryName(), "inventory");
        }
        return new ModelResourceLocation(item.getRegistryName(), "inventory");
    }

    public class ChamModelLoader
    implements ICustomModelLoader {
        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.func_110623_a().contains("#");
        }

        public IModel loadModel(ResourceLocation modelLocation) throws Exception {
            return null;
        }

        public void func_110549_a(IResourceManager resourceManager) {
        }
    }
}

