/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.container;

import aroma1997.core.container.ICustomSlotClick;
import aroma1997.core.container.elements.ContainerElementBase;
import aroma1997.core.container.elements.ContainerElementHandheld;
import aroma1997.core.container.slot.SlotArmor;
import aroma1997.core.container.slot.SlotInventoryPart;
import aroma1997.core.inventory.ItemInventory;
import aroma1997.core.inventory.inventorypart.InventoryPartBase;
import aroma1997.core.network.NetworkHelper;
import aroma1997.core.network.packets.PacketContainerUpdate;
import aroma1997.core.util.ItemUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class ContainerBase<T extends IInventory>
extends Container {
    public final T inventory;
    public final EntityPlayer player;
    private List<ContainerElementBase<?>> elements = new ArrayList();
    private Boolean hasNetworkDataToSend;

    public ContainerBase(T inventory, EntityPlayer player) {
        this.inventory = inventory;
        this.player = player;
        inventory.func_174889_b(player);
        if (inventory instanceof ItemInventory) {
            this.addContainerElement(new ContainerElementHandheld(this));
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    protected void layoutArmorInventory(int x, int y, EntityPlayer player, boolean horizontal) {
        int xMultiplier = horizontal ? 1 : 0;
        int yMultiplier = horizontal ? 0 : 1;
        x += xMultiplier * 53;
        y += yMultiplier * 53;
        int idx = 0;
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            if (slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR) continue;
            this.func_75146_a(new SlotArmor(player, slot, x - xMultiplier * idx * 18, y - yMultiplier * idx * 18));
            ++idx;
        }
    }

    protected void layoutPlayerInventory(int x, int y, EntityPlayer player) {
        for (int col = 0; col < 9; ++col) {
            this.func_75146_a(new Slot((IInventory)player.field_71071_by, col, x + col * 18, y + 57));
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)player.field_71071_by, col + row * 9 + 9, x + col * 18, y + row * 18));
            }
        }
    }

    protected void layoutInventoryPart(InventoryPartBase part, int x, int y, int slotWidth) {
        for (int i = 0; i < part.func_70302_i_(); ++i) {
            this.func_75146_a(new SlotInventoryPart(part, i, x + i % slotWidth * 18 - 1, y + i / slotWidth * 18 - 1));
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.player instanceof EntityPlayerMP && this.hasNetworkDataToSend()) {
            NetworkHelper.getCorePacketHandler().sendPacketToPlayer((EntityPlayerMP)this.player, new PacketContainerUpdate(this));
        }
        this.elements.stream().forEach(ContainerElementBase::tick);
    }

    private boolean hasNetworkDataToSend() {
        if (this.hasNetworkDataToSend == null) {
            MutableBoolean hasChanged = new MutableBoolean(false);
            Predicate<Field> testPredicate = field -> {
                hasChanged.setTrue();
                return true;
            };
            new PacketContainerUpdate(this, NetworkHelper.ANNOTATION_ENCODE.and(testPredicate), NetworkHelper.ANNOTATION_GUI_ENCODE.and(testPredicate));
            this.hasNetworkDataToSend = hasChanged.getValue();
        }
        return this.hasNetworkDataToSend;
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot.field_75224_c == player.field_71071_by) {
            return this.playerSlotShiftClick(player, index, slot);
        }
        return this.invSlotShiftClick(player, index, slot);
    }

    protected ItemStack playerSlotShiftClick(EntityPlayer player, int index, Slot slot) {
        return this.generalShiftclick(player, slot, test -> test.field_75224_c != player.field_71071_by, false);
    }

    protected ItemStack invSlotShiftClick(EntityPlayer player, int index, Slot slot) {
        return this.generalShiftclick(player, slot, test -> test.field_75224_c == player.field_71071_by, false);
    }

    protected ItemStack generalShiftclick(EntityPlayer player, Slot slot, Predicate<Slot> target, boolean reversed) {
        ItemStack stack = slot.func_75211_c().func_77946_l();
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int count = stack.func_190916_E();
        block0: for (int allowEmpty = 0; allowEmpty < 2; ++allowEmpty) {
            for (int i = 0; i < this.field_75151_b.size(); ++i) {
                int index = reversed ? this.field_75151_b.size() - 1 - i : i;
                Slot targetSlot = (Slot)this.field_75151_b.get(index);
                if (target.test(targetSlot) && (stack = this.transferStackToSlot(stack, targetSlot, allowEmpty > 0)).func_190926_b()) break block0;
            }
        }
        if (count != stack.func_190916_E()) {
            slot.func_75209_a(count - stack.func_190916_E());
            slot.func_190901_a(player, stack);
        }
        return ItemStack.field_190927_a;
    }

    protected ItemStack transferStackToSlot(ItemStack stack, Slot slot, boolean allowEmpty) {
        if (!slot.func_75214_a(stack)) {
            return stack;
        }
        ItemStack stackInSlot = slot.func_75211_c();
        int maxStacksize = Math.min(slot.func_75219_a(), stack.func_77976_d());
        if (stackInSlot.func_190926_b() && allowEmpty) {
            ItemStack toAdd = stack.func_77946_l();
            toAdd.func_190920_e(Math.min(maxStacksize, stack.func_190916_E()));
            stack.func_190920_e(stack.func_190916_E() - toAdd.func_190916_E());
            slot.func_75215_d(toAdd);
        } else if (ItemUtil.areItemsSameMatching(stack, stackInSlot, ItemUtil.IItemMatchCriteria.ID, ItemUtil.IItemMatchCriteria.DAMAGE, ItemUtil.IItemMatchCriteria.NBT) && stackInSlot.func_190916_E() < maxStacksize) {
            int toAdd = Math.min(maxStacksize - stackInSlot.func_190916_E(), stack.func_190916_E());
            stackInSlot.func_190920_e(stackInSlot.func_190916_E() + toAdd);
            stack.func_190920_e(stack.func_190916_E() - toAdd);
            slot.func_75215_d(stackInSlot);
        }
        return stack;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        this.inventory.func_174886_c(player);
        for (ContainerElementBase<?> element : this.elements) {
            element.onClosed(player);
        }
    }

    public Iterable<ContainerElementBase<?>> getElements() {
        return this.elements;
    }

    public void addContainerElement(ContainerElementBase<?> element) {
        this.elements.add(element);
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickType, EntityPlayer player) {
        Slot slot;
        if (slotId >= 0 && slotId < this.field_75151_b.size() && (slot = this.func_75139_a(slotId)) instanceof ICustomSlotClick) {
            return ((ICustomSlotClick)slot).slotClick(dragType, clickType, player);
        }
        return super.func_184996_a(slotId, dragType, clickType, player);
    }
}

