/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.client.gui.elements;

import aroma1997.core.client.gui.DynamicTexture;
import aroma1997.core.client.gui.GuiBase;
import aroma1997.core.client.gui.elements.GuiElement;
import aroma1997.core.util.LocalizationHelper;
import java.util.function.IntSupplier;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiElementProgressBar
extends GuiElement {
    protected final int max;
    protected final IntSupplier current;

    public GuiElementProgressBar(GuiBase<?> gui, int x, int y, DynamicTexture texture, int max, IntSupplier current) {
        super(gui, x, y, texture.getBackground().getWidth(), texture.getBackground().getHeight());
        this.max = max;
        this.current = current;
        this.setTexture(texture.getRenderable(this::getProgress));
    }

    public void addProgressTooltip(String name) {
        this.addHoverTooltip(() -> LocalizationHelper.localizeFormatted(name, this.current.getAsInt(), this.max));
    }

    public double getProgress() {
        return (double)this.current.getAsInt() / (double)this.max;
    }
}

