/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.client.gui.elements;

import aroma1997.core.client.gui.GuiBase;
import aroma1997.core.client.gui.IRenderable;
import aroma1997.core.client.gui.elements.ILocationLookup;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiElement {
    protected final GuiBase<?> gui;
    protected ILocationLookup location;
    private List<Supplier<String>> tooltips = new ArrayList<Supplier<String>>();
    private IRenderable texture;

    public GuiElement(GuiBase<?> gui, int x, int y, int width, int height) {
        this(gui, ILocationLookup.get(x, y, width, height));
    }

    public GuiElement(GuiBase<?> gui, ILocationLookup location) {
        this.location = location;
        this.gui = gui;
    }

    public GuiElement(GuiBase<?> gui) {
        this(gui, null);
    }

    public final ILocationLookup getLocation() {
        return this.location;
    }

    public final boolean isIn(int x, int y) {
        return x >= this.location.getX() && y >= this.location.getY() && x < this.location.getX() + this.location.getWidth() && y < this.location.getY() + this.location.getHeight();
    }

    public void setTexture(IRenderable texture) {
        this.texture = texture;
    }

    public void addHoverTooltip(Supplier<String> tooltip) {
        this.tooltips.add(tooltip);
    }

    protected void onHoverOver(int x, int y) {
        ArrayList<String> actualTooltips = new ArrayList<String>();
        for (Supplier<String> supplier : this.tooltips) {
            actualTooltips.add(supplier.get());
        }
        this.gui.func_146283_a(actualTooltips, x, y);
        GlStateManager.func_179140_f();
    }

    public boolean onClick(int x, int y) {
        return false;
    }

    public void drawForegroundLayer(int x, int y) {
        x -= this.gui.getGuiLeft();
        y -= this.gui.getGuiTop();
        if (this.texture != null) {
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            this.texture.render(this.location.getX(), this.location.getY(), this.gui);
        }
    }

    public void drawOverlay(int x, int y) {
        if (this.isIn(x -= this.gui.getGuiLeft(), y -= this.gui.getGuiTop())) {
            this.onHoverOver(x, y);
        }
    }

    public void init() {
    }

    public Object getContainedObject() {
        return null;
    }
}

