/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.client;

import aroma1997.core.client.PlayerInfo;
import aroma1997.core.client.ThreadDownloadCape;
import aroma1997.core.log.LogHelperPre;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MiscStuff {
    private static HashMap<UUID, PlayerInfo> info = new HashMap();
    private static PlayerInfo EMPTY_PLAYERINFO = new PlayerInfo(UUID.randomUUID());

    public static void init() {
        new Thread(MiscStuff::load, "Aroma1997Core-InitThread").start();
    }

    private static void load() {
        try {
            JsonObject element = new JsonParser().parse((Reader)new InputStreamReader(new URL("https://files.aroma1997.org/mcmods/info.json").openStream())).getAsJsonObject();
            for (Map.Entry e : element.entrySet()) {
                if (((String)e.getKey()).startsWith("_")) continue;
                PlayerInfo info = MiscStuff.getPlayerInfoForModify((String)e.getKey());
                for (Map.Entry e1 : ((JsonElement)e.getValue()).getAsJsonObject().entrySet()) {
                    info.add((String)e1.getKey(), (JsonElement)e1.getValue());
                }
            }
        }
        catch (Exception e) {
            LogHelperPre.logException("Failed to initialize Client Stuff.", e);
        }
    }

    public static PlayerInfo getPlayerInfo(GameProfile name) {
        PlayerInfo playerInfo = info.get(name.getId());
        if (playerInfo == null) {
            playerInfo = EMPTY_PLAYERINFO;
        }
        return playerInfo;
    }

    public static PlayerInfo getPlayerInfoForModify(String name) {
        if (name.equals(".*")) {
            return EMPTY_PLAYERINFO;
        }
        UUID id = UUID.fromString(name);
        if (info.containsKey(id)) {
            return info.get(id);
        }
        PlayerInfo pinfo = new PlayerInfo(id);
        info.put(id, pinfo);
        return pinfo;
    }

    public static void reloadAll() {
        info.clear();
        MiscStuff.init();
        ThreadDownloadCape.resetThreads();
    }
}

