/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.bittank;

import com.google.common.base.Predicate;
import mod.chiselsandbits.bittank.TileEntityBitTank;
import mod.chiselsandbits.core.Log;
import mod.chiselsandbits.helpers.ExceptionNoTileEntity;
import mod.chiselsandbits.helpers.ModUtil;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BlockBitTank
extends Block
implements ITileEntityProvider {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)new Predicate<EnumFacing>(){

        public boolean apply(EnumFacing face) {
            return face != EnumFacing.DOWN && face != EnumFacing.UP;
        }
    });

    public BlockBitTank() {
        super(Material.field_151573_f);
        this.func_149672_a(SoundType.field_185853_f);
        this.field_149785_s = true;
        this.func_149713_g(0);
        this.func_149711_c(1.0f);
        this.setHarvestLevel("pickaxe", 0);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        try {
            return this.getTileEntity(world, pos).getLightValue();
        }
        catch (ExceptionNoTileEntity e) {
            Log.noTileError(e);
            return 0;
        }
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public float func_185485_f(IBlockState state) {
        return 1.0f;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public int func_176201_c(IBlockState state) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                return 0;
            }
            case SOUTH: {
                return 1;
            }
            case EAST: {
                return 2;
            }
            case WEST: {
                return 3;
            }
        }
        throw new RuntimeException("Invalid State.");
    }

    public IBlockState func_176203_a(int meta) {
        switch (meta) {
            case 0: {
                return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH);
            }
            case 1: {
                return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH);
            }
            case 2: {
                return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST);
            }
            case 3: {
                return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.WEST);
            }
        }
        throw new RuntimeException("Invalid State.");
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityBitTank();
    }

    public TileEntityBitTank getTileEntity(TileEntity te) throws ExceptionNoTileEntity {
        if (te instanceof TileEntityBitTank) {
            return (TileEntityBitTank)te;
        }
        throw new ExceptionNoTileEntity();
    }

    public TileEntityBitTank getTileEntity(IBlockAccess world, BlockPos pos) throws ExceptionNoTileEntity {
        return this.getTileEntity(world.func_175625_s(pos));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        try {
            TileEntityBitTank tank = this.getTileEntity((IBlockAccess)worldIn, pos);
            ItemStack current = ModUtil.nonNull(playerIn.field_71071_by.func_70448_g());
            if (!ModUtil.isEmpty(current)) {
                TileEntityBitTank wrappedTank = tank;
                if (FluidUtil.interactWithFluidHandler((EntityPlayer)playerIn, (EnumHand)hand, (IFluidHandler)wrappedTank)) {
                    return true;
                }
                if (tank.addHeldBits(current, playerIn)) {
                    return true;
                }
            } else if (tank.addAllPossibleBits(playerIn)) {
                return true;
            }
            if (tank.extractBits(playerIn, hitX, hitY, hitZ, pos)) {
                return true;
            }
        }
        catch (ExceptionNoTileEntity e) {
            Log.noTileError(e);
        }
        return false;
    }
}

