/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class WeightedRandomSelector<K, E> {
    private boolean dirty = true;
    private final Map<K, Float> keys = new HashMap<K, Float>();
    private float minChance = Float.MAX_VALUE;
    private float maxChance = Float.MIN_VALUE;
    private final Distribution<K> defaultDistribution = new Distribution();
    private final Map<K, List<E>> items = new HashMap<K, List<E>>();

    public void clear() {
        this.dirty = true;
        this.keys.clear();
        this.minChance = Float.MAX_VALUE;
        this.maxChance = Float.MIN_VALUE;
        this.defaultDistribution.reset();
        this.items.clear();
    }

    public void addRarity(K key, float chance) {
        this.keys.put(key, Float.valueOf(chance));
        this.items.put(key, new ArrayList());
        if (chance < this.minChance) {
            this.minChance = chance;
        }
        if (chance > this.maxChance) {
            this.maxChance = chance;
        }
        this.dirty = true;
    }

    public void addItem(K key, E item) {
        this.items.get(key).add(item);
        this.dirty = true;
    }

    private void distribute() {
        if (this.dirty) {
            this.dirty = false;
            this.setupDistribution(this.defaultDistribution, 0.0f);
        }
    }

    private void setupDistribution(Distribution<K> distribution, float bonus) {
        float add = bonus * (this.maxChance - this.minChance);
        distribution.reset();
        for (Map.Entry<K, Float> entry : this.keys.entrySet()) {
            K key = entry.getKey();
            int length = this.items.get(key).size();
            float chance = (entry.getValue().floatValue() + add) * (float)length;
            distribution.addKey(key, chance);
        }
    }

    public Distribution<K> createDistribution(float bonus) {
        Distribution distribution = new Distribution();
        this.setupDistribution(distribution, bonus);
        return distribution;
    }

    public E select(Distribution<K> distribution, Random random) {
        this.distribute();
        float r = random.nextFloat() * distribution.getTotalChance() - 1.0E-4f;
        Object key = null;
        for (Map.Entry<K, Float> entry : distribution.getKeysChance().entrySet()) {
            if (!((r -= entry.getValue().floatValue()) <= 0.0f) || this.items.get(entry.getKey()).isEmpty()) continue;
            key = entry.getKey();
            break;
        }
        List<E> list = this.items.get(key);
        return list.get(random.nextInt(list.size()));
    }

    public E select(Random random) {
        return this.select(this.defaultDistribution, random);
    }

    public static class Distribution<K> {
        private final Map<K, Float> keysChance = new HashMap<K, Float>();
        private float totalChance = 0.0f;

        public Map<K, Float> getKeysChance() {
            return this.keysChance;
        }

        public float getTotalChance() {
            return this.totalChance;
        }

        public void reset() {
            this.keysChance.clear();
            this.totalChance = 0.0f;
        }

        public void addKey(K key, float chance) {
            this.keysChance.put(key, Float.valueOf(chance));
            this.totalChance += chance;
        }
    }
}

