/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import javax.annotation.Nullable;
import mcjty.lib.api.power.IBigPower;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.IEnergyItem;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(modid="tesla", iface="net.darkhax.tesla.api.ITeslaConsumer"), @Optional.Interface(modid="tesla", iface="net.darkhax.tesla.api.ITeslaHolder"), @Optional.Interface(modid="tesla", iface="net.darkhax.tesla.api.ITeslaProducer")})
public class ItemCapabilityProvider
implements ICapabilityProvider,
IBigPower,
ITeslaHolder,
ITeslaConsumer,
ITeslaProducer {
    private final ItemStack itemStack;
    private final IEnergyItem item;
    private final IEnergyStorage energyStorage = new IEnergyStorage(){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return (int)ItemCapabilityProvider.this.item.receiveEnergyL(ItemCapabilityProvider.this.itemStack, maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return (int)ItemCapabilityProvider.this.item.extractEnergyL(ItemCapabilityProvider.this.itemStack, maxExtract, simulate);
        }

        public int getEnergyStored() {
            return EnergyTools.getIntEnergyStored(ItemCapabilityProvider.this.item.getEnergyStoredL(ItemCapabilityProvider.this.itemStack), ItemCapabilityProvider.this.item.getMaxEnergyStoredL(ItemCapabilityProvider.this.itemStack));
        }

        public int getMaxEnergyStored() {
            return EnergyTools.unsignedClampToInt(ItemCapabilityProvider.this.item.getMaxEnergyStoredL(ItemCapabilityProvider.this.itemStack));
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }
    };

    public ItemCapabilityProvider(ItemStack itemStack, IEnergyItem item) {
        this.itemStack = itemStack;
        this.item = item;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || capability == EnergyTools.TESLA_HOLDER || capability == EnergyTools.TESLA_CONSUMER || capability == EnergyTools.TESLA_PRODUCER;
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.energyStorage;
        }
        if (capability == EnergyTools.TESLA_HOLDER || capability == EnergyTools.TESLA_CONSUMER || capability == EnergyTools.TESLA_PRODUCER) {
            return (T)this;
        }
        return null;
    }

    @Override
    public long getStoredPower() {
        return this.item.getEnergyStoredL(this.itemStack);
    }

    @Override
    public long getCapacity() {
        return this.item.getMaxEnergyStoredL(this.itemStack);
    }

    public long takePower(long power, boolean simulated) {
        return this.item.extractEnergyL(this.itemStack, power, simulated);
    }

    public long givePower(long power, boolean simulated) {
        return this.item.receiveEnergyL(this.itemStack, power, simulated);
    }
}

