/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import io.netty.buffer.ByteBuf;
import mcjty.lib.gui.GuiStyle;
import mcjty.lib.network.SendPreferencesToClientHelper;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSendPreferencesToClient
implements IMessage {
    private int buffX;
    private int buffY;
    private GuiStyle style;

    public void fromBytes(ByteBuf buf) {
        this.buffX = buf.readInt();
        this.buffY = buf.readInt();
        this.style = GuiStyle.values()[buf.readInt()];
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.buffX);
        buf.writeInt(this.buffY);
        buf.writeInt(this.style.ordinal());
    }

    public PacketSendPreferencesToClient() {
    }

    public PacketSendPreferencesToClient(int buffX, int buffY, GuiStyle style) {
        this.buffX = buffX;
        this.buffY = buffY;
        this.style = style;
    }

    public int getBuffX() {
        return this.buffX;
    }

    public int getBuffY() {
        return this.buffY;
    }

    public GuiStyle getStyle() {
        return this.style;
    }

    public static class Handler
    implements IMessageHandler<PacketSendPreferencesToClient, IMessage> {
        public IMessage onMessage(PacketSendPreferencesToClient message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> SendPreferencesToClientHelper.setPreferences(message));
            return null;
        }
    }
}

