/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.container;

import java.util.Objects;
import java.util.function.Predicate;
import mcjty.lib.container.SlotType;
import net.minecraft.item.ItemStack;

public class SlotDefinition {
    private final SlotType type;
    private final Predicate<ItemStack> validItems;

    public SlotDefinition(SlotType type, ItemStack ... itemStacks) {
        this.type = type;
        this.validItems = stack -> {
            for (ItemStack itemStack : itemStacks) {
                if (itemStack.func_77973_b() != stack.func_77973_b()) continue;
                return true;
            }
            return false;
        };
    }

    public SlotDefinition(SlotType type, Class<?> itemClass) {
        this.type = type;
        this.validItems = stack -> itemClass != null && itemClass.isInstance(stack.func_77973_b());
    }

    public SlotDefinition(SlotType type, Predicate<ItemStack> validItems) {
        this.type = type;
        this.validItems = validItems;
    }

    public SlotType getType() {
        return this.type;
    }

    public boolean itemStackMatches(ItemStack stack) {
        return this.validItems.test(stack);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlotDefinition that = (SlotDefinition)o;
        return this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type});
    }
}

