/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.util;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import thebetweenlands.common.TheBetweenlands;

public class TexturePacker {
    private final ResourceLocation textureName;
    private final List<TextureQuadMap> textureMaps;
    private final Map<ResourceLocation, BufferedImage> cachedTextures = new HashMap<ResourceLocation, BufferedImage>();
    private final List<TextureBin> textureBins = new ArrayList<TextureBin>();
    private int packedTextureID = 0;
    private final BufferedImage missingTexture;
    private int optimalFootprint;
    private int packedFootprint;

    public TexturePacker(ResourceLocation textureName) {
        this(textureName, new ArrayList<TextureQuadMap>());
    }

    public TexturePacker(ResourceLocation textureName, List<TextureQuadMap> textureMaps) {
        this.textureName = textureName;
        this.textureMaps = textureMaps;
        this.missingTexture = new BufferedImage(16, 16, 2);
        System.arraycopy(TextureUtil.field_111001_a.func_110565_c(), 0, ((DataBufferInt)this.missingTexture.getRaster().getDataBuffer()).getData(), 0, 256);
    }

    public void addTextureMap(TextureQuadMap map) {
        this.textureMaps.add(map);
    }

    public List<TextureQuadMap> getTextureMaps() {
        return this.textureMaps;
    }

    protected ResourceLocation generateNewTextureLocation() {
        ResourceLocation rl = new ResourceLocation(this.textureName.func_110624_b(), this.textureName.func_110623_a() + "_" + this.packedTextureID);
        ++this.packedTextureID;
        return rl;
    }

    protected BufferedImage getOrLoadTexture(ResourceLocation location, IResourceManager manager) {
        BufferedImage cached = this.cachedTextures.get(location);
        if (cached == null) {
            try (IResource resource = manager.func_110536_a(new ResourceLocation(location.func_110624_b(), "textures/" + location.func_110623_a() + ".png"));){
                cached = ImageIO.read(resource.func_110527_b());
                this.cachedTextures.put(location, cached);
            }
            catch (IOException e) {
                TheBetweenlands.logger.error("Failed loading model texture to pack. Location: " + location, (Throwable)e);
                cached = this.missingTexture;
                this.cachedTextures.put(location, cached);
            }
        }
        return cached;
    }

    public Map<ResourceLocation, BufferedImage> pack(IResourceManager manager) {
        this.optimalFootprint = 0;
        this.packedFootprint = 0;
        ArrayList<TextureQuad> quads = new ArrayList<TextureQuad>();
        HashMap<TextureQuad, BufferedImage> textures = new HashMap<TextureQuad, BufferedImage>();
        for (TextureQuadMap map : this.textureMaps) {
            BufferedImage sourceImage = this.getOrLoadTexture(map.texture, manager);
            for (TextureQuad quad : map.getQuads()) {
                quad.rescale((float)sourceImage.getWidth() / (float)map.width, (float)sourceImage.getHeight() / (float)map.height);
                textures.put(quad, sourceImage);
            }
            quads.addAll(map.getQuads());
        }
        Collections.sort(quads, (q1, q2) -> ((TextureQuad)q2).h - ((TextureQuad)q1).h);
        for (TextureQuad quad : quads) {
            this.optimalFootprint += quad.sw * quad.sh;
            boolean packed = false;
            BufferedImage sourceImage = (BufferedImage)textures.get(quad);
            for (TextureBin bin : this.textureBins) {
                if (!this.packIntoBin(quad, bin, sourceImage)) continue;
                packed = true;
                break;
            }
            if (packed) continue;
            int dimension = Math.max(16, Math.max(quad.sw, quad.sh));
            int binSize = 1 << 32 - Integer.numberOfLeadingZeros(dimension - 1);
            TextureBin bin = new TextureBin(this.generateNewTextureLocation(), binSize, binSize);
            this.textureBins.add(bin);
            this.packedFootprint += binSize * binSize;
            if (this.packIntoBin(quad, bin, sourceImage)) continue;
            throw new RuntimeException("Was unable to pack texture quad into new bin. This should not happen!");
        }
        HashMap<ResourceLocation, BufferedImage> packedTextures = new HashMap<ResourceLocation, BufferedImage>();
        for (TextureBin bin : this.textureBins) {
            packedTextures.put(bin.location, bin.image);
        }
        this.packedTextureID = 0;
        this.cachedTextures.clear();
        this.textureBins.clear();
        return packedTextures;
    }

    protected static void copySubImage(BufferedImage source, int x, int y, int w, int h, BufferedImage dest, int x2, int y2) {
        int sourceWidth = source.getWidth();
        int sourceHeight = source.getHeight();
        for (int py = 0; py < h; ++py) {
            for (int px = 0; px < w; ++px) {
                int sx = ((x + px) % sourceWidth + sourceWidth) % sourceWidth;
                int sy = ((y + py) % sourceHeight + sourceHeight) % sourceHeight;
                dest.setRGB(x2 + px, y2 + py, source.getRGB(sx, sy));
            }
        }
    }

    protected boolean packIntoBin(TextureQuad quad, TextureBin bin, BufferedImage sourceImage) {
        List spaces = bin.spaces;
        for (int i = spaces.size() - 1; i >= 0; --i) {
            TextureBin.Space space = (TextureBin.Space)spaces.get(i);
            if (quad.sw > space.w || quad.sh > space.h) continue;
            int packedU = space.x;
            int packedV = space.y;
            TexturePacker.copySubImage(sourceImage, quad.su, quad.sv, quad.sw, quad.sh, bin.image, packedU, packedV);
            quad.packedU = (double)packedU / (double)bin.width;
            quad.packedV = (double)packedV / (double)bin.height;
            quad.packedMaxU = (double)(packedU + quad.sw) / (double)bin.width;
            quad.packedMaxV = (double)(packedV + quad.sh) / (double)bin.height;
            quad.packedLocation = bin.location;
            if (quad.sw == space.w && quad.sh == space.h) {
                spaces.remove(i);
            } else if (quad.sh == space.h) {
                TextureBin.Space space2 = space;
                space2.x = space2.x + quad.sw;
                space2 = space;
                space2.w = space2.w - quad.sw;
            } else if (quad.sw == space.w) {
                TextureBin.Space space3 = space;
                space3.y = space3.y + quad.sh;
                space3 = space;
                space3.h = space3.h - quad.sh;
            } else {
                spaces.add(new TextureBin.Space(space.x + quad.sw, space.y, space.w - quad.sw, quad.sh));
                TextureBin.Space space4 = space;
                space4.y = space4.y + quad.sh;
                space4 = space;
                space4.h = space4.h - quad.sh;
            }
            return true;
        }
        return false;
    }

    public int getOptimalFootprint() {
        return this.optimalFootprint;
    }

    public int getPackedFootprint() {
        return this.packedFootprint;
    }

    private static class TextureBin {
        private final ResourceLocation location;
        private final BufferedImage image;
        private final int width;
        private final int height;
        private final List<Space> spaces = new ArrayList<Space>();

        protected TextureBin(ResourceLocation location, int width, int height) {
            this.location = location;
            this.width = width;
            this.height = height;
            this.image = new BufferedImage(width, height, 2);
            this.spaces.add(new Space(0, 0, width, height));
        }

        private static class Space {
            private int x;
            private int y;
            private int w;
            private int h;

            private Space(int x, int y, int w, int h) {
                this.x = x;
                this.y = y;
                this.w = w;
                this.h = h;
            }
        }
    }

    public static class TextureQuad {
        private final int u;
        private final int v;
        private final int w;
        private final int h;
        private int su;
        private int sv;
        private int sw;
        private int sh;
        private double packedU;
        private double packedV;
        private double packedMaxU;
        private double packedMaxV;
        private ResourceLocation packedLocation;

        public TextureQuad(int u, int v, int width, int height) {
            this.su = this.u = u;
            this.sv = this.v = v;
            this.sw = this.w = width;
            this.sh = this.h = height;
        }

        public double getPackedU() {
            return this.packedU;
        }

        public double getPackedV() {
            return this.packedV;
        }

        public double getPackedMaxU() {
            return this.packedMaxU;
        }

        public double getPackedMaxV() {
            return this.packedMaxV;
        }

        public ResourceLocation getPackedLocation() {
            return this.packedLocation;
        }

        public void rescale(float scaleU, float scaleV) {
            this.su = (int)Math.floor((float)this.u * scaleU);
            this.sv = (int)Math.floor((float)this.v * scaleV);
            this.sw = (int)Math.floor((float)this.w * scaleU);
            this.sh = (int)Math.floor((float)this.h * scaleV);
        }
    }

    public static class TextureQuadMap {
        private final List<TextureQuad> quads;
        private final ITexturePackable owner;
        private final ResourceLocation texture;
        private final int width;
        private final int height;

        public TextureQuadMap(ResourceLocation texture, int width, int height, List<TextureQuad> quads, @Nullable ITexturePackable owner) {
            this.texture = texture;
            this.width = width;
            this.height = height;
            this.quads = quads;
            this.owner = owner;
        }

        public List<TextureQuad> getQuads() {
            return this.quads;
        }

        @Nullable
        public ITexturePackable getOwner() {
            return this.owner;
        }
    }

    public static interface ITexturePackable {
        public void onPacked();
    }
}

